/*
 * Decompiled with CFR 0.152.
 */
package at.itsv.kfoqsdb.model.dao.impl;

import at.itsv.kfoqsdb.model.dao.AbstractDao;
import at.itsv.tools.dao.GenericDaoImpl;
import at.itsv.tools.model.AbstractEntity;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.EntityGraph;
import javax.persistence.TypedQuery;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Join;
import javax.persistence.criteria.JoinType;
import javax.persistence.criteria.Order;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import org.slf4j.Logger;

public abstract class AbstractDaoImpl<ENTITY extends AbstractEntity, ID extends Serializable>
extends GenericDaoImpl<ENTITY, ID>
implements AbstractDao<ENTITY, ID> {
    protected abstract Logger getLog();

    protected Predicate handleCriterion(AbstractDao.Criterion crit, Root<ENTITY> root, CriteriaBuilder cb) {
        int indexOf = crit.getColumnName().indexOf(".");
        if (-1 != indexOf) {
            String objName = crit.getColumnName().substring(0, indexOf);
            String colName = crit.getColumnName().substring(indexOf + 1);
            Join join = root.join(objName, JoinType.LEFT);
            join.alias(objName);
            if (crit.getColumnValue() == null) {
                return cb.isNull((Expression)join.get(colName));
            }
            switch (crit.getCriterionType()) {
                case eq: {
                    return cb.equal((Expression)join.get(colName), crit.getColumnValue());
                }
                case like: {
                    return cb.like((Expression)join.get(colName), String.valueOf(crit.getColumnValue()));
                }
            }
            throw new RuntimeException("FATAL: programming error");
        }
        if (crit.getColumnValue() == null) {
            return cb.isNull((Expression)root.get(crit.getColumnName()));
        }
        switch (crit.getCriterionType()) {
            case eq: {
                return cb.equal((Expression)root.get(crit.getColumnName()), crit.getColumnValue());
            }
            case like: {
                return cb.like((Expression)root.get(crit.getColumnName()), String.valueOf(crit.getColumnValue()));
            }
        }
        throw new RuntimeException("FATAL: programming error");
    }

    protected Order handleOrder(AbstractDao.Order order, Root<ENTITY> root, CriteriaBuilder cb) {
        int indexOf = order.getColumnName().indexOf(".");
        if (-1 != indexOf) {
            String objName = order.getColumnName().substring(0, indexOf);
            String colName = order.getColumnName().substring(indexOf + 1);
            Join join = root.join(objName, JoinType.LEFT);
            join.alias(objName);
            if (order.isAscending()) {
                return cb.asc((Expression)join.get(colName));
            }
            return cb.desc((Expression)join.get(colName));
        }
        if (order.isAscending()) {
            return cb.asc((Expression)root.get(order.getColumnName()));
        }
        return cb.desc((Expression)root.get(order.getColumnName()));
    }

    protected TypedQuery<ENTITY> buildBaseCriteria(Class<ENTITY> entityClass, List<AbstractDao.Criterion> criterions, List<AbstractDao.Order> orders) {
        int indexOf;
        this.getLog().debug("buildBaseCriteria() - start: entityClass: {}", entityClass);
        CriteriaBuilder cb = this.getEntityManager().getCriteriaBuilder();
        CriteriaQuery cq = cb.createQuery(entityClass);
        Root root = cq.from(entityClass);
        cq = cq.select((Selection)root);
        EntityGraph graph = null;
        if (criterions != null && !criterions.isEmpty()) {
            ArrayList<Predicate> predicates = new ArrayList<Predicate>();
            for (AbstractDao.Criterion crit : criterions) {
                indexOf = crit.getColumnName().indexOf(".");
                if (-1 != indexOf) {
                    if (graph == null) {
                        graph = this.getEntityManager().createEntityGraph(entityClass);
                    }
                    graph.addSubgraph(crit.getColumnName().substring(0, indexOf));
                }
                predicates.add(this.handleCriterion(crit, root, cb));
            }
            cq = cq.where(predicates.toArray(new Predicate[predicates.size()]));
        }
        if (orders != null && !orders.isEmpty()) {
            ArrayList<Order> pOrders = new ArrayList<Order>();
            for (AbstractDao.Order order : orders) {
                indexOf = order.getColumnName().indexOf(".");
                if (-1 != indexOf) {
                    if (graph == null) {
                        graph = this.getEntityManager().createEntityGraph(entityClass);
                    }
                    graph.addSubgraph(order.getColumnName().substring(0, indexOf));
                }
                pOrders.add(this.handleOrder(order, root, cb));
            }
            cq = cq.orderBy(pOrders);
        }
        TypedQuery query = this.getEntityManager().createQuery(cq);
        if (graph != null) {
            query.setHint("javax.persistence.fetchgraph", graph);
        }
        return query;
    }

    @Override
    public List<ENTITY> getByCriteria(Class<ENTITY> entityClass, List<AbstractDao.Criterion> criterions, List<AbstractDao.Order> orders) {
        this.getLog().debug("getByCriteria() - start");
        TypedQuery<ENTITY> query = this.buildBaseCriteria(entityClass, criterions, orders);
        List entities = query.getResultList();
        this.getLog().debug("getByCriteria() - end");
        return entities;
    }

    @Override
    public List<ENTITY> getByCriteria(Class<ENTITY> entityClass, List<AbstractDao.Criterion> criterions, List<AbstractDao.Order> orders, int startIndex, int pageSize) {
        this.getLog().debug("getByCriteria - start: startIndex {}; pageSize {}", (Object)startIndex, (Object)pageSize);
        TypedQuery<ENTITY> query = this.buildBaseCriteria(entityClass, criterions, orders);
        query.setFirstResult(startIndex);
        query.setMaxResults(pageSize);
        List entities = query.getResultList();
        this.getLog().debug("findByCriteriaPaged() - end");
        return entities;
    }

    @Override
    public int countByCriteria(Class<ENTITY> entityClass, List<AbstractDao.Criterion> criterions) {
        this.getLog().debug("countByCriteria() - start");
        TypedQuery<ENTITY> query = this.buildBaseCriteria(entityClass, criterions, null);
        int totalCount = query.getResultList().size();
        this.getLog().debug("countByCriteria() - finished, count is {}", (Object)totalCount);
        return totalCount;
    }
}

