/*
 * Decompiled with CFR 0.152.
 */
package at.itsv.kfoqsdb.model.dao.impl;

import at.itsv.kfoqsdb.data.entities.Notification;
import at.itsv.kfoqsdb.model.dao.AbstractDao;
import at.itsv.kfoqsdb.model.dao.NotificationDao;
import at.itsv.kfoqsdb.model.dao.impl.AbstractDaoImpl;
import at.itsv.tools.logging.SLF4J;
import at.itsv.tools.model.AbstractBaseEntity;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.ejb.Stateless;
import javax.inject.Inject;
import org.slf4j.Logger;

@Stateless
public class NotificationDaoImpl
extends AbstractDaoImpl<Notification, Long>
implements NotificationDao,
Serializable {
    @Inject
    @SLF4J
    private Logger log;

    @Override
    protected Logger getLog() {
        return this.log;
    }

    public Class getManagedClass() {
        return Notification.class;
    }

    @Override
    public void saveOrUpdate(Notification notification) {
        this.log.debug("saveOrUpdate() - start");
        if (notification.getId() == null) {
            this.log.debug("saveOrUpdate() - saving new notification");
            this.save((AbstractBaseEntity)notification);
        } else {
            this.log.debug("saveOrUpdate() - updating existing notification with id: {}", (Object)notification.getId());
            this.update((AbstractBaseEntity)notification);
        }
        this.log.debug("saveOrUpdate() - end");
    }

    @Override
    public List<Notification> getNotificationsForTraeger(String traegerCode) {
        ArrayList<AbstractDao.Criterion> criterions = new ArrayList<AbstractDao.Criterion>();
        criterions.add(AbstractDao.Criterion.eq("traeger", traegerCode));
        ArrayList<AbstractDao.Order> orders = new ArrayList<AbstractDao.Order>();
        orders.add(AbstractDao.Order.desc("erstelldatum"));
        orders.add(AbstractDao.Order.desc("id"));
        return this.getByCriteria(Notification.class, (List<AbstractDao.Criterion>)criterions, (List<AbstractDao.Order>)orders);
    }

    @Override
    public int countUnreadNotificationsForTraeger(String traegerCode) {
        ArrayList<AbstractDao.Criterion> criterions = new ArrayList<AbstractDao.Criterion>();
        criterions.add(AbstractDao.Criterion.eq("traeger", traegerCode));
        criterions.add(AbstractDao.Criterion.eq("gelesen", false));
        return this.countByCriteria(Notification.class, (List<AbstractDao.Criterion>)criterions);
    }
}

