/*
 * Decompiled with CFR 0.152.
 */
package at.itsv.kfoqsdb.model.dao.impl;

import at.itsv.kfoqsdb.data.entities.InvolvierteTraeger;
import at.itsv.kfoqsdb.data.entities.QsEintrag;
import at.itsv.kfoqsdb.data.entities.dto.ClearingDTO;
import at.itsv.kfoqsdb.internal.enums.LeistungsartEnum;
import at.itsv.kfoqsdb.model.dao.AbstractDao;
import at.itsv.kfoqsdb.model.dao.QsEintragDao;
import at.itsv.kfoqsdb.model.dao.impl.AbstractDaoImpl;
import at.itsv.tools.logging.SLF4J;
import at.itsv.tools.model.AbstractBaseEntity;
import java.io.Serializable;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import javax.ejb.Stateless;
import javax.inject.Inject;
import javax.persistence.EntityGraph;
import javax.persistence.TypedQuery;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Order;
import javax.persistence.criteria.Path;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import javax.persistence.criteria.Subquery;
import org.slf4j.Logger;

@Stateless
public class QsEintragDaoImpl
extends AbstractDaoImpl<QsEintrag, Long>
implements QsEintragDao,
Serializable {
    @Inject
    @SLF4J
    private Logger log;

    @Override
    public Logger getLog() {
        return this.log;
    }

    public Class<QsEintrag> getManagedClass() {
        return QsEintrag.class;
    }

    @Override
    public void saveOrUpdate(QsEintrag qsEintrag) {
        this.log.debug("saveOrUpdate() - start");
        if (qsEintrag.getId() == null) {
            this.log.debug("saveOrUpdate() - saving new qsEintrag");
            this.save((AbstractBaseEntity)qsEintrag);
        } else {
            this.log.debug("saveOrUpdate() - updating existing qsEintrag with id: {}", (Object)qsEintrag.getId());
            this.update((AbstractBaseEntity)qsEintrag);
        }
        this.log.debug("saveOrUpdate() - end");
    }

    @Override
    public boolean isReadable(String vsnr, String traegerCode) {
        String queryString = "select case when exists (select distinct \"VsNr\" from kfoqsdb.\"QsEintrag\" where \"VsNr\" = '" + vsnr + "' and (\"QSTraeger\" = '" + traegerCode + "' or \"LZTraeger\" = '" + traegerCode + "' or \"ABRTraeger\" = '" + traegerCode + "'))Then CAST(1 AS BIT) ELSE CAST(0 AS BIT) END";
        return (Boolean)this.getEntityManager().createNativeQuery(queryString).getSingleResult();
    }

    private TypedQuery<QsEintrag> buildQsEntriesVisibleForTraegerCriteria(List<AbstractDao.Criterion> criterions, List<AbstractDao.Order> orders, String traegerCode) {
        CriteriaBuilder cb = this.getEntityManager().getCriteriaBuilder();
        CriteriaQuery cq = cb.createQuery(QsEintrag.class);
        Root rootQs = cq.from(QsEintrag.class);
        ArrayList<Predicate> predicates = new ArrayList<Predicate>();
        EntityGraph graph = null;
        if (criterions != null && !criterions.isEmpty()) {
            for (AbstractDao.Criterion crit : criterions) {
                int indexOf = crit.getColumnName().indexOf(".");
                if (-1 != indexOf) {
                    if (graph == null) {
                        graph = this.getEntityManager().createEntityGraph(QsEintrag.class);
                    }
                    graph.addSubgraph(crit.getColumnName().substring(0, indexOf));
                }
                predicates.add(this.handleCriterion(crit, rootQs, cb));
            }
        }
        Subquery userSubQuery = cq.subquery(InvolvierteTraeger.class);
        Root rootIt = userSubQuery.from(InvolvierteTraeger.class);
        userSubQuery = userSubQuery.select((Expression)rootIt).where((Expression)cb.equal((Expression)rootIt.get("traegerCode"), (Object)traegerCode));
        Path exp = rootQs.get("vsnr");
        Predicate userSub = exp.in(new Expression[]{userSubQuery});
        predicates.add(userSub);
        ArrayList<Order> pOrders = new ArrayList<Order>();
        if (orders != null && !orders.isEmpty()) {
            for (AbstractDao.Order order : orders) {
                int indexOf = order.getColumnName().indexOf(".");
                if (-1 != indexOf) {
                    if (graph == null) {
                        graph = this.getEntityManager().createEntityGraph(QsEintrag.class);
                    }
                    graph.addSubgraph(order.getColumnName().substring(0, indexOf));
                }
                pOrders.add(this.handleOrder(order, rootQs, cb));
            }
        }
        cq = cq.select((Selection)rootQs).where(predicates.toArray(new Predicate[predicates.size()]));
        if (!pOrders.isEmpty()) {
            cq = cq.orderBy(pOrders);
        }
        TypedQuery query = this.getEntityManager().createQuery(cq);
        if (graph != null) {
            query.setHint("javax.persistence.fetchgraph", (Object)graph);
        }
        return query;
    }

    @Override
    public List<QsEintrag> getQsEntriesVisibleForTraeger(List<AbstractDao.Criterion> criterions, List<AbstractDao.Order> orders, String traegerCode) {
        this.getLog().debug("getQsEntriesVisibleForTraeger - start: traegerCode {}", (Object)traegerCode);
        if (orders == null) {
            orders = new ArrayList<AbstractDao.Order>();
        }
        orders.add(AbstractDao.Order.asc("id"));
        TypedQuery<QsEintrag> criteria = this.buildQsEntriesVisibleForTraegerCriteria(criterions, orders, traegerCode);
        List entities = criteria.getResultList();
        this.getLog().debug("getQsEntriesVisibleForTraeger() - end");
        return entities;
    }

    @Override
    public List<ClearingDTO> getDuplicateQsEntriesForTraeger(String traegerCode) {
        this.getLog().debug("getDuplicateQsEntriesForTraeger - start: traegerCode {}", (Object)traegerCode);
        String clearingDTOclass = ClearingDTO.class.getName();
        String sql = "select new " + clearingDTOclass + "( \"Leistungsart\", \"VpNr\", \"VsNr\", \"ABRTraeger\") from kfoqsdb.\"QsEintrag\"\nWHERE \"StornoDatum\" IS NULL AND \"ABRTraeger\" ='" + traegerCode + "' group by 1,2,3,4\nhaving count(*) > 1";
        List list = this.getEntityManager().createQuery(sql, ClearingDTO.class).getResultList();
        this.getLog().debug("getDuplicateQsEntriesForTraeger() - end");
        return list;
    }

    @Override
    public List<QsEintrag> getQsEntriesVisibleForTraeger(List<AbstractDao.Criterion> criterions, List<AbstractDao.Order> orders, int startIndex, int pageSize, String traegerCode) {
        this.getLog().debug("getQsEntriesVisibleForTraeger - start: startIndex {}; pageSize {}; traegerCode {}", new Object[]{startIndex, pageSize, traegerCode});
        if (orders == null) {
            orders = new ArrayList<AbstractDao.Order>();
        }
        orders.add(AbstractDao.Order.asc("id"));
        TypedQuery<QsEintrag> criteria = this.buildQsEntriesVisibleForTraegerCriteria(criterions, orders, traegerCode);
        criteria.setFirstResult(startIndex);
        criteria.setMaxResults(pageSize);
        List entities = criteria.getResultList();
        this.getLog().debug("getQsEntriesVisibleForTraeger() - end");
        return entities;
    }

    @Override
    public int countQsEntriesVisibleForTraeger(List<AbstractDao.Criterion> criterions, String traegerCode) {
        this.getLog().debug("countQsEntriesVisibleForTraeger() - start");
        TypedQuery<QsEintrag> criteria = this.buildQsEntriesVisibleForTraegerCriteria(criterions, null, traegerCode);
        int totalCount = criteria.getResultList().size();
        this.getLog().debug("countQsEntriesVisibleForTraeger() - finished, count is {}", (Object)totalCount);
        return totalCount;
    }

    @Override
    public List<QsEintrag> getQsByKey(String vsnr, String vpnr, String abrTraeger, LeistungsartEnum leistungsart) {
        return this.getEntityManager().createNamedQuery("KFOQSDB.getUnique").setParameter("vsnr", (Object)vsnr).setParameter("vpnr", (Object)vpnr).setParameter("abrTraeger", (Object)abrTraeger).setParameter("leistungsart", (Object)leistungsart.getLeistungsartCode()).getResultList();
    }

    @Override
    public long countQsByKey(String vsnr, String vpnr, String abrTraeger, LeistungsartEnum leistungsart) {
        return ((BigInteger)this.getEntityManager().createNamedQuery("KFOQSDB.countUnique").setParameter("vsnr", (Object)vsnr).setParameter("vpnr", (Object)vpnr).setParameter("abrTraeger", (Object)abrTraeger).setParameter("leistungsart", (Object)leistungsart.getLeistungsartCode()).getSingleResult()).longValue();
    }

    @Override
    public void detachEntity(Object o) {
        this.getEntityManager().detach(o);
    }

    @Override
    public List<QsEintrag> getQsForSearch(List<AbstractDao.Criterion> criterions, List<AbstractDao.Order> orders) {
        TypedQuery<QsEintrag> criteria = this.buildBaseCriteria(QsEintrag.class, criterions, orders);
        return criteria.getResultList();
    }
}

