/*
 * Decompiled with CFR 0.152.
 */
package at.itsv.kfoqsdb.model.dao.impl;

import at.itsv.kfoqsdb.data.entities.ReportType;
import at.itsv.kfoqsdb.internal.enums.ReportTypeEnum;
import at.itsv.kfoqsdb.model.dao.ReportTypeDao;
import at.itsv.kfoqsdb.model.dao.impl.AbstractDaoImpl;
import at.itsv.kfoqsdb.transformer.AliasToEntityOrderedMapResultTransformer;
import at.itsv.tools.logging.SLF4J;
import at.itsv.tools.model.AbstractBaseEntity;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import org.hibernate.query.Query;
import org.hibernate.transform.ResultTransformer;
import org.slf4j.Logger;

public class ReportTypeDaoImpl
extends AbstractDaoImpl<ReportType, Long>
implements ReportTypeDao,
Serializable {
    @Inject
    @SLF4J
    private Logger log;

    @Override
    protected Logger getLog() {
        return this.log;
    }

    public Class getManagedClass() {
        return ReportType.class;
    }

    @Override
    public void saveOrUpdate(ReportType report) {
        this.log.debug("saveOrUpdate() - start");
        if (report.getId() == null) {
            this.log.debug("saveOrUpdate() - saving new notification");
            this.save((AbstractBaseEntity)report);
        } else {
            this.log.debug("saveOrUpdate() - updating existing report with id: {}", (Object)report.getId());
            this.update((AbstractBaseEntity)report);
        }
        this.log.debug("saveOrUpdate() - end");
    }

    @Override
    public List<Map<String, Object>> executeSQLForReport(String statement, String traeger) {
        statement = statement.replace("?", traeger);
        Query sqlQuery = (Query)this.getEntityManager().createNativeQuery(statement).unwrap(Query.class);
        sqlQuery.setResultTransformer((ResultTransformer)AliasToEntityOrderedMapResultTransformer.INSTANCE);
        return sqlQuery.list();
    }

    @Override
    public List<ReportType> getReportsByRoleAndType(ReportTypeEnum reportTypeEnum, List<String> rollen) {
        StringBuilder stringBuilder = new StringBuilder("SELECT DISTINCT rt.\"ID\" AS \"id\", rt.\"Erstelldatum\" as \"erstelldatum\", rt.\"type\" as \"type\", rt.\"role\" as \"role\", rt.\"name\" as \"name\", rt.\"version\" as \"version\", rt.\"personenbezug\" as \"personenbezug\", rt.\"sql\" as \"sql\" FROM kfoqsdb.reporttype rt INNER JOIN kfoqsdb.rw r ON r.rwname = rt.role WHERE ");
        if (rollen.size() > 1) {
            stringBuilder.append("(");
        }
        stringBuilder.append("r.rwvalue = '" + rollen.get(0) + "' ");
        for (int i = 1; i < rollen.size(); ++i) {
            stringBuilder.append("OR r.rwvalue = '" + rollen.get(i) + "' ");
            if (i != rollen.size() - 1) continue;
            stringBuilder.append(") ");
        }
        stringBuilder.append("AND type = '" + reportTypeEnum + "' ");
        return this.getEntityManager().createNativeQuery(stringBuilder.toString(), ReportType.class).getResultList();
    }
}

