/*
 * Decompiled with CFR 0.152.
 */
package at.itsv.kfoqsdb.data.entities.validation.costum;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

public abstract class VersicherungsnummerValidator {
    private static final int[] FAKTORENREIHE = new int[]{3, 7, 9, 5, 8, 4, 2, 1, 6};
    private static final int[] VPNR_FAKTORENREIHE = new int[]{3, 7, 5, 1, 6};
    private static final int LENGTH = 10;
    private static final int VPNR_LENGTH = 6;
    private static final int MODULO = 11;
    private static final String MONTH_FINGIERT1 = "13";
    private static final String MONTH_FINGIERT2 = "14";
    private static final String MONTH_FINGIERT3 = "15";

    public static boolean validateVSNR(String nummer) {
        return VersicherungsnummerValidator.isValidLength(nummer) && VersicherungsnummerValidator.isNumeric(nummer) && VersicherungsnummerValidator.isValidVsnrLaufnummer(nummer) && VersicherungsnummerValidator.isValidChecksum(nummer) && VersicherungsnummerValidator.isValidDate(nummer);
    }

    public static boolean validateBTNR(String nummer) {
        return VersicherungsnummerValidator.isValidLength(nummer) && VersicherungsnummerValidator.isNumeric(nummer) && VersicherungsnummerValidator.isValidBtnrLaufnummer(nummer) && VersicherungsnummerValidator.isValidChecksum(nummer) && VersicherungsnummerValidator.isFirstCharNil(nummer) && VersicherungsnummerValidator.isValidDate(nummer);
    }

    public static boolean validateVPNR(String nummer) {
        return VersicherungsnummerValidator._validateVPNR(nummer);
    }

    private static boolean isValidDate(String svnr) {
        try {
            VersicherungsnummerValidator.getGeburtsdatum(svnr);
            return true;
        }
        catch (ParseException e) {
            return false;
        }
    }

    private static boolean isValidLength(String svnr) {
        return svnr.length() == 10;
    }

    private static boolean isNumeric(String svnr) {
        try {
            Long.parseLong(svnr);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    private static boolean isFirstCharNil(String btnr) {
        return "0".equals(btnr.substring(0, 1));
    }

    private static boolean isValidVsnrLaufnummer(String svnr) {
        String laufnummer = svnr.substring(0, 3);
        int laufnummerInt = Integer.parseInt(laufnummer);
        return laufnummerInt >= 100;
    }

    private static boolean isValidBtnrLaufnummer(String btnr) {
        String laufnummer = btnr.substring(1, 3);
        int laufnummerInt = Integer.parseInt(laufnummer);
        return laufnummerInt > 10;
    }

    private static boolean isValidChecksum(String nummer) {
        int sum = VersicherungsnummerValidator.factorizeAndSum(nummer.substring(0, 3) + nummer.substring(4), FAKTORENREIHE);
        int rest = sum % 11;
        return rest == VersicherungsnummerValidator.getPruefziffer(nummer);
    }

    private static int factorizeAndSum(String svnrOhnePruefziffer, int[] faktorenreihe) {
        int sum = 0;
        for (int i = 0; i < svnrOhnePruefziffer.length(); ++i) {
            sum += Integer.parseInt(svnrOhnePruefziffer.substring(i, i + 1)) * faktorenreihe[i];
        }
        return sum;
    }

    private static Date getGeburtsdatum(String svnr) throws ParseException {
        String birthDate = svnr.substring(4);
        String month = birthDate.substring(2, 4);
        if (MONTH_FINGIERT1.equalsIgnoreCase(month) || MONTH_FINGIERT2.equalsIgnoreCase(month) || MONTH_FINGIERT3.equalsIgnoreCase(month)) {
            birthDate = birthDate.substring(0, 2) + "12" + birthDate.substring(4);
        }
        SimpleDateFormat format = new SimpleDateFormat("ddMMyy");
        format.setLenient(false);
        return format.parse(birthDate);
    }

    private static int getPruefziffer(String svnr) {
        return Integer.parseInt(svnr.substring(3, 4));
    }

    private static final int calcVPNRRest(String value) {
        int sum = 0;
        for (int i = 0; i < value.length() - 1; ++i) {
            sum += Character.getNumericValue(value.charAt(i)) * VPNR_FAKTORENREIHE[i];
        }
        return sum % 11;
    }

    private static final boolean _validateVPNR(String value) {
        if (value == null) {
            return false;
        }
        if ((value = value.trim()).length() != 6 || !value.matches("^\\d{6}$")) {
            return false;
        }
        int pz = Character.getNumericValue(value.charAt(5));
        int rest = VersicherungsnummerValidator.calcVPNRRest(value);
        boolean valid = false;
        if (rest < 10) {
            boolean bl = valid = pz == rest;
            if (!valid) {
                if ((rest += 5) >= 10) {
                    rest %= 10;
                }
                valid = pz == rest;
            }
        } else {
            rest = 5;
            valid = pz == rest;
        }
        return valid;
    }
}

