--UID:           1.6.1_20200317
--NAME:          1.6.1_kfoqsdb-update.sql
--VERSION:       1.06.01.00
--DESCRIPTION:   UPDATE

ALTER TABLE kfoqsdb.ge1001 ADD COLUMN IF NOT EXISTS export_ts TIMESTAMP without time zone;

CREATE INDEX IF NOT EXISTS idx_ge1001_export_ts ON kfoqsdb.ge1001(export_ts);
CREATE INDEX IF NOT EXISTS idx_ge1001_datumprotokoll ON kfoqsdb.ge1001(datumprotokoll);

DO $$ BEGIN
if NOT exists (select constraint_name from information_schema.table_constraints where table_name = 'rw' and constraint_type = 'PRIMARY KEY') then

ALTER TABLE kfoqsdb.rw ADD PRIMARY KEY (id);

end if;
END $$;

SET search_path TO kfoqsdb,public;

-- Report-Definitionen nach KFOQSDBREPDEF, exportiert 11.01.2023 16:01:41
-- QS-Reporting
-- Requirements: https://doku.seu.sozvers.at/confluence_secure/display/KFOQSDB/%5BANF04%5D+-+Auswertungen
-- Version 1.6.0.4
-- Historie:
-- 1.6.0.3: QSE_BEENDET inkludiert auch IB, 
--          REE filtert nur nach IB (ErfolgsannahmeErreicht nur dort gültig), 
--          REE_CNT Korrektur AnzahlErfolgreich, 
--          RPI nur HB-Fälle,
--          QSE_BEENDET=>RPI Rang per Leistungsart
-- 1.6.0.4: V_QSE_BEENDET hat nun auch ein "Beginndatum"
-- Auswertungsdefinitionen KFOQSDB V 1.6.0.4
-- Definition von Basis-QS-Views für die KFOQSDB
-- view V_QSE_BEENDET selects all beendete Cases ranked by newest Endedatum
-- ranking uses window functions in PostgreSQL: https://www.postgresql.org/docs/9.1/static/tutorial-window.html
drop view if exists V_QSE_BEENDET CASCADE;
create or replace view V_QSE_BEENDET as
select	p."VpNr" as "ParterVpNr",p."PartnerName",qse.*,
		(CASE WHEN qse."Leistungsart"='HB' THEN coalesce(qse."HBDatumBehandlungsbeginnLE",coalesce(qse."IndikationDatumLE",coalesce(qse."IOTNDatumLE",to_date('20000101','YYYYMMDD'))))
			  WHEN qse."Leistungsart"='IB' THEN coalesce(qse."IndikationDatumLE",coalesce(qse."IOTNDatumLE",to_date('20170101','YYYYMMDD')))
			  WHEN qse."Leistungsart"='IF' THEN coalesce(qse."IndikationDatumLE",coalesce(qse."IOTNDatumLE",to_date('20170101','YYYYMMDD')))
			  ELSE to_date('20000102','YYYYMMDD') END) as "Beginndatum",
		(CASE WHEN qse."Behandlungsabbruch" is not null THEN qse."Behandlungsabbruch" 
		 ELSE (CASE WHEN qse."Leistungsart"='HB' THEN qse."HBDatumBehandlungsendeLE"
		            WHEN qse."Leistungsart"='IB' THEN qse."IBBehandlungsendeLE"
		            WHEN qse."Leistungsart"='IF' THEN null
		            ELSE qse."HBDatumBehandlungsendeLE" END)
		 END) as "Endedatum",
		rank() OVER (PARTITION BY qse."VpNr" 
					 ORDER BY (CASE WHEN qse."Behandlungsabbruch" is not null THEN qse."Behandlungsabbruch" 
		                            WHEN qse."IBBehandlungsendeLE" is not null THEN qse."IBBehandlungsendeLE"
		                            ELSE qse."HBDatumBehandlungsendeLE" END) DESC) as "Rang",
		rank() OVER (PARTITION BY qse."VpNr",qse."Leistungsart" 
					 ORDER BY (CASE WHEN qse."Behandlungsabbruch" is not null THEN qse."Behandlungsabbruch" 
		                            WHEN qse."IBBehandlungsendeLE" is not null THEN qse."IBBehandlungsendeLE"
		                            ELSE qse."HBDatumBehandlungsendeLE" END) DESC) as "LeistungsartRang",
		(CASE WHEN qse."Behandlungsabbruch" is not null THEN 'ABBRUCH' ELSE '' END) as "Abbruch",
		(CASE WHEN qse."PARAnfangswert" is null THEN null        
		      WHEN qse."PARAnfangswert"=0 THEN null
			  ELSE (((qse."PARAnfangswert"-qse."PAREndwert")+0.0)/(0.0+qse."PARAnfangswert")*100.0) END) as "PARVerbesserungProzent",
		SUBSTR(qse."IOTNLE",1,1) as "IOTNGradLE",
        SUBSTR(qse."IOTNQS",1,1) as "IOTNGradQS"
  from "QsEintrag" qse
    left outer join "Partner" p on p."VpNr"=qse."VpNr"  
 where qse."StornoDatum" is null and         
       ((qse."Leistungsart"='HB' and 
	   (qse."HBDatumBehandlungsendeLE" is not null or qse."Behandlungsabbruch" is not null)) or
	   (qse."Leistungsart"='IB' and (qse."IBBehandlungsendeLE" is not null or qse."Behandlungsabbruch" is not null)) or
	   (qse."Leistungsart"='IF' and (qse."Behandlungsabbruch" is not null)))
 order by p."VpNr" asc, qse."HBDatumBehandlungsendeLE" desc;
alter view V_QSE_BEENDET owner to kfoqsdb;
-- Test-Prozedur: 
-- select qse."VpNr",qse."PartnerName",qse."VsNr",qse."Leistungsart", qse."Behandlungsabbruch", qse."HBDatumBehandlungsendeLE", 
--                qse."Rang", qse,"LeistungsartRang", qse."PARAnfangswert",qse."PAREndwert",qse."Abbruch",qse."PARVerbesserungProzent"  from V_QSE_BEENDET qse order by qse."VpNr" asc, qse."Rang", qse."LeistungsartRang" asc
-- Definition der KFOQSDB-Auswertung RIF - Auswertung Fehlerquote IOTN/Indikation [ANF0401.01]
drop view if exists V_QSE_BELASTCALY cascade;
-- V_QSE_BELASTCALY selektiert alle QSE aus V_QSE_BEENDET, die im vorangegangenen Kalenderjahr (Kalenderjahr zum Zeitpunkt der Abfrage -1) beendet wurden
-- zusätzlich markiert es sie im Feld IFmitHBimGleichenJahr mit 'GleichesJahrHB', wenn es sich um einen IF-Fall handelt und beim selben Behandler(VPNR) und demselben Patienten(VSNR) eine HB begonnen wurde
create or replace view V_QSE_BELASTCALY as 
select qbe.*,
       (CASE WHEN qbe."Leistungsart"='IF' 
              and (select count(*) from "QsEintrag" qse 
                    where qse."VpNr"=qbe."VpNr" 
                      and qse."VsNr"=qbe."VsNr"
                      and qse."Leistungsart"='HB'
                      and (extract(year from qse."HBDatumBehandlungsbeginnLE") = extract(year from qbe."Endedatum"))
                  )>0 THEN 'GleichesJahrHB'
             ELSE '' END) as "IFmitHBimGleichenJahr"
  from v_qse_beendet qbe
 where extract (year from qbe."Endedatum") = (extract(year from now())-1);
alter view V_QSE_BELASTCALY owner to kfoqsdb;
-- Test-Prozedur: 
-- select * from V_QSE_BELASTCALY
-- Test-Prozedur: 
-- select "Endedatum",* from V_QSE_BELASTCALY
drop view if exists V_QSE_RIF cascade;
-- V_QSE_RIF ergänzt alle QSE aus V_QSE_BELASTCALY mit:
-- - FehlerIndikation: '1' wenn IndikationQS='x', ausser bei IFmitHBimGleichenJahr, sonst '0'
-- - FehlerIOTN: '1' wenn IOTN:  LE:4/5 QS:3/2/1 oder LE:5 QS:4/3/2/1 oder LE:4 QS:5 oder LE:3 QS:2/1, sonst '0'
create or replace view V_QSE_RIF as
  select blcy."ID",blcy."VpNr",blcy."Leistungsart",
    (CASE WHEN blcy."IFmitHBimGleichenJahr"='GleichesJahrHB' THEN 0
          WHEN blcy."IndikationQS"='x' THEN 1
          ELSE 0 END) as "FehlerIndikation",
    (CASE WHEN blcy."IFmitHBimGleichenJahr"='GleichesJahrHB' THEN 0
          WHEN ((blcy."IOTNGradLE" in ('4','5')) and (blcy."IOTNGradQS" in ('3','2','1'))) THEN 1
          WHEN ((blcy."IOTNGradLE"='5') and (blcy."IOTNGradQS"='4')) THEN 0
          WHEN ((blcy."IOTNGradLE"='4') and (blcy."IOTNGradQS"='5')) THEN 0
          WHEN ((blcy."IOTNGradLE"='3') and (blcy."IOTNGradQS" in ('2','1'))) THEN 1
          ELSE 0 END) as "FehlerIOTN"
    from V_QSE_BELASTCALY blcy;
alter view V_QSE_RIF owner to kfoqsdb;
drop view if exists V_QSE_RFI_CNT;
-- V_QSE_RFI_CNT zählt zu jedem Behandler(VPNR) pro Leistungsart aus V_QSE_RIF:
-- - gesamte Anzahl von Behandlungen
-- - Anzahl der IOTN-Fehler
-- - Anzahl der Indikation-Fehler
create or replace view V_QSE_RFI_CNT as
  select qri."VpNr",p."PartnerName",
    qri."Leistungsart",
         count(qri.*) as "AnzahlBehandlungen",
         sum("FehlerIOTN") as "AnzahlIOTNFehler",
         sum("FehlerIndikation") as "AnzahlIndikationFehler"
    from V_QSE_RIF qri
      left outer join "Partner" p on p."VpNr"=qri."VpNr" 
    group by qri."VpNr", p."PartnerName",qri."Leistungsart";
alter view V_QSE_RFI_CNT owner to kfoqsdb;
-- Test-Prozedur: 
-- select * from V_QSE_RFI_CNT
drop view if exists V_QSE_RFI_PFC cascade;
-- V_QSE_RFI_PFC fasst aus V_QSE_RFI_CNT zusammen (über alle Leistungsarten):
-- - Anzahl Behandlungen Summe
-- - Anzahl IOTN-Fehler
-- - Anzahl Indikation-Fehler
-- - Anzahl Gesamtfehler
-- - Fehler-Prozent aus AnzahlGesamtfehler zu AnzahlBehandlungen
create or replace view V_QSE_RFI_PFC as
  select qic."VpNr", qic."PartnerName",
    sum(qic."AnzahlBehandlungen") as "AnzahlFälle",
         sum(qic."AnzahlIOTNFehler") as "AnzahlIOTNFehler",
         sum(qic."AnzahlIndikationFehler") as "AnzahlIndikationFehler",
         sum(qic."AnzahlIOTNFehler")+sum(qic."AnzahlIndikationFehler") as "AnzahlGesamtFehler",
         sum(qic."AnzahlIOTNFehler")+sum(qic."AnzahlIndikationFehler") / sum(qic."AnzahlBehandlungen") * 100 as "FehlerProzent"
    from V_QSE_RFI_CNT qic 
   group by qic."VpNr",qic."PartnerName";
alter view V_QSE_RFI_PFC owner to kfoqsdb;
-- Test-Prozedur: 
-- select * from V_QSE_RFI_PFC
drop view if exists V_AuswertungFehlerquoteIOTNIndikation;
-- V_AuswertungFehlerquoteIOTNIndikation selektiert aus V_QSE_RFI_PFC alle Behandler mit einer Fehlerquote von mehr als 5%
create or replace view V_AuswertungFehlerquoteIOTNIndikation as
  select pfc.*
    from V_QSE_RFI_PFC pfc
   where pfc."FehlerProzent">5;
alter view V_AuswertungFehlerquoteIOTNIndikation owner to kfoqsdb;
-- Test-Prozedur: 
-- select * from V_AuswertungFehlerquoteIOTNIndikation
-- Definition von KFOQSDB report "Auswertung Fehlerquote IOTN/Indikation": alte Definition(en) werden "hidden", neue angelegt
update "reporttype" set "name"='hidden_Auswertung Fehlerquote IOTN/Indikation',"role"='INVISIBLE' where "name"='Auswertung Fehlerquote IOTN/Indikation' and type = 'USER';
insert into "reporttype"("sql",      "version",	"Erstelldatum", "role",		"type",	"name",		"personenbezug")
values('select * from V_AuswertungFehlerquoteIOTNIndikation',  1,			NOW(),          'SB',	'USER',	'Auswertung Fehlerquote IOTN/Indikation',	true);
-- Definition der KFOQSDB-Auswertung REE - Auswertung Erreichung Erfolgsannahme, [ANF0401.02]
drop view if exists V_QSE_REE_CNT cascade;
-- V_QSE_REE_CNT zählt pro Behandler(VPNR) zu allen QSE mit Leistungsart IB (nur dort gilt "ErfolgsannahmeErreicht"):
-- - Anzahl aller Behandlungen
-- - Anzahl der Behandlungen mit ErfolgsannahmeErreicht
create or replace view V_QSE_REE_CNT as
  select blcy."VpNr", blcy."PartnerName",
         count(*) as "AnzahlBehandlungen",
         (select count(*) from V_QSE_BELASTCALY be where be."VpNr"=blcy."VpNr" and be."Leistungsart"='IB' and be."ErfolgsannahmeErreicht"=true) as "AnzahlErfolgreich"
    from V_QSE_BELASTCALY blcy where blcy."Leistungsart"='IB'
   group by blcy."VpNr",blcy."PartnerName";
alter view V_QSE_REE_CNT owner to kfoqsdb;
drop view if exists V_QSE_REE_PFC;
create or replace view V_QSE_REE_PFC as
  select rct.*,
        ROUND(100.0*(rct."AnzahlBehandlungen"-rct."AnzahlErfolgreich") / rct."AnzahlBehandlungen") as "ProzentNichterreichung"
    from V_QSE_REE_CNT rct;
alter view V_QSE_REE_PFC owner to kfoqsdb;
-- Test-Prozedur: 
-- select * from V_QSE_REE_PFC
drop view if exists V_AuswertungErreichungErfolgsannahme;
create or replace view V_AuswertungErreichungErfolgsannahme as
select * 
  from V_QSE_REE_PFC pfc
 where pfc."ProzentNichterreichung">10.0;
alter view V_AuswertungErreichungErfolgsannahme owner to kfoqsdb;
-- Test-Prozedur: 
-- select * from V_AuswertungErreichungErfolgsannahme
-- Definition von KFOQSDB report "Auswertung Erreichung Erfolgsannahme": alte Definition(en) werden "hidden", neue angelegt
update "reporttype" set "name"='hidden_Auswertung Erreichung Erfolgsannahme',"role"='INVISIBLE' where "name"='Auswertung Erreichung Erfolgsannahme' and type = 'USER';
insert into "reporttype"("sql",      "version",	"Erstelldatum", "role",		"type",	"name",		"personenbezug")
values('select * from V_AuswertungErreichungErfolgsannahme',  1,			NOW(),          'SB',	'USER',	'Auswertung Erreichung Erfolgsannahme',	true);
-- Definition der KFOQSDB-Auswertung RBA - Auswertung Behandlungsabbruch [ANF0401.04]
drop view if exists V_QSE_RBA_CNT cascade;
create or replace view V_QSE_RBA_CNT as
  select qbe."VpNr", p."PartnerName",
         (select count(*) from V_QSE_BEENDET bc where bc."VpNr"=qbe."VpNr" and bc."Rang"<=100) as "AnzahlBehandlungen",
         (select count(*) from V_QSE_BEENDET bc where bc."VpNr"=qbe."VpNr" and bc."Rang"<=100 and bc."Behandlungsabbruch" is not null) as "AnzahlAbgebrochen" 
  from V_QSE_BEENDET qbe
    left outer join "Partner" p on p."VpNr"=qbe."VpNr"
 group by qbe."VpNr",p."PartnerName";
alter view V_QSE_RBA_CNT owner to kfoqsdb;
-- Test-Prozedur: 
-- select * from V_QSE_RBA_CNT
drop view if exists V_QSE_RBA_PFC cascade;
create or replace view V_QSE_RBA_PFC as
  select qbc.*,
         ROUND((1.0*(qbc."AnzahlBehandlungen"-qbc."AnzahlAbgebrochen")/qbc."AnzahlBehandlungen") * 100.0) as "ProzentAbgeschlossen",
         ROUND((1.0*qbc."AnzahlAbgebrochen"/qbc."AnzahlBehandlungen") * 100.0) as "ProzentAbgebrochen"
    from V_QSE_RBA_CNT qbc;
alter view V_QSE_RBA_PFC owner to kfoqsdb;
-- Test-Prozedur: 
-- select * from V_QSE_RBA_PFC
drop view if exists V_AuswertungBehandlungsabbruch;
create or replace view V_AuswertungBehandlungsabbruch as
select * from V_QSE_RBA_PFC pfc where pfc."ProzentAbgebrochen">10 ;
alter view V_AuswertungBehandlungsabbruch owner to kfoqsdb;
-- Test-Prozedur: 
-- select * from V_AuswertungBehandlungsabbruch
-- Definition von KFOQSDB report "Auswertung Behandlungsabbruch": alte Definition(en) werden "hidden", neue angelegt
update "reporttype" set "name"='hidden_Auswertung Behandlungsabbruch',"role"='INVISIBLE' where "name"='Auswertung Behandlungsabbruch' and type = 'USER';
insert into "reporttype"("sql",      "version",	"Erstelldatum", "role",		"type",	"name",		"personenbezug")
values('select * from V_AuswertungBehandlungsabbruch',  1,			NOW(),          'SB',	'USER',	'Auswertung Behandlungsabbruch',	true);
-- Definition der Spezial-Auswertung EXPORT
drop view if exists V_QSE_EXPORT cascade;
create or replace view V_QSE_EXPORT as
SELECT q."LZTraeger" as "LZ Traeger", q."ABRTraeger" as "ABR Traeger", q."QSTraeger" as "QS Traeger", 
  q."Ersteller" as "Ersteller", q."Erstelldatum" as "Erstelldatum", 
  p."VpNr" as "VPNR", p."PartnerName" as "VP Name", p."PartnerBundesland" as "VP Bundesland", p."countryCode" as "Laendercode", 
  q."Leistungsart" as "Leistungsart", q."Fachgebiet" as "Fachgebiet", q."PartnerArt" as "Partnerart", q."VsNr" as "VSNR", 
  q."IOTNLE" as "IOTN-Grad LE", q."IOTNQS" as "IOTN-Grad QS", q."IOTNDatumLE" as "IOTN Feststellungsdatum LE", q."IOTNDatumQS" as "IOTN Feststellungsdatum QS", 
  q."IndikationLE" as "Indikation LE", q."IndikationQS" as "Indikation QS", q."IndikationDatumLE" as "Indikation Feststellungsdatum LE", 
  q."IndikationDatumQS" as "Indikation Feststellungsdatum QS", q."IBBehandlungsendeLE" as "Datum Behandlungsende LE", 
  q."Behandlungsabbruch" as "Datum Behandlungsabbruch LE", q."ErfolgsannahmeErreicht" as "Erfolgsannahme", q."PARAnfangswert" as "PAR-Index Anfangswert", 
  q."PAREndwert" as "PAR-Index Endwert", q."HBDatumBehandlungsbeginnLE" as "Datum Behandlungsbeginn HB LE", q."HBDatumBehandlungsendeLE" as "Datum Behandlungsende HB LE",
  q."Stornogrund" as "Stornogrund", q."StornoDatum" as "Stornodatum", q."StornoBenutzer" as "Stornobenutzer"
FROM "QsEintrag" q INNER JOIN "Partner" p ON q."VpNr" = P."VpNr";
alter view V_QSE_EXPORT owner to kfoqsdb;
-- Definition von KFOQSDB report "Export": alte Definition(en) werden "hidden", neue angelegt
update "reporttype" set "name"='hidden_Export',"role"='INVISIBLE' where "name"='Export' and type = 'USER';
insert into "reporttype"("sql",      "version",	"Erstelldatum", "role",		"type",	"name",		"personenbezug")
values('select * from V_QSE_EXPORT WHERE "ABR Traeger"=''?''',  1,			NOW(),          'SB',	'USER',	'Export',	true);
-- Definition der Management-Auswertung Abgeschlossen/Monatsbänder
drop view if exists V_QSA_ABG CASCADE;
-- V_QSA_ABG ergänzt nicht-abgebrochene, nicht-stornierte QSE um standardisiertes Beginndatum, Endedatum und Abgeschlossen-Kennzeichen
create or replace view V_QSA_ABG as
select qse."VpNr" as "QSE_VPNR",qse."VsNr" as "QSE_VSNR",qse."Leistungsart" as "QSE_Leistungsart",
       (CASE WHEN qse."Leistungsart"='HB' and qse."HBDatumBehandlungsendeLE" is not null THEN 'J'
             WHEN qse."Leistungsart"='IB' and qse."IBBehandlungsendeLE" is not null THEN 'J'
             WHEN qse."Leistungsart"='IF' THEN 'J'
        ELSE 'N' END) as "Abgeschlossen",
       (CASE WHEN qse."Leistungsart"='HB' and qse."HBDatumBehandlungsbeginnLE" is not null THEN qse."HBDatumBehandlungsbeginnLE"
             WHEN qse."Leistungsart"='HB' and qse."HBDatumBehandlungsbeginnLE" is null     THEN null
             WHEN qse."Leistungsart"='IB' and qse."HBDatumBehandlungsbeginnLE" is not null THEN qse."HBDatumBehandlungsbeginnLE"
             WHEN qse."Leistungsart"='IB' and qse."IOTNDatumLE" is not null                THEN qse."IOTNDatumLE"
             WHEN qse."Leistungsart"='IB' and qse."IOTNDatumLE" is null                    THEN null
             WHEN qse."Leistungsart"='IF'                                                  THEN qse."IOTNDatumLE"
        ELSE null END) as "Beginndatum",
       (CASE WHEN qse."Leistungsart"='HB' and qse."HBDatumBehandlungsendeLE" is not null   THEN qse."HBDatumBehandlungsendeLE"
             WHEN qse."Leistungsart"='HB' and qse."HBDatumBehandlungsendeLE" is null       THEN now()
             WHEN qse."Leistungsart"='IB' and qse."IBBehandlungsendeLE" is not null        THEN qse."IBBehandlungsendeLE"
             WHEN qse."Leistungsart"='IF'                                                  THEN qse."IOTNDatumLE"
        ELSE null END) as "Endedatum",
        qse.*
  from "QsEintrag" qse
 where qse."StornoDatum" is null
   and qse."Behandlungsabbruch" is null;
alter view V_QSA_ABG owner to kfoqsdb;
-- Test-Prozedur: 
-- select * from V_QSA_ABG
drop view if exists V_QSA_ABGLEN CASCADE;
-- V_QSA_ABGLEN ergänzt V_QSA_ABG um die Behandlunsdauer (Zeit, Monate)
create or replace view V_QSA_ABGLEN as
select abg.*,
       age(abg."Endedatum", abg."Beginndatum") as "BehandlungsDauer",
       ROUND(EXTRACT(year FROM age(abg."Endedatum",abg."Beginndatum"))*12 + EXTRACT(month FROM age(abg."Endedatum",abg."Beginndatum"))) as "Behandlungsmonate"
  from V_QSA_ABG abg;
alter view V_QSA_ABGLEN owner to kfoqsdb;
-- Test-Prozedur: 
-- select * from V_QSA_ABGLEN
drop view if exists V_AuswertungAbgeschlossenMonatbaender CASCADE;
-- V_AuswertungAbgeschlossenMonatbaender ist die definierte Auswertung Abgeschlossen/Monatsbaender
create or replace view V_AuswertungAbgeschlossenMonatbaender as
select "Abgeschlossen","Leistungsart","Behandlungsmonate", count("Leistungsart") as "Anzahl Fälle" 
  from V_QSA_ABGLEN
  where "Abgeschlossen"='J' and "Behandlungsmonate">=0 and "Behandlungsmonate"<300 and "Leistungsart" in ('HB','IB')
  group by "Abgeschlossen","Leistungsart","Behandlungsmonate"
  order by "Leistungsart","Behandlungsmonate" asc;
alter view V_AuswertungAbgeschlossenMonatbaender owner to kfoqsdb;
-- Definition von KFOQSDB report "Abgeschlossene IB/HB Anzahl Monatsbänder": alte Definition(en) werden "hidden", neue angelegt
update "reporttype" set "name"='hidden_Abgeschlossene IB/HB Anzahl Monatsbänder',"role"='INVISIBLE' where "name"='Abgeschlossene IB/HB Anzahl Monatsbänder' and type = 'USER';
insert into "reporttype"("sql",      "version",	"Erstelldatum", "role",		"type",	"name",		"personenbezug")
values('select * from V_AuswertungAbgeschlossenMonatbaender',  1,			NOW(),          'ADMIN',	'USER',	'Abgeschlossene IB/HB Anzahl Monatsbänder',	false);
-- Dump der QS-Einträge aus einer KFOQSDB für Backup-Zwecke
-- Definition von KFOQSDB report "Dump QsEintrag": alte Definition(en) werden "hidden", neue angelegt
update "reporttype" set "name"='hidden_Dump QsEintrag',"role"='INVISIBLE' where "name"='Dump QsEintrag' and type = 'USER';
insert into "reporttype"("sql",      "version",	"Erstelldatum", "role",		"type",	"name",		"personenbezug")
values('select * from "QsEintrag"',  1,			NOW(),          'ADMIN',	'USER',	'Dump QsEintrag',	true);
-- Dump der Partner aus einer KFOQSDB
-- Definition von KFOQSDB report "Dump Partner": alte Definition(en) werden "hidden", neue angelegt
update "reporttype" set "name"='hidden_Dump Partner',"role"='INVISIBLE' where "name"='Dump Partner' and type = 'USER';
insert into "reporttype"("sql",      "version",	"Erstelldatum", "role",		"type",	"name",		"personenbezug")
values('select * from "Partner"',  1,			NOW(),          'ADMIN',	'USER',	'Dump Partner',	true);
-- Definition der KFOQSDB Management-Auswertung IOTNSEG
-- Diese wertet aus:
-- über alle QS-Fälle, die nicht storniert sind
-- Gruppiert nach Leistungsart und IOTN-Grad (IOTNQS)
-- die Anzahl der Fälle für diejenige Leistungsart und IOTN-Grad
-- ergänzt um:
-- Anzahl aller Fälle in der KFOQSDB
-- Anzahl aller nicht-stornierten Fälle in der KFOQSDB
-- Anzahl aller stornierten Fälle in der KFOQSDB
drop view if exists "AuswertungIOTNSEG" cascade;
create or replace view "AuswertungIOTNSEG" as
				 select "Leistungsart","IOTNQS", count("IOTNQS") as "Anzahl", '3'::varchar as "G"
				 from "QsEintrag" qse
				  where qse."StornoDatum" is null
							  group by "Leistungsart","IOTNQS"
							  UNION
							  select 'Alle' as "Leistungsart", 'NichtStornierte' as "IOTNQS", count(*) as "Anzahl", '0'::varchar as "G"
							  from "QsEintrag" qse
							  where qse."StornoDatum" is null
							  UNION
							  select 'Alle' as "Leistungsart", 'Stornierte' as "IOTNQS", count(*) as "Anzahl", '1'::varchar as "G"
							  from "QsEintrag" qse
							  where qse."StornoDatum" is not null
							  UNION 
							  select 'Alle' as "Leistungsart", 'Alle' as IOTNQS, count(*) as "Anzahl", '2'::varchar as "G"
							  from "QsEintrag" qse
							  order by "G","Leistungsart" asc ,"Anzahl" desc, "IOTNQS" desc;
alter view "AuswertungIOTNSEG" owner to kfoqsdb;
-- Definition von KFOQSDB report "IOTN-Grad Verteilung": alte Definition(en) werden "hidden", neue angelegt
update "reporttype" set "name"='hidden_IOTN-Grad Verteilung',"role"='INVISIBLE' where "name"='IOTN-Grad Verteilung' and type = 'USER';
insert into "reporttype"("sql",      "version",	"Erstelldatum", "role",		"type",	"name",		"personenbezug")
values('select * from "AuswertungIOTNSEG"',  1,			NOW(),          'ADMIN',	'USER',	'IOTN-Grad Verteilung',	false);
-- Definition der KFOQSDB-Auswertung RPI - Auswertung PARIndex [ANF0401.03]
drop view if exists V_QSE_RPI_PROZABBR cascade;
-- V_QSE_RPI_PROZABBR zeigt pro Behandler+Leistungsart: Gesamtanzahl,Anzahl der abgebrochenen Fälle in letzten 100, Anzahl der abgeschlossenen Fälle, Prozentzahl der abgebrochenen Fälle
create or replace view V_QSE_RPI_PROZABBR as
select qseb."VpNr", qseb."Leistungsart", array_agg(distinct qseb."QSTraeger") as "QSTraegerListe", count(qseb."ID") as "AnzahlGesamt",
       (select count(*) from V_QSE_BEENDET qsa where qsa."VpNr"=qseb."VpNr" and qsa."Leistungsart"=qseb."Leistungsart" 
                                                 and qsa."Abbruch"='ABBRUCH' and qsa."LeistungsartRang"<100) as "AnzahlAbgebrochenInLetzten100",
       (select count(*) from V_QSE_BEENDET qsa where qsa."VpNr"=qseb."VpNr" and qsa."Leistungsart"=qseb."Leistungsart"
                                                 and qsa."Abbruch"!='ABBRUCH') as "AnzahlAbgeschlossen",
       (1.0*(select count(*) from V_QSE_BEENDET qsa where qsa."VpNr"=qseb."VpNr" and qsa."Leistungsart"=qseb."Leistungsart" 
                                                      and qsa."Abbruch"='ABBRUCH'))/count(qseb."ID")*100.0 as "ProzentAbgebrochen"
  from V_QSE_BEENDET qseb
  group by qseb."VpNr", qseb."Leistungsart";
alter view V_QSE_RPI_PROZABBR owner to kfoqsdb;
-- Test-Prozedur: 
-- select * from V_QSE_RPI_PROZABBR
create or replace view V_QSE_RPI_KRIT as
select qspa."VpNr", qspa."QSTraegerListe", qspa."AnzahlGesamt", qspa."AnzahlAbgebrochenInLetzten100", qspa."AnzahlAbgeschlossen", qspa."ProzentAbgebrochen",
       (CASE WHEN qspa."ProzentAbgebrochen"<10.0 THEN 'WenigerAls10ProzentAbgebrochen' ELSE 'MehrAls10ProzentAbgebrochen' END) as "Kriterium10ProzentKlausel", 
       ROUND(CASE WHEN qspa."ProzentAbgebrochen"<10.0 THEN qspa."AnzahlAbgeschlossen" ELSE 0.9*qspa."AnzahlAbgeschlossen" END) as "AnzahlFaelleFuerPARIndexReport"
  from V_QSE_RPI_PROZABBR qspa where qspa."Leistungsart"='HB';
-- V_QSE_RPI_KRIT zeigt für HB-Fälle aus V_RPI_PROZABBR: Ob mehr als 10% abgebrochen, Anzahl der Fälle, die für Auswertung PAR-Index heranzuziehen sind
-- Test-Prozedur: 
-- select * from V_QSE_RPI_KRIT
create or replace view V_QSE_RPI_KLASS as
select krit."VpNr", krit."QSTraegerListe", krit."AnzahlGesamt", krit."AnzahlAbgebrochenInLetzten100", krit."AnzahlAbgeschlossen", krit."ProzentAbgebrochen",
       krit."Kriterium10ProzentKlausel", krit."AnzahlFaelleFuerPARIndexReport",
       (select count(*) from V_QSE_BEENDET qseb where qseb."VpNr"=krit."VpNr" and qseb."LeistungsartRang"<=krit."AnzahlFaelleFuerPARIndexReport") as "AnzahlFaelleBeruecksichtigt",
       (select avg(qseb."PARVerbesserungProzent") from V_QSE_BEENDET qseb 
         where qseb."VpNr"=krit."VpNr" and qseb."Leistungsart"='HB' and qseb."LeistungsartRang"<=krit."AnzahlFaelleFuerPARIndexReport") as "MittlereVerbesserung"
  from V_QSE_RPI_KRIT krit;
-- V_QSE_RPI_KLASS zeigt zu jedem Behandler für HB-Fälle die Anzahl der berücksichtigten Fälle und mittlere Verbesserung über die berückscihtigten Fälle
-- Test-Prozedur: 
-- select * from V_QSE_RPI_KLASS
-- Test-Prozedur: 
-- select * from V_QSE_RPI_KLASS where "AnzahlFaelleFuerPARIndexReport"!="AnzahlFaelleBeruecksichtigt"
drop view if exists V_auswertungPARIndex;
-- V_AuswertungPARIndex zeigt alle Behandler, bei denen die mittlere Verbesserung in den berücksichtigten Fällen (aus V_QSE_RPI_KLASS) unter 70 Prozent lag 
create or replace view V_AuswertungPARIndex as
select kl."VpNr", p."PartnerName",
       kl."AnzahlGesamt" as "AnzahlBeendeterFaelle",
       kl."MittlereVerbesserung" as "MittlereVerbesserung",
       array_to_string(kl."QSTraegerListe",',','(keine)') as "QSzustaendigeTraeger"
  from V_QSE_RPI_KLASS kl
left outer join "Partner" p on p."VpNr"=kl."VpNr"
  where kl."MittlereVerbesserung" < 70.0;
alter view V_AuswertungPARIndex owner to kfoqsdb;
-- Test-Prozedur: 
-- select * from V_AuswertungPARIndex
-- Definition von KFOQSDB report "Auswertung PAR-Index": alte Definition(en) werden "hidden", neue angelegt
update "reporttype" set "name"='hidden_Auswertung PAR-Index',"role"='INVISIBLE' where "name"='Auswertung PAR-Index' and type = 'USER';
insert into "reporttype"("sql",      "version",	"Erstelldatum", "role",		"type",	"name",		"personenbezug")
values('select * from V_AuswertungPARIndex',  1,			NOW(),          'SB',	'USER',	'Auswertung PAR-Index',	true);
-- Definition der KFOQSDB Management-Auswertung HBCPAR
-- Diese wertet aus:
-- über alle beendeten QS-Fälle, die nicht storniert sind
-- QS-Träger,Patient,Beginndatum,Endedatum,PARIndexBeginn,PARIndexEnde
drop view if exists "AuswertungHBCPAR" cascade;
create or replace view "AuswertungHBCPAR" as
select "QSTraeger","VsNr","Leistungsart","Beginndatum","Endedatum","PARAnfangswert","PAREndwert"
  from V_QSE_BEENDET
where "Leistungsart"='HB';
alter view "AuswertungHBCPAR" owner to kfoqsdb;
-- Test-Prozedur: 
-- select * from "AuswertungHBCPAR"
-- Definition von KFOQSDB report "HB PAR-Index-Details": alte Definition(en) werden "hidden", neue angelegt
update "reporttype" set "name"='hidden_HB PAR-Index-Details',"role"='INVISIBLE' where "name"='HB PAR-Index-Details' and type = 'USER';
insert into "reporttype"("sql",      "version",	"Erstelldatum", "role",		"type",	"name",		"personenbezug")
values('select * from "AuswertungHBCPAR"',  1,			NOW(),          'ADMIN',	'USER',	'HB PAR-Index-Details',	true);
