/*
 * Decompiled with CFR 0.152.
 */
package at.itsv.kfo.zupexporter;

import at.itsv.kfoqsdb.data.entities.zup.Ge1001;
import java.util.List;
import javax.ejb.Stateless;
import javax.inject.Inject;
import javax.persistence.EntityManager;
import javax.persistence.TypedQuery;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.joda.time.LocalDate;

@Stateless
public class Ge1001Repository {
    private static final Logger logger = Logger.getLogger(Ge1001Repository.class);
    private static final String DATE_DB_FORMAT = "yyyyMMdd";
    @Inject
    private EntityManager em;

    public List<Ge1001> getAll() {
        String queryString = " from Ge1001 ";
        TypedQuery query = this.em.createQuery(queryString, Ge1001.class);
        List result = query.getResultList();
        return result;
    }

    public List<Ge1001> getAllGe1001ForDayOrderedByZeitprotokoll(LocalDate day) {
        String queryString = " from Ge1001 where id.datumprotokoll = :day order by id.zeitprotokoll  ";
        TypedQuery query = this.em.createQuery(queryString, Ge1001.class);
        query.setParameter("day", (Object)day.toString(DATE_DB_FORMAT));
        List result = query.getResultList();
        return result;
    }

    public String getOldestDateTodo() {
        String result = null;
        String queryString = " from Ge1001 where exportTimestamp is null order by id.datumprotokoll asc ";
        TypedQuery query = this.em.createQuery(queryString, Ge1001.class);
        query.setMaxResults(1);
        List list = query.getResultList();
        if (list != null && list.size() > 0) {
            result = ((Ge1001)list.get(0)).getId().getDatumprotokoll();
        }
        return result;
    }

    public List<Ge1001> getGe1001ForDay(String dateString) {
        if (StringUtils.isBlank((String)dateString)) {
            throw new IllegalArgumentException("parameter 'dateString' is empty.");
        }
        String queryString = " from Ge1001 where id.datumprotokoll = :day order by id.zeitprotokoll asc ";
        TypedQuery query = this.em.createQuery(queryString, Ge1001.class);
        query.setParameter("day", (Object)dateString);
        List result = query.getResultList();
        return result;
    }

    public void update(Ge1001 entry) {
        this.em.merge((Object)entry);
    }
}

