/*
 * Decompiled with CFR 0.152.
 */
package at.itsv.kfo.zupexporter;

import at.itsv.kfo.zupexporter.ZupExporter;
import at.itsv.kfoqsdb.data.entities.zup.Ge1001;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class HvbProtocolConverter {
    private static final Logger logger = Logger.getLogger(ZupExporter.class);
    private static final int GE0001_BENUTZERID_LENGTH = 8;

    public static byte[] convert(Ge1001 item) throws IOException {
        return HvbProtocolConverter.convert(item, false);
    }

    public static byte[] convert(Ge1001 item, boolean limitBenutzerID) throws IOException {
        if (item == null) {
            return null;
        }
        return HvbProtocolConverter.buildSatzMitTrennzeichen(item, limitBenutzerID);
    }

    private static byte[] buildSatzMitTrennzeichen(Ge1001 ge1001, boolean limitBenutzerID) throws IOException {
        return HvbProtocolConverter.addSatzTrennzeichen(HvbProtocolConverter.buildSatzAsByteArray(ge1001, limitBenutzerID));
    }

    private static byte[] addSatzTrennzeichen(byte[] a) {
        return ArrayUtils.add((byte[])ArrayUtils.add((byte[])a, (byte)13), (byte)10);
    }

    private static byte[] buildSatzAsByteArray(Ge1001 ge1001, boolean limitBenutzerID) throws IOException {
        return HvbProtocolConverter.toGE1001ByteArray(HvbProtocolConverter.buildSatzAsString(ge1001, limitBenutzerID));
    }

    private static byte[] toGE1001ByteArray(String s) throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)bos, "ISO-8859-1");
        writer.append(s);
        writer.close();
        return bos.toByteArray();
    }

    private static String buildSatzAsString(Ge1001 ge1001, boolean limitBenutzerID) {
        StringBuilder sb = new StringBuilder();
        sb.append(HvbProtocolConverter.padRight(ge1001.getLogcode(), 1));
        sb.append(HvbProtocolConverter.padRight(ge1001.getId().getProjekt(), 2));
        sb.append(HvbProtocolConverter.padRight(ge1001.getId().getLogid(), 6));
        sb.append(HvbProtocolConverter.padRight(ge1001.getVersionprotokoll(), 4));
        sb.append(HvbProtocolConverter.padRight(ge1001.getSystemmodus(), 1));
        sb.append(HvbProtocolConverter.padRight(ge1001.getVerarbeitungsmodus(), 1));
        sb.append(HvbProtocolConverter.padRight(ge1001.getTraegerid(), 2));
        sb.append(HvbProtocolConverter.padRight(HvbProtocolConverter.getValueOrEmptyStringIfNull(ge1001.getOrgeinheitid()), 10));
        if (limitBenutzerID) {
            if (ge1001.getBenutzerid().trim().length() > 8) {
                sb.append(HvbProtocolConverter.padRight(ge1001.getBenutzerid().substring(0, 8), 8));
            } else {
                sb.append(HvbProtocolConverter.padRight(ge1001.getBenutzerid().trim(), 8));
            }
        } else {
            sb.append(HvbProtocolConverter.padRight(ge1001.getBenutzerid(), 128));
        }
        sb.append(HvbProtocolConverter.padRight(ge1001.getAppid(), 8));
        sb.append(HvbProtocolConverter.padRight(HvbProtocolConverter.getValueOrEmptyStringIfNull(ge1001.getBearbgrund()), 25));
        sb.append(HvbProtocolConverter.padRight(ge1001.getZieltraegerid(), 2));
        sb.append(HvbProtocolConverter.padRight(ge1001.getAuswahlkriterium1(), 20));
        sb.append(HvbProtocolConverter.padRight(HvbProtocolConverter.getValueOrEmptyStringIfNull(ge1001.getAuswahlkriterium2()), 20));
        sb.append(HvbProtocolConverter.padRight(HvbProtocolConverter.getValueOrEmptyStringIfNull(ge1001.getAuswahlkriterium3()), 20));
        sb.append(HvbProtocolConverter.padRight(ge1001.getId().getDatumprotokoll(), 8));
        sb.append(HvbProtocolConverter.padRight(ge1001.getId().getZeitprotokoll(), 12));
        sb.append(HvbProtocolConverter.padRight(ge1001.getId().getTransactionid(), 13));
        sb.append(HvbProtocolConverter.padRight(HvbProtocolConverter.getValueOrEmptyStringIfNull(ge1001.getFehlercode()), 6));
        sb.append(HvbProtocolConverter.getValueOrEmptyStringIfNull(ge1001.getZusatzdaten()));
        return sb.toString();
    }

    private static String padRight(String s, int n) {
        return String.format("%1$-" + n + "s", s);
    }

    private static String getValueOrEmptyStringIfNull(String value) {
        if (StringUtils.isEmpty((String)value)) {
            return "";
        }
        return value;
    }
}

