/*
 * Decompiled with CFR 0.152.
 */
package at.itsv.kfo.zupexporter;

import at.itsv.kfoqsdb.data.entities.RegelWerk;
import at.itsv.kfoqsdb.internal.enums.RWTypeEnum;
import at.itsv.kfoqsdb.model.dao.RegelWerkDao;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class SystemConfiguration {
    public static final String ZUP_EXPORT_PATH = "ZupExportPath";
    public static final String ZUP_EXPORT_PREFIX = "ZupExportPrefix";
    public static final String ZUP_EXPORT_ENABLED = "ZupExportEnabled";
    private List<RegelWerk> entries;
    private String zupExportPath;
    private String zupExportPrefix;
    private boolean zupExportEnabled;

    private SystemConfiguration() {
    }

    public synchronized void init(RegelWerkDao regelWerkDao) {
        this.entries = regelWerkDao.getByType(RWTypeEnum.CONFIG_SYSTEM);
        this.zupExportPath = this.getValueAsString(ZUP_EXPORT_PATH);
        this.zupExportPrefix = this.getValueAsString(ZUP_EXPORT_PREFIX);
        this.zupExportEnabled = this.getValueAsBoolean(ZUP_EXPORT_ENABLED);
    }

    public String getZupExportPath() {
        return this.zupExportPath;
    }

    public String getZupExportPrefix() {
        return this.zupExportPrefix;
    }

    public boolean getZupExportEnabled() {
        return this.zupExportEnabled;
    }

    private boolean getValueAsBoolean(String name) {
        return Boolean.valueOf(this.getValueAsString(name));
    }

    private String getValueAsString(String name) {
        if (StringUtils.isBlank((String)name)) {
            throw new IllegalArgumentException("name is empty");
        }
        if (this.entries == null || this.entries.size() == 0) {
            return null;
        }
        for (RegelWerk entry : this.entries) {
            if (!name.equalsIgnoreCase(entry.getName())) continue;
            return entry.getValue();
        }
        return null;
    }
}

