/*
 * Decompiled with CFR 0.152.
 */
package at.itsv.kfo.zupexporter;

import at.itsv.kfo.zupexporter.Ge1001Repository;
import at.itsv.kfo.zupexporter.HvbProtocolConverter;
import at.itsv.kfoqsdb.data.entities.zup.Ge1001;
import at.itsv.kfoqsdb.data.entities.zup.Ge1001Id;
import java.nio.charset.StandardCharsets;
import java.util.Date;
import java.util.List;
import javax.inject.Inject;
import org.apache.log4j.Logger;

public class ZupExporter {
    private static final Logger logger = Logger.getLogger(ZupExporter.class);
    @Inject
    Ge1001Repository ge1001Repository;

    public void export(Date date) {
        logger.info((Object)("ZupExporter : start export for : " + date));
        if (this.ge1001Repository == null) {
            logger.error((Object)"ZupExporter : ge1001Repository == null");
            return;
        }
        List<Ge1001> result = this.ge1001Repository.getAll();
        try {
            if (result != null) {
                for (Ge1001 item : result) {
                    Ge1001Id id = item.getId();
                    byte[] data = HvbProtocolConverter.convert(item);
                    logger.debug((Object)("item      : " + id.getLogid() + " / " + id.getDatumprotokoll() + item));
                    logger.debug((Object)("item data : " + new String(data, StandardCharsets.UTF_8)));
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
    }
}

