/*
 * Decompiled with CFR 0.152.
 */
package at.itsv.kfo.zupexportservice;

import at.itsv.kfo.zupexporter.Ge1001Repository;
import at.itsv.kfo.zupexporter.HvbProtocolConverter;
import at.itsv.kfo.zupexporter.SystemConfiguration;
import at.itsv.kfo.zupexportservice.ZupExportService;
import at.itsv.kfoqsdb.data.entities.zup.Ge1001;
import at.itsv.kfoqsdb.model.dao.RegelWerkDao;
import com.ibm.icu.impl.TimeZoneAdapter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import javax.enterprise.context.RequestScoped;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

@Named
@RequestScoped
public class ZupExportServiceImpl
implements ZupExportService,
Serializable {
    private static final Logger logger = Logger.getLogger(Ge1001Repository.class);
    @Inject
    Ge1001Repository ge1001Repository;
    @Inject
    RegelWerkDao regelWerkDao;
    @Inject
    SystemConfiguration systemConfiguration;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public long exportOldestFile() {
        String report;
        long l;
        Boolean enabled;
        String filename;
        String oldestDate;
        long duration;
        Date now;
        String message;
        long count;
        long ageInDays;
        block26: {
            String report2;
            long l2;
            block25: {
                String report3;
                long report4222;
                block24: {
                    String report5;
                    long report4222;
                    block23: {
                        String report6;
                        long report4222;
                        block22: {
                            String report7;
                            long report4222;
                            block21: {
                                long start = System.nanoTime();
                                ageInDays = 0L;
                                count = 0L;
                                message = null;
                                now = new Date();
                                long stop = start;
                                duration = 0L;
                                oldestDate = null;
                                filename = null;
                                enabled = null;
                                try {
                                    this.systemConfiguration.init(this.regelWerkDao);
                                    enabled = this.getEnabled();
                                    logger.debug((Object)("ZupExportServiceImpl : exportOldestFile : enabled : '" + enabled + "'"));
                                    if (BooleanUtils.isFalse((Boolean)enabled)) {
                                        message = "Info : service disabled";
                                        logger.info((Object)message);
                                        long l3 = 0L;
                                        return l3;
                                    }
                                    oldestDate = this.ge1001Repository.getOldestDateTodo();
                                    if (oldestDate == null) {
                                        message = "Info : nothing to export (no entries)";
                                        logger.info((Object)message);
                                        long l4 = 0L;
                                        return l4;
                                    }
                                    logger.debug((Object)("ZupExportServiceImpl : exportOldestFile : oldestDate : '" + oldestDate + "'"));
                                    ageInDays = this.calcDayDifference(oldestDate);
                                    if (ageInDays <= 0L) {
                                        message = "Info : Nothing to export (entries are too young)";
                                        logger.info((Object)message);
                                        long l5 = 0L;
                                        return l5;
                                    }
                                    String exportPath = this.systemConfiguration.getZupExportPath();
                                    logger.debug((Object)("ZupExportServiceImpl : exportOldestFile : exportPath : '" + exportPath + "'"));
                                    String prefix = this.systemConfiguration.getZupExportPrefix();
                                    logger.debug((Object)("ZupExportServiceImpl : exportOldestFile : prefix : '" + prefix + "'"));
                                    logger.debug((Object)("ZupExportServiceImpl : exportOldestFile : regelWerkDao : '" + this.regelWerkDao + "'"));
                                    if (StringUtils.isEmpty((String)exportPath)) {
                                        message = "Error : Error while exportOldestFile : exportPath is empty";
                                        logger.error((Object)message);
                                        report4222 = -2L;
                                        report7 = "+---------------------------------------------\n| ZupExport Report \n+---------------------------------------------\n| timestamp LOCAL : " + this.formatDateTimeISO(now) + "\n| timestamp UTC   : " + this.formatDateTimeISOUTC(now) + "\n| enabled         : " + enabled + "\n| duration        : " + duration + " ms \n| oldestDate      : " + oldestDate + "\n| ageInDays       : " + ageInDays + "\n| count           : " + count + "\n| filename        : " + filename + "\n| message         : " + message + "\n+---------------------------------------------\n";
                                        break block21;
                                    }
                                    if (StringUtils.isEmpty((String)oldestDate)) {
                                        message = "Error : oldestDate is empty";
                                        logger.error((Object)message);
                                        report4222 = -3L;
                                        report6 = "+---------------------------------------------\n| ZupExport Report \n+---------------------------------------------\n| timestamp LOCAL : " + this.formatDateTimeISO(now) + "\n| timestamp UTC   : " + this.formatDateTimeISOUTC(now) + "\n| enabled         : " + enabled + "\n| duration        : " + duration + " ms \n| oldestDate      : " + oldestDate + "\n| ageInDays       : " + ageInDays + "\n| count           : " + count + "\n| filename        : " + filename + "\n| message         : " + message + "\n+---------------------------------------------\n";
                                        break block22;
                                    }
                                    if (!this.checkDate(oldestDate)) {
                                        message = "Error : oldestDate is invalid : '" + oldestDate + "'";
                                        logger.error((Object)message);
                                        report4222 = -4L;
                                        report5 = "+---------------------------------------------\n| ZupExport Report \n+---------------------------------------------\n| timestamp LOCAL : " + this.formatDateTimeISO(now) + "\n| timestamp UTC   : " + this.formatDateTimeISOUTC(now) + "\n| enabled         : " + enabled + "\n| duration        : " + duration + " ms \n| oldestDate      : " + oldestDate + "\n| ageInDays       : " + ageInDays + "\n| count           : " + count + "\n| filename        : " + filename + "\n| message         : " + message + "\n+---------------------------------------------\n";
                                        break block23;
                                    }
                                    filename = this.getFilename(exportPath, prefix, oldestDate);
                                    if (StringUtils.isBlank((String)filename)) {
                                        message = "Error : filename is missing";
                                        logger.error((Object)message);
                                        report4222 = -5L;
                                        report3 = "+---------------------------------------------\n| ZupExport Report \n+---------------------------------------------\n| timestamp LOCAL : " + this.formatDateTimeISO(now) + "\n| timestamp UTC   : " + this.formatDateTimeISOUTC(now) + "\n| enabled         : " + enabled + "\n| duration        : " + duration + " ms \n| oldestDate      : " + oldestDate + "\n| ageInDays       : " + ageInDays + "\n| count           : " + count + "\n| filename        : " + filename + "\n| message         : " + message + "\n+---------------------------------------------\n";
                                        break block24;
                                    }
                                    File file = new File(filename);
                                    if (file.exists()) {
                                        message = "Error : file already exist : '" + filename + "'";
                                        logger.error((Object)message);
                                        l2 = -6L;
                                        report2 = "+---------------------------------------------\n| ZupExport Report \n+---------------------------------------------\n| timestamp LOCAL : " + this.formatDateTimeISO(now) + "\n| timestamp UTC   : " + this.formatDateTimeISOUTC(now) + "\n| enabled         : " + enabled + "\n| duration        : " + duration + " ms \n| oldestDate      : " + oldestDate + "\n| ageInDays       : " + ageInDays + "\n| count           : " + count + "\n| filename        : " + filename + "\n| message         : " + message + "\n+---------------------------------------------\n";
                                        break block25;
                                    }
                                    count = this.exportForDay(oldestDate, filename);
                                    stop = System.nanoTime();
                                    duration = (stop - start) / 1000000L;
                                    l = count;
                                    report = "+---------------------------------------------\n| ZupExport Report \n+---------------------------------------------\n| timestamp LOCAL : " + this.formatDateTimeISO(now) + "\n| timestamp UTC   : " + this.formatDateTimeISOUTC(now) + "\n| enabled         : " + enabled + "\n| duration        : " + duration + " ms \n| oldestDate      : " + oldestDate + "\n| ageInDays       : " + ageInDays + "\n| count           : " + count + "\n| filename        : " + filename + "\n| message         : " + message + "\n+---------------------------------------------\n";
                                    break block26;
                                }
                                catch (Exception e) {
                                    message = "Error : Exception : " + e.getMessage();
                                    logger.error((Object)message, (Throwable)e);
                                    long l6 = -1L;
                                    return l6;
                                }
                            }
                            logger.info((Object)("ZupExportServiceImpl : ZupExport Report \n" + report7));
                            return report4222;
                        }
                        logger.info((Object)("ZupExportServiceImpl : ZupExport Report \n" + report6));
                        return report4222;
                    }
                    logger.info((Object)("ZupExportServiceImpl : ZupExport Report \n" + report5));
                    return report4222;
                }
                logger.info((Object)("ZupExportServiceImpl : ZupExport Report \n" + report3));
                return report4222;
            }
            logger.info((Object)("ZupExportServiceImpl : ZupExport Report \n" + report2));
            return l2;
        }
        logger.info((Object)("ZupExportServiceImpl : ZupExport Report \n" + report));
        return l;
        finally {
            String report8 = "+---------------------------------------------\n| ZupExport Report \n+---------------------------------------------\n| timestamp LOCAL : " + this.formatDateTimeISO(now) + "\n| timestamp UTC   : " + this.formatDateTimeISOUTC(now) + "\n| enabled         : " + enabled + "\n| duration        : " + duration + " ms \n| oldestDate      : " + oldestDate + "\n| ageInDays       : " + ageInDays + "\n| count           : " + count + "\n| filename        : " + filename + "\n| message         : " + message + "\n+---------------------------------------------\n";
            logger.info((Object)("ZupExportServiceImpl : ZupExport Report \n" + report8));
        }
    }

    private long calcDayDifference(String dateString) {
        try {
            String DATE_FORMAT = "yyyyMMdd";
            SimpleDateFormat format = new SimpleDateFormat(DATE_FORMAT);
            String dateStringNow = format.format(new Date());
            logger.info((Object)("calcDayDifference : dateStringDate : " + dateString));
            logger.info((Object)("calcDayDifference : dateStringNow  : " + dateStringNow));
            Date a = format.parse(dateString);
            Date b = format.parse(dateStringNow);
            logger.info((Object)("calcDayDifference : date a : " + this.formatDateTimeISOUTC(a)));
            logger.info((Object)("calcDayDifference : date b : " + this.formatDateTimeISOUTC(b)));
            long diff = (b.getTime() - a.getTime()) / 86400000L;
            return diff;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private boolean checkDate(String oldestDate) {
        if (StringUtils.isBlank((String)oldestDate)) {
            return false;
        }
        String VALID_DATE_FORMAT = "yyyyMMdd";
        SimpleDateFormat format = new SimpleDateFormat(VALID_DATE_FORMAT);
        try {
            format.parse(oldestDate);
        }
        catch (ParseException e) {
            return false;
        }
        return true;
    }

    private boolean getEnabled() {
        return this.systemConfiguration.getZupExportEnabled();
    }

    private String getFilename(String path, String prefix, String dateString) {
        return path + File.separator + this.buildFilename(prefix, dateString);
    }

    String buildFilename(String prefix, String dateString) {
        if (StringUtils.isBlank((String)prefix)) {
            return dateString;
        }
        return prefix + "_" + dateString;
    }

    private long exportForDay(String dateString, String filename) throws IOException {
        logger.debug((Object)("ZupExportServiceImpl : exportForDay : dateString : " + dateString));
        List<Ge1001> entries = this.ge1001Repository.getGe1001ForDay(dateString);
        logger.debug((Object)("ZupExportServiceImpl : exportForDay : entries : " + entries));
        if (entries == null) {
            throw new RuntimeException("ZupExportServiceImpl : exportForDay : no entries for day " + dateString);
        }
        logger.info((Object)("ZupExportServiceImpl : exportForDay : found " + entries.size() + " entries for day " + dateString));
        byte[] dataForDay = this.convert(entries);
        Date exportTimestamp = new Date();
        this.writeExportFile(filename, dataForDay);
        logger.info((Object)("ZupExportServiceImpl : exportForDay : wrote " + dataForDay.length + " bytes to file '" + filename + "'"));
        File file = new File(filename);
        if (!file.exists()) {
            throw new RuntimeException("ZupExportServiceImpl : exportForDay : written file was not found : '" + filename + "'");
        }
        if (file.length() == 0L) {
            throw new RuntimeException("ZupExportServiceImpl : exportForDay : written file is empty : '" + filename + "'");
        }
        if (file.length() != (long)dataForDay.length) {
            throw new RuntimeException("ZupExportServiceImpl : exportForDay : written file is not complete : '" + filename + "'");
        }
        for (Ge1001 entry : entries) {
            entry.setExportTimestamp(exportTimestamp);
            this.ge1001Repository.update(entry);
        }
        return entries.size();
    }

    private void writeExportFile(String exportFilename, byte[] dataForDay) throws IOException {
        ZupExportServiceImpl.writeBytesToFile(exportFilename, dataForDay);
    }

    private byte[] convert(List<Ge1001> entries) throws IOException {
        ByteArrayOutputStream os = new ByteArrayOutputStream(8192);
        for (Ge1001 entry : entries) {
            byte[] convertedEntry = HvbProtocolConverter.convert(entry);
            os.write(convertedEntry);
        }
        os.flush();
        os.close();
        return os.toByteArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeBytesToFile(String path, byte[] data) throws IOException {
        try (FileOutputStream os = null;){
            int length;
            os = new FileOutputStream(new File(path));
            ByteArrayInputStream is = new ByteArrayInputStream(data);
            byte[] buffer = new byte[4096];
            while ((length = is.read(buffer, 0, buffer.length)) != -1) {
                os.write(buffer, 0, length);
            }
            os.flush();
        }
    }

    public String formatDateTimeISO(Date date) {
        String DATE_FORMAT_ISO = "yyyyMMdd'T'HH:mm:ss Z";
        SimpleDateFormat format = new SimpleDateFormat(DATE_FORMAT_ISO);
        return format.format(date);
    }

    public String formatDateTimeISOUTC(Date date) {
        String DATE_FORMAT_ISO = "yyyyMMdd'T'HH:mm:ss Z";
        SimpleDateFormat format = new SimpleDateFormat(DATE_FORMAT_ISO);
        format.setTimeZone(TimeZoneAdapter.getTimeZone((String)"UTC"));
        return format.format(date);
    }
}

