/*
 * Decompiled with CFR 0.152.
 */
package at.itsv.dvs.io;

import at.itsv.dvs.io.DVSExportException;
import at.itsv.dvs.io.DVSExporter;
import at.itsv.dvs.io.ExportListener;
import at.itsv.dvs.model.DVSBestand;
import at.itsv.dvs.model.DVSModel;
import at.itsv.dvs.model.DVSPaket;
import at.itsv.dvs.util.DVSConstants;
import at.itsv.dvs.util.DVSUtils;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;

public abstract class AbstractExporter
implements DVSExporter {
    protected Path path;
    protected String VSTR;
    protected String charset = "UTF-8";
    protected DVSConstants.CompressionType compressionType = DVSConstants.CompressionType.NONE;
    protected DVSConstants.DirectionType direction = DVSConstants.DirectionType.OUT;
    protected Date date = new Date();
    protected int fileNo = 0;
    protected String fileNamePrefix = "";
    protected List<ExportListener> exportListener = new ArrayList<ExportListener>();

    @Override
    public void doExport(DVSModel dvsModel) throws DVSExportException {
        Objects.requireNonNull(dvsModel, "dvsModel must not be null");
    }

    protected void exportPaket(DVSPaket paket) throws DVSExportException {
        for (ExportListener listener : this.getExportListener()) {
            listener.exportPaket(paket);
        }
    }

    protected void exportBestand(DVSBestand bestand) throws DVSExportException {
        for (ExportListener listener : this.getExportListener()) {
            listener.exportBestand(bestand);
        }
    }

    protected String constructFileName(boolean withUTF, boolean withXML) throws DVSExportException {
        return this.constructFileName(withUTF, withXML, false);
    }

    protected String constructFileName(boolean withUTF, boolean withXML, boolean oldStyle) throws DVSExportException {
        String name = "";
        name = !oldStyle ? "dd" + this.direction.getDirection() + this.VSTR + "." + (this.fileNamePrefix.length() > 0 ? this.fileNamePrefix + "." : "") + DVSConstants.FILE_DATE_FORMAT.format(this.date) + "." + DVSUtils.padLeft("" + ++this.fileNo, 6, '0') : (this.direction == DVSConstants.DirectionType.IN ? "rmt" + this.VSTR + "." + "ddftp" + this.direction.getDirection() : "rmt" + this.VSTR + "." + "ddau" + DVSConstants.FILE_DATE_OLD_STYLE_FORMAT.format(this.date));
        if (withUTF && this.charset.equals("UTF-8")) {
            name = name + ".utf";
        }
        if (withXML) {
            name = name + ".xml";
        }
        switch (this.compressionType) {
            case ZIP: 
            case GZIP: {
                name = name + this.compressionType.toString();
                break;
            }
        }
        if (!this.path.toString().endsWith(File.separator)) {
            name = File.separator + name;
        }
        for (ExportListener listener : this.getExportListener()) {
            listener.exportFile(this.path.toString() + name);
        }
        return this.path.toString() + name;
    }

    protected String constructEinzelFileName(DVSBestand b, boolean useDirStruct, boolean testFlag, String zvob) throws IOException, DVSExportException {
        Path filePath = this.path;
        if (zvob == null && b.getZusaetzlOrdnungsbegriff() != null) {
            zvob = b.getZusaetzlOrdnungsbegriff();
        }
        if (zvob != null && zvob.length() > 0) {
            zvob = DVSUtils.fullURLencode(zvob);
        }
        String name = (this.fileNamePrefix.length() > 0 ? this.fileNamePrefix : "dvs") + "_" + b.getZielPartnerCode() + "_" + b.getUrsprungsPartnerCode() + "_" + b.getProjektKennzeichen() + "_" + b.getListKennzeichen() + (testFlag ? "t" : "_") + "_" + (zvob != null ? zvob : "") + "." + DVSUtils.padLeft("" + ++this.fileNo, 6, '0');
        if (useDirStruct) {
            filePath = this.constructDirectory(b, filePath);
        }
        if (!filePath.toString().endsWith(File.separator)) {
            name = File.separator + name;
        }
        for (ExportListener listener : this.getExportListener()) {
            listener.exportFile(this.path.toString() + name);
        }
        return filePath.toString() + name;
    }

    protected Path constructDirectory(DVSBestand bestand, Path filePath) throws IOException {
        Objects.requireNonNull(bestand, "bestand must not be null");
        String dirName = bestand.getProjektKennzeichen() + File.separator + bestand.getListKennzeichen() + File.separator + bestand.getUrsprungsPartnerCode();
        if (!filePath.toString().endsWith(File.separator)) {
            dirName = File.separator + dirName;
        }
        filePath = Paths.get(filePath.toString() + dirName, new String[0]);
        if (!Files.exists(Paths.get(dirName, new String[0]), new LinkOption[0])) {
            Files.createDirectories(filePath, new FileAttribute[0]);
        }
        return filePath;
    }

    public Path getPath() {
        return this.path;
    }

    public String getCharset() {
        return this.charset;
    }

    public String getVSTR() {
        return this.VSTR;
    }

    public Date getDate() {
        return this.date;
    }

    public void setDate(Date date) {
        this.date = date;
    }

    public DVSConstants.DirectionType getDirection() {
        return this.direction;
    }

    public void setDirection(DVSConstants.DirectionType direction) {
        this.direction = direction;
    }

    public DVSConstants.CompressionType getCompressionType() {
        return this.compressionType;
    }

    public void setCompressionType(DVSConstants.CompressionType zipType) {
        this.compressionType = zipType;
    }

    public String getFileNamePrefix() {
        return this.fileNamePrefix;
    }

    public void setFileNamePrefix(String fileNamePrefix) {
        if (fileNamePrefix == null) {
            fileNamePrefix = "";
        }
        this.fileNamePrefix = fileNamePrefix;
    }

    public List<ExportListener> getExportListener() {
        return this.exportListener;
    }

    public void addExportListener(ExportListener listener) {
        this.exportListener.add(listener);
    }

    public static enum ExportLevel {
        PAKET,
        BESTAND;

    }
}

