/*
 * Decompiled with CFR 0.152.
 */
package at.itsv.dvs.io;

import at.itsv.dvs.io.AbstractExporter;
import at.itsv.dvs.io.DVSExportException;
import at.itsv.dvs.io.FileDataLocation;
import at.itsv.dvs.io.SARTFormatter;
import at.itsv.dvs.model.DVSBestand;
import at.itsv.dvs.model.DVSBestandSART;
import at.itsv.dvs.model.DVSDataLocation;
import at.itsv.dvs.model.DVSEmpfangsBestaetigungSART;
import at.itsv.dvs.model.DVSModel;
import at.itsv.dvs.model.DVSPaket;
import at.itsv.dvs.parser.DVSParseException;
import at.itsv.dvs.parser.LineHandler;
import at.itsv.dvs.parser.LineReader;
import at.itsv.dvs.parser.filter.AppendStringFilter;
import at.itsv.dvs.parser.filter.LineFilter;
import at.itsv.dvs.parser.filter.LineInflater;
import at.itsv.dvs.parser.filter.PrependStringFilter;
import at.itsv.dvs.util.DVSConstants;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.util.ArrayList;
import java.util.List;

public abstract class AbstractSARTExporter
extends AbstractExporter {
    protected boolean addLineFlags = true;
    protected boolean addCR = false;
    protected int minLineLength = 0;
    protected String lineEnd = "\n";
    protected boolean fileNameOldStyle = false;
    protected boolean oneFilePerPaket = false;
    protected Writer curWriter = null;
    protected DVSBestandSART curBestand = null;
    protected List<LineFilter> lineFilterList = new ArrayList<LineFilter>();

    @Override
    public void doExport(DVSModel dvsModel) throws DVSExportException {
        super.doExport(dvsModel);
        try {
            List<DVSPaket> lp = dvsModel.getPakete();
            for (DVSPaket paket : lp) {
                if (paket.isErroneous()) continue;
                this.exportPaket(paket);
            }
            if (this.curWriter != null) {
                this.curWriter.flush();
                this.curWriter.close();
            }
        }
        catch (IOException ex) {
            throw new DVSExportException(ex);
        }
    }

    @Override
    protected void exportPaket(DVSPaket paket) throws DVSExportException {
        try {
            super.exportPaket(paket);
            Writer writer = this.getWriter(AbstractExporter.ExportLevel.PAKET);
            this.exportPaketKopfsatz(paket, writer);
            List<DVSBestand> lb = paket.getBestandListe();
            for (DVSBestand bestand : lb) {
                if (bestand.isErroneous()) continue;
                if (bestand instanceof DVSBestandSART) {
                    this.curBestand = (DVSBestandSART)bestand;
                    this.exportBestand((DVSBestandSART)bestand);
                    continue;
                }
                throw new DVSParseException("No SART Bestand object provided.");
            }
            this.exportPaketEndesatz(paket, writer);
        }
        catch (DVSParseException | IOException ex) {
            throw new DVSExportException(ex);
        }
    }

    protected void exportBestand(DVSBestandSART bestand) throws DVSExportException {
        try {
            super.exportBestand(bestand);
            final Writer writer = this.getWriter(AbstractExporter.ExportLevel.BESTAND);
            this.exportBestandVorsatz(bestand, writer);
            if (!bestand.isEmpfangsBestaetigung()) {
                try (LineReader lr = new LineReader(bestand.getDataLocation().getInputStream(), bestand.getCharset(), new LineHandler(){

                    @Override
                    public boolean handleLine(String line, long lineNumber, long byteOffset) throws DVSParseException {
                        try {
                            writer.write(line);
                        }
                        catch (IOException ex) {
                            throw new DVSParseException(ex);
                        }
                        return true;
                    }
                });){
                    if (this.isAddLineFlags(bestand)) {
                        lr.addLineFilter(new PrependStringFilter(DVSConstants.DAORG_Satzkennzeichen.DATENSATZ.toString()));
                    }
                    if (this.minLineLength > 0) {
                        lr.addLineFilter(new LineInflater(this.minLineLength));
                    }
                    for (LineFilter lf : this.lineFilterList) {
                        lr.addLineFilter(lf);
                    }
                    lr.addLineFilter(new AppendStringFilter(this.lineEnd), true);
                    long skipTil = bestand.getLineEnd() > 0L ? bestand.getLineStart() : 0L;
                    lr.setSkipTil(skipTil);
                    long readTil = bestand.getLineEnd();
                    lr.setReadTil(readTil);
                    lr.start();
                }
            } else {
                List<DVSEmpfangsBestaetigungSART> ebList = bestand.getEBList();
                for (DVSEmpfangsBestaetigungSART eb : ebList) {
                    this.exportEmpfangsBestaetigung(eb, writer);
                }
            }
            this.exportBestandNachsatz(bestand, writer);
        }
        catch (DVSParseException | IOException ex) {
            throw new DVSExportException(ex);
        }
    }

    protected void exportPaketKopfsatz(DVSPaket p, Writer writer) throws IOException {
        writer.write(SARTFormatter.formatPaketKopfsatz(p) + this.lineEnd);
    }

    protected void exportPaketEndesatz(DVSPaket p, Writer writer) throws IOException {
        writer.write(SARTFormatter.formatPaketEndesatz(p) + this.lineEnd);
    }

    protected void exportBestandVorsatz(DVSBestand b, Writer writer) throws IOException {
        writer.write(SARTFormatter.formatBestandVorsatz(b) + this.lineEnd);
    }

    protected void exportBestandNachsatz(DVSBestand b, Writer writer) throws IOException {
        writer.write(SARTFormatter.formatBestandNachsatz(b) + this.lineEnd);
    }

    protected void exportEmpfangsBestaetigung(DVSEmpfangsBestaetigungSART eb, Writer writer) throws IOException {
        if (eb.isErroneous()) {
            return;
        }
        writer.write(SARTFormatter.formatEmpfangsBestaetigung(eb) + this.lineEnd);
    }

    protected Writer getWriter(AbstractExporter.ExportLevel level) throws IOException, DVSExportException {
        if (this.curWriter == null) {
            if (Files.isDirectory(this.path, new LinkOption[0])) {
                this.curWriter = this.getWriter(this.getFileDataLocation());
            } else {
                this.oneFilePerPaket = false;
                this.curWriter = this.getWriter(new FileDataLocation(this.path));
            }
        } else if (this.oneFilePerPaket && level == AbstractExporter.ExportLevel.PAKET) {
            this.curWriter.flush();
            this.curWriter.close();
            this.curWriter = this.getWriter(this.getFileDataLocation());
        }
        return this.curWriter;
    }

    protected Writer getWriter(DVSDataLocation dl) throws IOException {
        return new OutputStreamWriter((OutputStream)new BufferedOutputStream(dl.getOutputStream()), this.charset);
    }

    protected FileDataLocation getFileDataLocation() throws IOException, DVSExportException {
        String fName = this.constructFileName(true, false, this.isFileNameOldStyle());
        return new FileDataLocation(fName);
    }

    public void addLineFilter(LineFilter lineFilter) {
        this.lineFilterList.add(lineFilter);
    }

    public boolean isAddCR() {
        return this.addCR;
    }

    public void setAddCR(boolean addCR) {
        this.addCR = addCR;
        this.lineEnd = addCR ? "\r\n" : "\n";
    }

    public boolean isAddLineFlags(DVSBestandSART b) {
        return this.addLineFlags && !b.hasLineFlags();
    }

    public boolean getAddLineFlags() {
        return this.addLineFlags;
    }

    public void setAddLineFlags(boolean addLineFlags) {
        this.addLineFlags = addLineFlags;
    }

    public boolean isOneFilePerPaket() {
        return this.oneFilePerPaket;
    }

    public void setOneFilePerPaket(boolean oneFilePerPaket) {
        this.oneFilePerPaket = oneFilePerPaket;
    }

    public int getMinLineLength() {
        return this.minLineLength;
    }

    public void setMinLineLength(int minLineLength) {
        this.minLineLength = minLineLength;
    }

    public boolean isFileNameOldStyle() {
        return this.fileNameOldStyle;
    }

    public void setFileNameOldStyle(boolean fileNameOldStyle) {
        this.fileNameOldStyle = fileNameOldStyle;
    }
}

