/*
 * Decompiled with CFR 0.152.
 */
package at.itsv.dvs.io;

import at.itsv.dvs.io.DVSExportException;
import at.itsv.dvs.io.XMLPAKExporter;
import at.itsv.dvs.model.DVSModel;
import at.itsv.dvs.model.InvalidDataException;
import at.itsv.dvs.util.refno.ReferenzNummerException;
import java.io.IOException;
import java.nio.file.Path;
import javax.xml.bind.JAXBException;
import javax.xml.datatype.DatatypeConfigurationException;

public class EBXMLExporter
extends XMLPAKExporter {
    private String ZVST = "99";
    private String UVST = null;

    public EBXMLExporter(String path, String VSTR) throws DVSExportException {
        super(path, VSTR);
    }

    public EBXMLExporter(Path path, String VSTR) throws DVSExportException {
        super(path, VSTR);
    }

    @Override
    public void doExport(DVSModel dvsModel) throws DVSExportException {
        if (this.UVST == null) {
            this.UVST = this.VSTR;
        }
        try {
            dvsModel.convert2EBXML(this.ZVST, this.UVST, this.xmlType);
        }
        catch (InvalidDataException | ReferenzNummerException | IOException | JAXBException | DatatypeConfigurationException ex) {
            throw new DVSExportException(ex);
        }
        super.doExport(dvsModel);
    }

    public String getZVST() {
        return this.ZVST;
    }

    public void setZVST(String zVST) {
        this.ZVST = zVST;
    }

    public String getUVST() {
        return this.UVST;
    }

    public void setUVST(String uVST) {
        this.UVST = uVST;
    }
}

