/*
 * Decompiled with CFR 0.152.
 */
package at.itsv.dvs.io;

import at.itsv.dvs.io.AbstractExporter;
import at.itsv.dvs.io.DVSExportException;
import at.itsv.dvs.model.DVSBestand;
import at.itsv.dvs.model.DVSModel;
import at.itsv.dvs.model.DVSPaket;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;

public class EinzelBestandExporter
extends AbstractExporter {
    private boolean testFlag = false;
    private boolean useDirStruct = false;
    private String zvob = null;

    public EinzelBestandExporter(String path, String VSTR) {
        this(Paths.get(path, new String[0]), VSTR);
    }

    public EinzelBestandExporter(Path path, String VSTR) {
        this.path = path;
        this.VSTR = VSTR;
    }

    @Override
    public void doExport(DVSModel dvsModel) throws DVSExportException {
        super.doExport(dvsModel);
        List<DVSPaket> lp = dvsModel.getPakete();
        for (DVSPaket p : lp) {
            this.exportPaket(p);
        }
    }

    @Override
    protected void exportPaket(DVSPaket paket) throws DVSExportException {
        super.exportPaket(paket);
        List<DVSBestand> lb = paket.getBestandListe();
        for (DVSBestand bestand : lb) {
            this.exportBestand(bestand);
        }
    }

    @Override
    protected void exportBestand(DVSBestand bestand) throws DVSExportException {
        try {
            String fileName = this.constructEinzelFileName(bestand, this.useDirStruct, this.testFlag, this.zvob);
            super.exportBestand(bestand);
            Path p = Paths.get(fileName, new String[0]);
            Files.copy(bestand.getDataLocation().getInputStream(), p, new CopyOption[0]);
        }
        catch (IOException ex) {
            throw new DVSExportException(ex);
        }
    }

    public boolean isUseDirStruct() {
        return this.useDirStruct;
    }

    public void setUseDirStruct(boolean useDirStruct) {
        this.useDirStruct = useDirStruct;
    }

    public boolean isTestFlag() {
        return this.testFlag;
    }

    public void setTestFlag(boolean testFlag) {
        this.testFlag = testFlag;
    }

    public String getZVOB() {
        return this.zvob;
    }

    public void setZVOB(String zvob) {
        this.zvob = zvob;
    }
}

