/*
 * Decompiled with CFR 0.152.
 */
package at.itsv.dvs.io;

import at.itsv.dvs.io.AbstractImporter;
import at.itsv.dvs.io.DVSImportException;
import at.itsv.dvs.io.FileDataLocation;
import at.itsv.dvs.io.FileProvider;
import at.itsv.dvs.io.ImportListener;
import at.itsv.dvs.model.DVSBestand;
import at.itsv.dvs.model.DVSBestandSART;
import at.itsv.dvs.model.DVSModel;
import at.itsv.dvs.model.DVSPaket;
import at.itsv.dvs.model.DVSPaketSART;
import at.itsv.dvs.model.InvalidDataException;
import at.itsv.dvs.parser.DVSParseException;
import at.itsv.dvs.parser.SARTParser;
import at.itsv.dvs.util.DVSConstants;
import at.itsv.dvs.util.DVSUtils;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class EinzelBestandImporter
extends AbstractImporter {
    private String ZVPA;
    private String UVPA;
    private String VSTR;
    private boolean useDirStruct = false;
    private boolean sart = false;
    private boolean lineFlags = false;

    public EinzelBestandImporter(String path, String VSTR, String ZVPA, String UVPA) throws DVSImportException {
        this(path, "UTF-8", VSTR, ZVPA, UVPA);
    }

    public EinzelBestandImporter(String path, String charset, String VSTR, String ZVPA, String UVPA) throws DVSImportException {
        this(Paths.get(path, new String[0]), charset, VSTR, ZVPA, UVPA);
    }

    public EinzelBestandImporter(Path path, String VSTR, String ZVPA, String UVPA) throws DVSImportException {
        this(path, "UTF-8", VSTR, ZVPA, UVPA);
    }

    public EinzelBestandImporter(Path path, String charset, String VSTR, String ZVPA, String UVPA) throws DVSImportException {
        if (!Files.exists(path, new LinkOption[0])) {
            throw new DVSImportException(DVSUtils.getMessage("error.path.invalid", path.toString()));
        }
        Objects.requireNonNull(ZVPA, "ZVPA must not be null");
        Objects.requireNonNull(UVPA, "UVPA must not be null");
        Objects.requireNonNull(VSTR, "VSTR must not be null");
        if (ZVPA.length() < 2) {
            throw new IllegalArgumentException("Invalid ZVPA specified.");
        }
        if (UVPA.length() < 2) {
            throw new IllegalArgumentException("Invalid UVPA specified.");
        }
        if (VSTR.length() < 2) {
            throw new IllegalArgumentException("Invalid VSTR specified.");
        }
        this.path = path;
        this.charset = charset;
        this.ZVPA = ZVPA;
        this.UVPA = UVPA;
        this.VSTR = VSTR;
    }

    @Override
    public DVSModel doImport() throws DVSImportException {
        try {
            DVSModel dvsModel = super.doImport();
            List<Object> paths = new ArrayList();
            paths = this.isUseDirStruct() ? FileProvider.walkDirectory(this.path) : FileProvider.provideFiles(this.path, this.pattern);
            DVSPaket paket = this.getPaket();
            int i = 0;
            int size = paths.size();
            for (Path path : paths) {
                for (ImportListener listener : this.getImportListener()) {
                    listener.importFile(path.toString(), ++i, size);
                }
                DVSBestand bestand = this.getBestandFromFileName(path);
                if (bestand == null) {
                    throw new DVSImportException(DVSUtils.getMessage("error.einzelbestand.invalid", path.toString()));
                }
                bestand.setDataLocation(new FileDataLocation(path, true));
                if (this.sart) {
                    if (this.lineFlags) {
                        SARTParser parser = new SARTParser(DVSConstants.SARTType.EINZELBESTAND);
                        parser.setCharset(this.charset);
                        parser.setRetainData(this.retainData);
                        parser.setCurrentPaket((DVSPaketSART)paket);
                        parser.setCurrentBestand((DVSBestandSART)bestand);
                        dvsModel = parser.parse(new FileDataLocation(path), dvsModel);
                        parser.reset();
                        continue;
                    }
                    ((DVSBestandSART)bestand).setLineFlags(false);
                    ((DVSBestandSART)bestand).countLines();
                    paket.addBestand((DVSBestandSART)bestand);
                    paket.setSatzAnzahl(paket.getSatzAnzahl() + bestand.getSatzAnzahl());
                    continue;
                }
                paket.addBestand(bestand);
            }
            if (this.isRetainData()) {
                dvsModel.addPaket(paket);
            }
            for (ImportListener importListener : this.getImportListener()) {
                importListener.importPaket(paket);
            }
            if (!this.isRetainData()) {
                paket.clear();
            }
            return dvsModel;
        }
        catch (InvalidDataException | DVSParseException | IOException ex) {
            throw new DVSImportException(ex);
        }
    }

    private DVSPaket getPaket() throws InvalidDataException {
        DVSPaket paket;
        if (this.isSart()) {
            paket = new DVSPaketSART(this.ZVPA, this.UVPA);
            paket.setSatzAnzahl(2L);
        } else {
            paket = new DVSPaket(this.ZVPA, this.UVPA);
        }
        return paket;
    }

    private DVSBestand getBestandFromFileName(Path path) throws InvalidDataException {
        DVSBestand bestand = null;
        if (!this.isUseDirStruct()) {
            String fname = path.getFileName().toString();
            String[] arr = fname.split("\\.|_");
            if (arr.length < 5) {
                return null;
            }
            bestand = this.sart ? new DVSBestandSART(arr[1], arr[2], arr[3], arr[4]) : new DVSBestand(arr[1], arr[2], arr[3], arr[4]);
            if (arr.length > 5) {
                bestand.setTestKennzeichen(arr[5].trim());
            }
            if (arr.length > 6) {
                bestand.setZusaetzlOrdnungsbegriff(DVSUtils.fullURLdecode(arr[6]));
            }
        } else {
            String zvst = null;
            String list = null;
            String proj = null;
            Path parent = path.getParent();
            if (parent == null || parent.getNameCount() < 1) {
                return null;
            }
            zvst = parent.getName(parent.getNameCount() - 1).toString();
            if (parent == null || parent.getNameCount() < 2) {
                return null;
            }
            list = parent.getName(parent.getNameCount() - 2).toString();
            Path grandParent = parent.getParent();
            if (grandParent == null || grandParent.getNameCount() < 2) {
                return null;
            }
            proj = grandParent.getName(grandParent.getNameCount() - 2).toString();
            bestand = this.sart ? new DVSBestandSART(zvst, this.VSTR, proj, list) : new DVSBestand(zvst, this.VSTR, proj, list);
        }
        if (this.sart) {
            bestand.setSatzAnzahl(2L);
        }
        for (ImportListener listener : this.getImportListener()) {
            listener.importBestand(bestand);
        }
        return bestand;
    }

    @Override
    public String getPattern() {
        return this.pattern;
    }

    @Override
    public void setPattern(String pattern) {
        this.pattern = pattern;
    }

    public boolean hasLineFlags() {
        return this.lineFlags;
    }

    public void setLineFlags(boolean lineFlags) {
        this.lineFlags = lineFlags;
    }

    public boolean isUseDirStruct() {
        return this.useDirStruct;
    }

    public void setUseDirStruct(boolean useDirStruct) {
        this.useDirStruct = useDirStruct;
    }

    public boolean isSart() {
        return this.sart;
    }

    public void setSart(boolean sart) {
        this.sart = sart;
    }
}

