/*
 * Decompiled with CFR 0.152.
 */
package at.itsv.dvs.io;

import at.itsv.dvs.io.DVSExportException;
import at.itsv.dvs.io.ExportListener;
import at.itsv.dvs.model.DVSBestand;
import at.itsv.dvs.model.DVSBestandXML;
import at.itsv.dvs.model.DVSDataDescriptor;
import at.itsv.dvs.model.DVSPaket;
import at.itsv.dvs.model.InvalidDataException;
import at.itsv.dvs.model.xsd15.AboType;
import at.itsv.dvs.model.xsd15.BestandType;
import at.itsv.dvs.model.xsd15.DatendrehscheibePaketType;
import at.itsv.dvs.util.DVSConstants;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.apache.commons.codec.binary.Hex;

public class ExportTemplateManager
implements ExportListener {
    private Map<String, ExportTemplate> templates = new HashMap<String, ExportTemplate>();
    private ExportTemplate defaultTemplate;
    private String templateFile;
    private String paketBezeichnung;

    public ExportTemplateManager(String templateFile) throws DVSExportException {
        if (!Files.exists(Paths.get(templateFile, new String[0]), new LinkOption[0]) || Files.isDirectory(Paths.get(templateFile, new String[0]), new LinkOption[0])) {
            throw new DVSExportException("Invalid templatefile specified.");
        }
        if (Files.exists(Paths.get(templateFile, new String[0]), new LinkOption[0])) {
            this.unmarshalTemplate(templateFile);
        }
        this.templateFile = templateFile;
    }

    @Override
    public void exportPaket(DVSPaket paket) throws DVSExportException {
        try {
            if (paket.getPaketBezeichnung() == null || paket.getPaketBezeichnung().length() == 0) {
                paket.setPaketBezeichnung(this.paketBezeichnung);
            }
        }
        catch (InvalidDataException ex) {
            throw new DVSExportException(ex);
        }
    }

    @Override
    public void exportBestand(DVSBestand bestand) throws DVSExportException {
        String list;
        String proj = bestand.getProjektKennzeichen();
        ExportTemplate template = this.getTemplateBestand(proj, list = bestand.getListKennzeichen());
        if (template == null) {
            return;
        }
        try {
            DVSBestandXML templateBestand = template.getBestand();
            if (bestand.getAenderungsDienstNummer() == null || bestand.getAenderungsDienstNummer().length() == 0) {
                bestand.setAenderungsDienstNummer(templateBestand.getAenderungsDienstNummer());
            }
            if (bestand.getEingabeBestandsNummer() == null || bestand.getEingabeBestandsNummer().length() == 0) {
                bestand.setEingabeBestandsNummer(templateBestand.getEingabeBestandsNummer());
            }
            if (bestand.getEingabeArt() == null || bestand.getEingabeArt().length() == 0) {
                bestand.setEingabeArt(templateBestand.getEingabeArt());
            }
            if (bestand.getTestKennzeichen() == null || bestand.getTestKennzeichen().length() == 0 || bestand.getTestKennzeichen().equals(" ")) {
                bestand.setTestKennzeichen(templateBestand.getTestKennzeichen());
            }
            if (bestand.getZusaetzlOrdnungsbegriff() == null || bestand.getZusaetzlOrdnungsbegriff().length() == 0) {
                String zvobFunction = template.getZvobFunction();
                if (zvobFunction != null && zvobFunction.length() > 0) {
                    bestand.setZusaetzlOrdnungsbegriff(this.applyZVOBFunction(zvobFunction.trim(), bestand));
                } else {
                    bestand.setZusaetzlOrdnungsbegriff(templateBestand.getZusaetzlOrdnungsbegriff());
                }
            }
            if (bestand.getZusaetzlInfo() == null || bestand.getZusaetzlInfo().length() == 0) {
                bestand.setZusaetzlInfo(templateBestand.getZusaetzlInfo());
            }
            if (bestand.getSatzAnzahl() == 0L) {
                bestand.setSatzAnzahl(templateBestand.getSatzAnzahl());
            }
            DVSDataDescriptor dd = bestand.getDataDescriptor();
            dd.setEncrypted(templateBestand.getDataDescriptor().isEncrypted());
            dd.setSigned(templateBestand.getDataDescriptor().isSigned());
            dd.setZipped(templateBestand.getDataDescriptor().isZipped());
            if (dd.getContentType() == null || dd.getContentType().length() == 0) {
                dd.setContentType(templateBestand.getDataDescriptor().getContentType());
            }
            if (dd.getHash() == null || dd.getHash().length() == 0) {
                String digestAlg = template.getDigestAlg();
                if (digestAlg != null && digestAlg.length() > 0) {
                    dd.setHash(this.computeHash(digestAlg, bestand));
                } else {
                    dd.setHash(templateBestand.getDataDescriptor().getHash());
                }
            }
            if (bestand.getAbonnement() == null) {
                bestand.setAbonnement(templateBestand.getAbonnement());
            }
            if (bestand.getOlInfo() == null) {
                bestand.setOlInfo(templateBestand.getOlInfo());
            }
        }
        catch (InvalidDataException | IOException | NoSuchAlgorithmException ex) {
            throw new DVSExportException(ex);
        }
    }

    protected ExportTemplate getTemplateBestand(String proj, String list) throws DVSExportException {
        ExportTemplate template = this.templates.get(proj + "_" + list);
        if (template == null) {
            template = this.defaultTemplate;
        }
        return template;
    }

    protected void unmarshalTemplate(String templateFile) throws DVSExportException {
        try {
            if (!Files.exists(Paths.get(templateFile, new String[0]), new LinkOption[0]) || Files.isDirectory(Paths.get(templateFile, new String[0]), new LinkOption[0])) {
                throw new DVSExportException("Cannot parse template file [" + templateFile + "]");
            }
            JAXBContext ctx = JAXBContext.newInstance((String)DVSConstants.XMLType.XSD15.getContext());
            Unmarshaller um = ctx.createUnmarshaller();
            JAXBElement root = um.unmarshal((Source)new StreamSource(new FileInputStream(templateFile)), DatendrehscheibePaketType.class);
            DatendrehscheibePaketType ddsPaket = (DatendrehscheibePaketType)root.getValue();
            if (ddsPaket.getBestandsListe() == null) {
                throw new DVSExportException("Template file [" + templateFile + "] fehlerhaft. Leere Bestandsliste.");
            }
            if (ddsPaket.getPaketkopf() != null) {
                this.paketBezeichnung = ddsPaket.getPaketkopf().getPaketbezeichnung();
            }
            List<BestandType> lbt = ddsPaket.getBestandsListe().getBestand();
            for (BestandType bt : lbt) {
                ExportTemplate template = new ExportTemplate();
                if (this.isZVOBFunction(bt.getBestandsInfo().getZusaetzlOrdnungsbegriff())) {
                    template.setZvobFunction(bt.getBestandsInfo().getZusaetzlOrdnungsbegriff());
                    bt.getBestandsInfo().setZusaetzlOrdnungsbegriff("");
                }
                if (bt.getFileInfo() != null) {
                    bt.getFileInfo().setLinkAufBestandsFile("");
                    if (bt.getFileInfo().getInhalt() == null) {
                        bt.getFileInfo().setInhalt("");
                    }
                    if (bt.getFileInfo().getHashWert() != null && bt.getFileInfo().getHashWert().length() > 0) {
                        template.setDigestAlg(bt.getFileInfo().getHashWert());
                        bt.getFileInfo().setHashWert("");
                    } else {
                        bt.getFileInfo().setHashWert("");
                    }
                }
                if (bt.getAboInfo() != null) {
                    if (bt.getAboInfo().getAbo() == null) {
                        bt.getAboInfo().setAbo(AboType.N);
                    }
                    if (bt.getAboInfo().getAboKey() == null) {
                        bt.getAboInfo().setAboKey("");
                    }
                    if (bt.getAboInfo().getAbo() == AboType.J && bt.getAboInfo().getAboKey().equals("")) {
                        throw new InvalidDataException("AboKey fehlt.");
                    }
                }
                if (bt.getDDSOLInfo() != null) {
                    if (bt.getDDSOLInfo().getHinweis1() == null) {
                        bt.getDDSOLInfo().setHinweis1("");
                    }
                    if (bt.getDDSOLInfo().getHinweis2() == null) {
                        bt.getDDSOLInfo().setHinweis2("");
                    }
                }
                if (bt.getBestandsInfo().getZielpartnerCode() == null || bt.getBestandsInfo().getZielpartnerCode().length() == 0) {
                    bt.getBestandsInfo().setZielpartnerCode("XX");
                }
                if (bt.getBestandsInfo().getUrsprungspartnerCode() == null || bt.getBestandsInfo().getUrsprungspartnerCode().length() == 0) {
                    bt.getBestandsInfo().setUrsprungspartnerCode("XX");
                }
                String proj = bt.getBestandsInfo().getProjektKennzeichen();
                String list = bt.getBestandsInfo().getListKennzeichen();
                if (!(proj != null && proj.length() != 0 || list != null && list.length() != 0)) {
                    this.defaultTemplate = template;
                    bt.getBestandsInfo().setProjektKennzeichen("XX");
                    bt.getBestandsInfo().setListKennzeichen("XX");
                } else {
                    this.templates.put(proj + "_" + list, template);
                }
                template.setBestand(new DVSBestandXML(bt));
            }
        }
        catch (InvalidDataException | FileNotFoundException | NoSuchAlgorithmException | JAXBException ex) {
            String message = "Template file [" + templateFile + "] fehlerhaft.";
            if (ex instanceof InvalidDataException) {
                message = message + " " + ex.getMessage();
            }
            throw new DVSExportException(message, ex);
        }
    }

    private String computeHash(String digestAlg, DVSBestand bestand) throws NoSuchAlgorithmException, IOException {
        byte[] buf = new byte[1024];
        MessageDigest md = MessageDigest.getInstance(digestAlg);
        try (BufferedInputStream in = new BufferedInputStream(bestand.getDataLocation().getInputStream());){
            String digest;
            int read = 0;
            while ((read = in.read(buf)) != -1) {
                md.update(buf, 0, read);
            }
            byte[] mdBytes = md.digest();
            String string = digest = new String(Hex.encodeHexString((byte[])mdBytes));
            return string;
        }
    }

    private String applyZVOBFunction(String zvob, DVSBestand bestand) {
        zvob = zvob.replaceAll(Pattern.quote("${ZVST}"), bestand.getZielPartnerCode());
        zvob = zvob.replaceAll(Pattern.quote("${UVST}"), bestand.getUrsprungsPartnerCode());
        zvob = zvob.replaceAll(Pattern.quote("${PROJ}"), bestand.getProjektKennzeichen());
        zvob = zvob.replaceAll(Pattern.quote("${LIST}"), bestand.getListKennzeichen());
        zvob = zvob.replaceAll(Pattern.quote("${REFNR}"), bestand.getReferenzNummer());
        return zvob;
    }

    private boolean isZVOBFunction(String zvob) {
        if (zvob == null) {
            return false;
        }
        return zvob.contains("${ZVST}") || zvob.contains("${UVST}") || zvob.contains("${PROJ}") || zvob.contains("${LIST}") || zvob.contains("${REFNR}");
    }

    @Override
    public void exportFile(String fileName) throws DVSExportException {
    }

    public String getTemplateFile() {
        return this.templateFile;
    }

    class ExportTemplate {
        private DVSBestandXML bestand;
        private String zvobFunction = "";
        private String digestAlg = "";

        public ExportTemplate() {
        }

        public ExportTemplate(DVSBestandXML bestand, String zvobFunction, String digestAlg) throws NoSuchAlgorithmException {
            this.bestand = bestand;
            this.zvobFunction = zvobFunction;
            this.setDigestAlg(digestAlg);
        }

        public DVSBestandXML getBestand() {
            return this.bestand;
        }

        public void setBestand(DVSBestandXML bestand) {
            this.bestand = bestand;
        }

        public String getZvobFunction() {
            return this.zvobFunction;
        }

        public void setZvobFunction(String zvobFunction) {
            this.zvobFunction = zvobFunction;
        }

        public String getDigestAlg() {
            return this.digestAlg;
        }

        public void setDigestAlg(String digestAlg) throws NoSuchAlgorithmException {
            MessageDigest.getInstance(digestAlg);
            this.digestAlg = digestAlg;
        }
    }
}

