/*
 * Decompiled with CFR 0.152.
 */
package at.itsv.dvs.io;

import at.itsv.dvs.model.DVSDataLocation;
import at.itsv.dvs.util.DVSConstants;
import at.itsv.dvs.util.DVSUtils;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.nio.channels.Channels;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.apache.commons.io.ByteOrderMark;
import org.apache.commons.io.input.BOMInputStream;
import org.apache.commons.io.input.BoundedInputStream;

public class FileDataLocation
implements DVSDataLocation {
    protected Path path;
    protected DVSConstants.CompressionType compressionType = DVSConstants.CompressionType.NONE;
    protected long offSetStart = -1L;
    protected long offSetEnd = -1L;

    public FileDataLocation(String fileName) throws IOException {
        this(fileName, false);
    }

    public FileDataLocation(String fileName, boolean ignoreCompressionType) throws IOException {
        this(Paths.get(fileName, new String[0]), ignoreCompressionType);
    }

    public FileDataLocation(Path path) throws IOException {
        this(path, false);
    }

    public FileDataLocation(Path path, boolean ignoreCompressionType) throws IOException {
        this.path = path;
        if (!ignoreCompressionType) {
            this.compressionType = DVSUtils.getCompressionTypeFromPath(path);
        }
    }

    @Override
    public String getLocationInfo() {
        return this.path.toString();
    }

    @Override
    public InputStream getInputStream() throws IOException {
        Object in = new BOMInputStream((InputStream)new BufferedInputStream(Files.newInputStream(this.path, new OpenOption[0])), new ByteOrderMark[]{ByteOrderMark.UTF_8, ByteOrderMark.UTF_16LE, ByteOrderMark.UTF_16BE, ByteOrderMark.UTF_32LE, ByteOrderMark.UTF_32BE});
        switch (this.compressionType) {
            case ZIP: {
                ZipInputStream zipIn = new ZipInputStream((InputStream)in);
                ZipEntry entry = zipIn.getNextEntry();
                in = new ZipFile(this.path.toFile()).getInputStream(entry);
                break;
            }
            case GZIP: {
                in = new GZIPInputStream((InputStream)in);
                break;
            }
            default: {
                if (this.offSetEnd <= 0L) break;
                ((InputStream)in).close();
                RandomAccessFile ra = new RandomAccessFile(this.path.toFile(), "r");
                ra.seek(this.offSetStart);
                in = new BoundedInputStream(Channels.newInputStream(ra.getChannel()), this.offSetEnd - this.offSetStart);
            }
        }
        return in;
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        OutputStream out = Files.newOutputStream(this.path, new OpenOption[0]);
        switch (this.compressionType) {
            case ZIP: {
                String entryName = DVSUtils.trimExtension(this.path);
                ZipEntry entry = new ZipEntry(entryName);
                out = new ZipOutputStream(out);
                ((ZipOutputStream)out).putNextEntry(entry);
                break;
            }
            case GZIP: {
                out = new GZIPOutputStream(out);
                break;
            }
        }
        return out;
    }

    @Override
    public long getSize() throws IOException {
        return Files.size(this.path);
    }

    public File getFile() {
        return this.path.toFile();
    }

    public Path getPath() {
        return this.path;
    }

    public DVSConstants.CompressionType getCompressionType() {
        return this.compressionType;
    }

    public long getOffSetStart() {
        return this.offSetStart;
    }

    public void setOffSetStart(long offSetStart) {
        this.offSetStart = offSetStart;
    }

    public long getOffSetEnd() {
        return this.offSetEnd;
    }

    public void setOffSetEnd(long offSetEnd) {
        this.offSetEnd = offSetEnd;
    }
}

