/*
 * Decompiled with CFR 0.152.
 */
package at.itsv.dvs.io;

import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.List;

public class FileProvider {
    public static List<Path> provideFiles(Path path) throws IOException {
        return FileProvider.provideFiles(path, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<Path> provideFiles(Path path, String pattern) throws IOException {
        ArrayList<Path> paths = new ArrayList<Path>();
        if (!Files.isDirectory(path, new LinkOption[0])) {
            paths.add(path);
        } else {
            try (DirectoryStream<Path> stream = null;){
                stream = pattern != null && pattern != "" ? Files.newDirectoryStream(path, pattern) : Files.newDirectoryStream(path);
                for (Path entry : stream) {
                    if (Files.isDirectory(entry, new LinkOption[0])) continue;
                    paths.add(entry);
                }
            }
        }
        return paths;
    }

    public static List<Path> walkDirectory(Path path) throws IOException {
        final ArrayList<Path> paths = new ArrayList<Path>();
        Files.walkFileTree(path, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path path, BasicFileAttributes attribs) {
                paths.add(path);
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult visitFileFailed(Path file, IOException exc) {
                return FileVisitResult.SKIP_SUBTREE;
            }
        });
        return paths;
    }
}

