/*
 * Decompiled with CFR 0.152.
 */
package at.itsv.dvs.io;

import at.itsv.dvs.model.DVSDataLocation;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Objects;

public class MemoryDataLocation
implements DVSDataLocation {
    private byte[] buf;

    public MemoryDataLocation(byte[] buf) {
        Objects.requireNonNull(buf, "buf must not be null");
        this.buf = buf;
    }

    @Override
    public String getLocationInfo() {
        return "";
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return new ByteArrayInputStream(this.buf);
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        throw new IOException("MemoryDataLocation is read-only");
    }

    @Override
    public long getSize() throws IOException {
        return this.buf.length;
    }
}

