/*
 * Decompiled with CFR 0.152.
 */
package at.itsv.dvs.io;

import at.itsv.dvs.io.AbstractSARTImporter;
import at.itsv.dvs.io.DVSImportException;
import at.itsv.dvs.io.FileDataLocation;
import at.itsv.dvs.io.FileProvider;
import at.itsv.dvs.io.ImportListener;
import at.itsv.dvs.model.DVSModel;
import at.itsv.dvs.parser.DVSParseException;
import at.itsv.dvs.parser.SARTParser;
import at.itsv.dvs.util.DVSConstants;
import at.itsv.dvs.util.DVSUtils;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;

public class SAPAKImporter
extends AbstractSARTImporter {
    public SAPAKImporter(String path) throws DVSImportException {
        this(path, "UTF-8");
    }

    public SAPAKImporter(String path, String charset) throws DVSImportException {
        this(Paths.get(path, new String[0]), charset);
    }

    public SAPAKImporter(Path path) throws DVSImportException {
        this(path, "UTF-8");
    }

    public SAPAKImporter(Path path, String charset) throws DVSImportException {
        if (!Files.exists(path, new LinkOption[0])) {
            throw new DVSImportException(DVSUtils.getMessage("error.path.invalid", path.toString()));
        }
        this.path = path;
        this.charset = charset;
    }

    @Override
    public DVSModel doImport() throws DVSImportException {
        try {
            DVSModel dvsModel = super.doImport();
            List<Path> paths = FileProvider.provideFiles(this.path, this.pattern);
            SARTParser parser = new SARTParser(DVSConstants.SARTType.PAKET);
            parser.setCharset(this.charset);
            parser.setSplitData(this.splitData);
            parser.setRetainData(this.retainData);
            if (this.importListener != null) {
                parser.setImportListener(this.importListener);
            }
            int i = 0;
            int size = paths.size();
            for (Path curPath : paths) {
                for (ImportListener listener : this.getImportListener()) {
                    listener.importFile(curPath.toString(), ++i, size);
                }
                dvsModel = parser.parse(new FileDataLocation(curPath), dvsModel);
                parser.reset();
            }
            return dvsModel;
        }
        catch (DVSParseException | IOException ex) {
            throw new DVSImportException(ex);
        }
    }
}

