/*
 * Decompiled with CFR 0.152.
 */
package at.itsv.dvs.io;

import at.itsv.dvs.model.DVSBestand;
import at.itsv.dvs.model.DVSEmpfangsBestaetigungSART;
import at.itsv.dvs.model.DVSPaket;
import at.itsv.dvs.util.DVSConstants;
import at.itsv.dvs.util.DVSUtils;
import java.util.Objects;

public class SARTFormatter {
    public static String formatPaketKopfsatz(DVSPaket paket) {
        Objects.requireNonNull(paket, "paket must not be null");
        StringBuilder sb = new StringBuilder(DVSConstants.DAORG_Satzkennzeichen.PAKET_KOPFSATZ.toString());
        sb.append(paket.getZielPartnerCode());
        sb.append(paket.getUrsprungsPartnerCode());
        sb.append(DVSConstants.SART_DATE_FORMAT.format(paket.getErstellungsDatum()));
        if (paket.getSendeDatum() != null) {
            sb.append(DVSConstants.SART_DATE_FORMAT.format(paket.getSendeDatum()));
        }
        if (paket.getSendeZeit() != null) {
            sb.append(DVSUtils.padRight("", 17 - sb.length()));
            sb.append(DVSConstants.SART_TIME_FORMAT.format(paket.getSendeZeit()));
        }
        if (paket.getPaketBezeichnung() != null && paket.getPaketBezeichnung() != "") {
            sb.append(DVSUtils.padRight("", 28 - sb.length()));
            if (paket.getPaketBezeichnung().length() <= 20) {
                sb.append(paket.getPaketBezeichnung());
            } else {
                sb.append(paket.getPaketBezeichnung().substring(0, 20));
            }
        }
        return sb.toString();
    }

    public static String formatPaketEndesatz(DVSPaket paket) {
        Objects.requireNonNull(paket, "paket must not be null");
        StringBuilder sb = new StringBuilder(DVSConstants.DAORG_Satzkennzeichen.PAKET_ENDESATZ.toString());
        sb.append(paket.getZielPartnerCode());
        sb.append(paket.getUrsprungsPartnerCode());
        sb.append(DVSUtils.padLeft(String.valueOf(paket.getSatzAnzahl()), 8, '0'));
        return sb.toString();
    }

    public static String formatBestandVorsatz(DVSBestand bestand) {
        Objects.requireNonNull(bestand, "bestand must not be null");
        StringBuilder sb = new StringBuilder(DVSConstants.DAORG_Satzkennzeichen.BESTAND_VORSATZ.toString());
        sb.append(bestand.getZielPartnerCode());
        sb.append(bestand.getUrsprungsPartnerCode());
        sb.append(DVSConstants.SART_DATE_FORMAT.format(bestand.getErstellungsDatum()));
        sb.append(bestand.getProjektKennzeichen());
        if (bestand.getAenderungsDienstNummer() != null) {
            sb.append(bestand.getAenderungsDienstNummer());
        }
        if (bestand.getEingabeBestandsNummer() != null) {
            sb.append(DVSUtils.padRight("", 17 - sb.length()));
            sb.append(bestand.getEingabeBestandsNummer());
        }
        if (bestand.getEingabeArt() != null) {
            sb.append(DVSUtils.padRight("", 19 - sb.length()));
            sb.append(bestand.getEingabeArt());
        }
        sb.append(DVSUtils.padRight("", 21 - sb.length()));
        sb.append(bestand.getListKennzeichen());
        if (bestand.getTestKennzeichen() != null) {
            sb.append(bestand.getTestKennzeichen());
        }
        if (bestand.getZusaetzlOrdnungsbegriff() != null) {
            sb.append(DVSUtils.padRight("", 25 - sb.length()));
            if (bestand.getZusaetzlOrdnungsbegriff().length() <= 20) {
                sb.append(bestand.getZusaetzlOrdnungsbegriff());
            } else {
                sb.append(bestand.getZusaetzlOrdnungsbegriff().substring(0, 20));
            }
        }
        return sb.toString();
    }

    public static String formatBestandNachsatz(DVSBestand bestand) {
        Objects.requireNonNull(bestand, "bestand must not be null");
        StringBuilder sb = new StringBuilder(DVSConstants.DAORG_Satzkennzeichen.BESTAND_NACHSATZ.toString());
        sb.append(bestand.getZielPartnerCode());
        sb.append(bestand.getUrsprungsPartnerCode());
        sb.append(DVSUtils.padLeft(String.valueOf(bestand.getSatzAnzahl()), 8, '0'));
        return sb.toString();
    }

    public static String formatEmpfangsBestaetigung(DVSEmpfangsBestaetigungSART eb) {
        Objects.requireNonNull(eb, "eb must not be null");
        StringBuilder sb = new StringBuilder(DVSConstants.DAORG_Satzkennzeichen.DATENSATZ.toString());
        sb.append("EB");
        sb.append(DVSUtils.padLeft(String.valueOf(eb.getSatzAnzahl()), 8, '0'));
        sb.append(eb.getFECO());
        sb.append(DVSConstants.DAORG_Satzkennzeichen.PAKET_KOPFSATZ.toString());
        sb.append(eb.getPaketZielPartnerCode());
        sb.append(eb.getUrsprungsPartnerCode());
        sb.append(DVSConstants.SART_DATE_FORMAT.format(eb.getPaketErstellungsDatum()));
        if (eb.getPaketSendeDatum() != null) {
            sb.append(DVSConstants.SART_DATE_FORMAT.format(eb.getPaketSendeDatum()));
        } else {
            sb.append(DVSUtils.padRight("", 6));
        }
        if (eb.getPaketSendeZeit() != null) {
            sb.append(DVSConstants.SART_TIME_FORMAT.format(eb.getPaketSendeZeit()));
        } else {
            sb.append(DVSUtils.padRight("", 6));
        }
        if (SARTFormatter.isValidString(eb.getPaketPaketBezeichnung())) {
            sb.append(eb.getPaketPaketBezeichnung());
        } else {
            sb.append(DVSUtils.padRight("", 20));
        }
        sb.append(DVSConstants.DAORG_Satzkennzeichen.BESTAND_VORSATZ.toString());
        sb.append(eb.getZielPartnerCode());
        sb.append(eb.getUrsprungsPartnerCode());
        sb.append(DVSConstants.SART_DATE_FORMAT.format(eb.getErstellungsDatum()));
        sb.append(eb.getProjektKennzeichen());
        if (SARTFormatter.isValidString(eb.getAenderungsDienstNummer())) {
            sb.append(eb.getAenderungsDienstNummer());
        } else {
            sb.append(DVSUtils.padRight("", 4));
        }
        if (SARTFormatter.isValidString(eb.getEingabeBestandsNummer())) {
            sb.append(eb.getEingabeBestandsNummer());
        } else {
            sb.append(DVSUtils.padRight("", 2));
        }
        if (SARTFormatter.isValidString(eb.getEingabeArt())) {
            sb.append(eb.getEingabeArt());
        } else {
            sb.append(DVSUtils.padRight("", 2));
        }
        sb.append(eb.getListKennzeichen());
        if (SARTFormatter.isValidString(eb.getTestKennzeichen())) {
            sb.append(eb.getTestKennzeichen());
        } else {
            sb.append(DVSUtils.padRight("", 1));
        }
        if (SARTFormatter.isValidString(eb.getKomprimierungsCode())) {
            sb.append(eb.getKomprimierungsCode());
        } else {
            sb.append(DVSUtils.padRight("", 1));
        }
        if (SARTFormatter.isValidString(eb.getZusaetzlOrdnungsbegriff())) {
            sb.append(eb.getZusaetzlOrdnungsbegriff());
        } else {
            sb.append(DVSUtils.padRight("", 20));
        }
        if (SARTFormatter.isValidString(eb.getExtraInfo())) {
            sb.append(eb.getExtraInfo());
        }
        return sb.toString();
    }

    private static boolean isValidString(String s) {
        return s != null && s.length() > 0;
    }
}

