/*
 * Decompiled with CFR 0.152.
 */
package at.itsv.dvs.io;

import at.itsv.dvs.io.AbstractSARTImporter;
import at.itsv.dvs.io.DVSImportException;
import at.itsv.dvs.io.FileDataLocation;
import at.itsv.dvs.io.FileProvider;
import at.itsv.dvs.io.ImportListener;
import at.itsv.dvs.model.DVSModel;
import at.itsv.dvs.model.DVSPaketSART;
import at.itsv.dvs.model.InvalidDataException;
import at.itsv.dvs.parser.DVSParseException;
import at.itsv.dvs.parser.SARTParser;
import at.itsv.dvs.util.DVSConstants;
import at.itsv.dvs.util.DVSUtils;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.Objects;

public class SASBImporter
extends AbstractSARTImporter {
    private String ZVPA;
    private String UVPA;

    public SASBImporter(String path, String ZVPA, String UVPA) throws DVSImportException {
        this(path, "UTF-8", ZVPA, UVPA);
    }

    public SASBImporter(String path, String charset, String ZVPA, String UVPA) throws DVSImportException {
        this(Paths.get(path, new String[0]), charset, ZVPA, UVPA);
    }

    public SASBImporter(Path path, String ZVPA, String UVPA) throws DVSImportException {
        this(path, "UTF-8", ZVPA, UVPA);
    }

    public SASBImporter(Path path, String charset, String ZVPA, String UVPA) throws DVSImportException {
        if (!Files.exists(path, new LinkOption[0])) {
            throw new DVSImportException(DVSUtils.getMessage("error.path.invalid", path.toString()));
        }
        Objects.requireNonNull(ZVPA, "ZVPA must not be null");
        Objects.requireNonNull(UVPA, "UVPA must not be null");
        if (ZVPA.length() < 2 || UVPA.length() < 2) {
            throw new IllegalArgumentException("Invalid ZVST/UVST specified.");
        }
        this.path = path;
        this.charset = charset;
        this.ZVPA = ZVPA;
        this.UVPA = UVPA;
    }

    @Override
    public DVSModel doImport() throws DVSImportException {
        try {
            DVSModel dvsModel = super.doImport();
            SARTParser parser = new SARTParser(DVSConstants.SARTType.SAMMELBESTAND);
            parser.setCharset(this.charset);
            parser.setRetainData(this.retainData);
            List<Path> paths = FileProvider.provideFiles(this.path, this.pattern);
            int i = 0;
            int size = paths.size();
            for (Path curPath : paths) {
                for (ImportListener listener : this.getImportListener()) {
                    listener.importFile(curPath.toString(), ++i, size);
                }
                DVSPaketSART paket = new DVSPaketSART(this.ZVPA, this.UVPA);
                parser.setCurrentPaket(paket);
                parser.setSplitData(this.splitData);
                dvsModel = parser.parse(new FileDataLocation(curPath), dvsModel);
                parser.reset();
                for (ImportListener listener : this.getImportListener()) {
                    listener.importPaket(paket);
                }
            }
            return dvsModel;
        }
        catch (InvalidDataException | DVSParseException | IOException ex) {
            throw new DVSImportException(ex);
        }
    }
}

