/*
 * Decompiled with CFR 0.152.
 */
package at.itsv.dvs.io;

import at.itsv.dvs.io.AbstractExporter;
import at.itsv.dvs.io.DVSExportException;
import at.itsv.dvs.io.ExportListener;
import at.itsv.dvs.io.FileDataLocation;
import at.itsv.dvs.model.DVSBestand;
import at.itsv.dvs.model.DVSBestandSART;
import at.itsv.dvs.model.DVSBestandXML;
import at.itsv.dvs.model.DVSDataLocation;
import at.itsv.dvs.model.DVSModel;
import at.itsv.dvs.model.DVSPaket;
import at.itsv.dvs.model.InvalidDataException;
import at.itsv.dvs.model.xsd14.BestandKomprimiertType;
import at.itsv.dvs.model.xsd14.BestandType;
import at.itsv.dvs.model.xsd14.BestandsInfoType;
import at.itsv.dvs.model.xsd15.AboInfoType;
import at.itsv.dvs.model.xsd15.AboType;
import at.itsv.dvs.model.xsd15.BestandSigniertType;
import at.itsv.dvs.model.xsd15.BestandVerschluesseltType;
import at.itsv.dvs.model.xsd15.BestandsListeType;
import at.itsv.dvs.model.xsd15.DDSOLInfoType;
import at.itsv.dvs.model.xsd15.DatendrehscheibePaketType;
import at.itsv.dvs.model.xsd15.FileInfoType;
import at.itsv.dvs.model.xsd15.PaketkopfType;
import at.itsv.dvs.util.DVSConstants;
import at.itsv.dvs.util.DVSUtils;
import at.itsv.dvs.util.refno.ReferenzNummerException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Date;
import java.util.List;
import java.util.zip.GZIPOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.namespace.QName;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.ArchiveException;
import org.apache.commons.compress.archivers.ArchiveStreamFactory;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveOutputStream;
import org.apache.commons.compress.utils.IOUtils;
import org.xml.sax.SAXException;

public class XMLPAKExporter
extends AbstractExporter {
    protected DVSConstants.XMLType xmlType = DVSConstants.XMLType.XSD15;
    protected DatendrehscheibePaketType ddsPaket;
    protected at.itsv.dvs.model.xsd14.DatendrehscheibePaketType ddsPaket14;
    protected OutputStream curOutput;
    protected int bestandNo = 0;
    protected boolean dirBased = false;

    public XMLPAKExporter(String path, String VSTR) throws DVSExportException {
        this(Paths.get(path, new String[0]), VSTR);
    }

    public XMLPAKExporter(Path path, String VSTR) throws DVSExportException {
        if (Files.isDirectory(path, new LinkOption[0]) && !Files.exists(path, new LinkOption[0])) {
            throw new DVSExportException(DVSUtils.getMessage("error.path.invalid", path.toString()));
        }
        this.path = path;
        this.VSTR = VSTR;
        this.compressionType = DVSUtils.getCompressionTypeFromPath(path);
        if (this.compressionType == DVSConstants.CompressionType.NONE) {
            this.compressionType = DVSConstants.CompressionType.ZIP;
        }
    }

    @Override
    public void doExport(DVSModel dvsModel) throws DVSExportException {
        super.doExport(dvsModel);
        try {
            String fName = null;
            if (Files.isDirectory(this.path, new LinkOption[0])) {
                if (!Files.exists(this.path, new LinkOption[0])) {
                    throw new IOException(DVSUtils.getMessage("error.path.invalid", this.path.toString()));
                }
                this.dirBased = true;
            } else {
                fName = this.path.toString();
                this.curOutput = this.getZIPOutputStream(fName);
                for (ExportListener listener : this.getExportListener()) {
                    listener.exportFile(fName);
                }
            }
            List<DVSPaket> lp = dvsModel.getPakete();
            for (DVSPaket p : lp) {
                if (p.getBestandCount() == 0) continue;
                if (this.dirBased) {
                    fName = this.constructFileName(false, true);
                    this.curOutput = this.getZIPOutputStream(fName);
                    this.bestandNo = 0;
                }
                switch (this.xmlType) {
                    case XSD15: {
                        this.exportPaket(p);
                        break;
                    }
                    case XSD14: {
                        this.exportPaket14(p);
                    }
                }
            }
            if (!this.dirBased) {
                this.createXMLMessage();
                this.closeZIPOutputStream();
            }
        }
        catch (ReferenzNummerException | IOException | JAXBException | SAXException ex) {
            throw new DVSExportException(ex);
        }
    }

    @Override
    protected void exportPaket(DVSPaket paket) throws DVSExportException {
        try {
            super.exportPaket(paket);
            if (this.dirBased || this.ddsPaket == null) {
                this.ddsPaket = new DatendrehscheibePaketType();
                this.ddsPaket.setPaketkopf(this.getPaketkopfType(paket));
                this.ddsPaket.setBestandsListe(new BestandsListeType());
            }
            List<DVSBestand> lb = paket.getBestandListe();
            for (DVSBestand b : lb) {
                this.exportBestand(b);
            }
            if (this.dirBased) {
                this.createXMLMessage();
                this.closeZIPOutputStream();
            }
        }
        catch (InvalidDataException | IOException | JAXBException | DatatypeConfigurationException | SAXException ex) {
            throw new DVSExportException(ex);
        }
    }

    protected void exportPaket14(DVSPaket paket) throws DVSExportException, ReferenzNummerException {
        try {
            super.exportPaket(paket);
            if (this.dirBased || this.ddsPaket14 == null) {
                this.ddsPaket14 = new at.itsv.dvs.model.xsd14.DatendrehscheibePaketType();
                this.ddsPaket14.setPaketkopf(this.getPaketkopfType14(paket));
                this.ddsPaket14.setBestandsListe(new at.itsv.dvs.model.xsd14.BestandsListeType());
            }
            List<DVSBestand> lb = paket.getBestandListe();
            for (DVSBestand b : lb) {
                this.exportBestand14(b);
            }
            if (this.dirBased) {
                this.createXMLMessage();
                this.closeZIPOutputStream();
            }
        }
        catch (InvalidDataException | IOException | JAXBException | DatatypeConfigurationException | SAXException ex) {
            throw new DVSExportException(ex);
        }
    }

    protected PaketkopfType getPaketkopfType(DVSPaket p) throws DatatypeConfigurationException, InvalidDataException {
        PaketkopfType ddsPaketKopf = new PaketkopfType();
        ddsPaketKopf.setUrsprungspartnerCode(p.getUrsprungsPartnerCode());
        ddsPaketKopf.setZielpartnerCode(p.getZielPartnerCode());
        if (p.getPaketBezeichnung() == null) {
            p.setPaketBezeichnung("");
        }
        ddsPaketKopf.setPaketbezeichnung(p.getPaketBezeichnung());
        ddsPaketKopf.setErstellungsdatum(DVSUtils.date2XMLGregorianCalendar(p.getErstellungsDatum()));
        DVSUtils.xmlGregorianCalendar2XSDATE(ddsPaketKopf.getErstellungsdatum());
        if (p.getSendeDatum() == null) {
            p.setSendeDatum(new Date());
        }
        ddsPaketKopf.setSendedatum(DVSUtils.date2XMLGregorianCalendar(p.getSendeDatum()));
        DVSUtils.xmlGregorianCalendar2XSDATE(ddsPaketKopf.getSendedatum());
        if (p.getSendeZeit() == null) {
            p.setSendeZeit(new Date());
        }
        ddsPaketKopf.setSendezeit(DVSUtils.date2XMLGregorianCalendar(p.getSendeZeit()));
        DVSUtils.xmlGregorianCalendar2XSTIME(ddsPaketKopf.getSendezeit());
        return ddsPaketKopf;
    }

    protected at.itsv.dvs.model.xsd14.PaketkopfType getPaketkopfType14(DVSPaket p) throws DatatypeConfigurationException, InvalidDataException {
        at.itsv.dvs.model.xsd14.PaketkopfType ddsPaketKopf = new at.itsv.dvs.model.xsd14.PaketkopfType();
        ddsPaketKopf.setUrsprungspartnerCode(p.getUrsprungsPartnerCode());
        ddsPaketKopf.setZielpartnerCode(p.getZielPartnerCode());
        if (p.getPaketBezeichnung() == null) {
            p.setPaketBezeichnung("");
        }
        ddsPaketKopf.setPaketbezeichnung(p.getPaketBezeichnung());
        ddsPaketKopf.setErstellungsdatum(DVSUtils.date2XMLGregorianCalendar(p.getErstellungsDatum()));
        DVSUtils.xmlGregorianCalendar2XSDATE(ddsPaketKopf.getErstellungsdatum());
        if (p.getSendeDatum() == null) {
            p.setSendeDatum(new Date());
        }
        ddsPaketKopf.setSendedatum(DVSUtils.date2XMLGregorianCalendar(p.getSendeDatum()));
        DVSUtils.xmlGregorianCalendar2XSDATE(ddsPaketKopf.getSendedatum());
        if (p.getSendeZeit() == null) {
            p.setSendeZeit(new Date());
        }
        ddsPaketKopf.setSendezeit(DVSUtils.date2XMLGregorianCalendar(p.getSendeZeit()));
        DVSUtils.xmlGregorianCalendar2XSTIME(ddsPaketKopf.getSendezeit());
        return ddsPaketKopf;
    }

    @Override
    protected void exportBestand(DVSBestand bestand) throws DVSExportException {
        try {
            bestand.setReferenzNummer(DVSUtils.createXMLReferenzNummer(bestand).toString());
            super.exportBestand(bestand);
            BestandsListeType bestandsListe = this.ddsPaket.getBestandsListe();
            at.itsv.dvs.model.xsd15.BestandType xmlBestand = new at.itsv.dvs.model.xsd15.BestandType();
            xmlBestand.setBestandsInfo(this.getBestandsInfoType(bestand));
            xmlBestand.setFileInfo(this.getFileInfoType(bestand));
            xmlBestand.setAboInfo(this.getAboInfoType(bestand));
            xmlBestand.setDDSOLInfo(this.getDDSOLInfoType(bestand));
            if (xmlBestand.getFileInfo().getLinkAufBestandsFile() == null || xmlBestand.getFileInfo().getLinkAufBestandsFile().length() == 0) {
                xmlBestand.getFileInfo().setLinkAufBestandsFile(DVSUtils.padLeft("" + ++this.bestandNo, 6, '0'));
            }
            bestandsListe.getBestand().add(xmlBestand);
            long size = bestand.getSize();
            this.addZIPEntry(xmlBestand.getFileInfo().getLinkAufBestandsFile(), size);
            this.writeBestand(this.curOutput, bestand);
            if (this.compressionType == DVSConstants.CompressionType.GZIP) {
                ((TarArchiveOutputStream)this.curOutput).closeArchiveEntry();
            }
        }
        catch (InvalidDataException | ReferenzNummerException | IOException | DatatypeConfigurationException ex) {
            throw new DVSExportException(ex);
        }
    }

    protected void exportBestand14(DVSBestand bestand) throws DVSExportException, ReferenzNummerException {
        try {
            super.exportBestand(bestand);
            at.itsv.dvs.model.xsd14.BestandsListeType bestandsListe = this.ddsPaket14.getBestandsListe();
            BestandType xmlBestand = new BestandType();
            xmlBestand.setBestandsInfo(this.getBestandsInfoType14(bestand));
            if (bestand.getDataDescriptor().getLink() == null || bestand.getDataDescriptor().getLink().length() == 0) {
                xmlBestand.setLinkAufBestandsFile(DVSUtils.padLeft("" + ++this.bestandNo, 6, '0'));
            } else {
                xmlBestand.setLinkAufBestandsFile(bestand.getDataDescriptor().getLink());
            }
            bestandsListe.getBestand().add(xmlBestand);
            long size = bestand.getSize();
            this.addZIPEntry(xmlBestand.getLinkAufBestandsFile(), size);
            this.writeBestand(this.curOutput, bestand);
            if (this.compressionType == DVSConstants.CompressionType.GZIP) {
                ((TarArchiveOutputStream)this.curOutput).closeArchiveEntry();
            }
        }
        catch (IOException | DatatypeConfigurationException ex) {
            throw new DVSExportException(ex);
        }
    }

    protected at.itsv.dvs.model.xsd15.BestandsInfoType getBestandsInfoType(DVSBestand b) throws DatatypeConfigurationException, IOException {
        at.itsv.dvs.model.xsd15.BestandsInfoType bi = new at.itsv.dvs.model.xsd15.BestandsInfoType();
        bi.setZielpartnerCode(b.getZielPartnerCode());
        bi.setUrsprungspartnerCode(b.getUrsprungsPartnerCode());
        bi.setProjektKennzeichen(b.getProjektKennzeichen());
        bi.setListKennzeichen(b.getListKennzeichen());
        bi.setErstellungsdatum(DVSUtils.date2XMLGregorianCalendar(b.getErstellungsDatum()));
        DVSUtils.xmlGregorianCalendar2XSDATE(bi.getErstellungsdatum());
        bi.setAenderungsdienstNummer(b.getAenderungsDienstNummer());
        bi.setEingabeBestandsNummer(b.getEingabeBestandsNummer());
        bi.setEingabeArt(b.getEingabeArt());
        bi.setTestKennzeichen(b.getTestKennzeichen());
        bi.setZusaetzlOrdnungsbegriff(b.getZusaetzlOrdnungsbegriff());
        bi.setZusaetzlInfo(b.getZusaetzlInfo());
        bi.setReferenzNummer(b.getReferenzNummer());
        return bi;
    }

    protected BestandsInfoType getBestandsInfoType14(DVSBestand b) throws DatatypeConfigurationException, IOException, ReferenzNummerException {
        BestandsInfoType bi = new BestandsInfoType();
        bi.setZielpartnerCode(b.getZielPartnerCode());
        bi.setUrsprungspartnerCode(b.getUrsprungsPartnerCode());
        bi.setProjektKennzeichen(b.getProjektKennzeichen());
        bi.setListKennzeichen(b.getListKennzeichen());
        bi.setErstellungsdatum(DVSUtils.date2XMLGregorianCalendar(b.getErstellungsDatum()));
        DVSUtils.xmlGregorianCalendar2XSDATE(bi.getErstellungsdatum());
        bi.setAenderungsdienstNummer(b.getAenderungsDienstNummer());
        bi.setEingabeBestandsNummer(b.getEingabeBestandsNummer());
        bi.setEingabeArt(b.getEingabeArt());
        bi.setTestKennzeichen(b.getTestKennzeichen());
        bi.setZusaetzlOrdnungsbegriff(b.getZusaetzlOrdnungsbegriff());
        if (b instanceof DVSBestandXML) {
            DVSBestandXML bestandXML = (DVSBestandXML)b;
            if (bestandXML.getReferenzNummer() != null) {
                bi.setReferenzNummer(bestandXML.getReferenzNummer());
            } else {
                bi.setReferenzNummer(DVSUtils.createXMLReferenzNummer(b).toString());
            }
            bi.setBestandInhalt(b.getDataDescriptor().getContentType());
            bi.setBestandKomprimiert(b.getDataDescriptor().isZipped() ? BestandKomprimiertType.J : BestandKomprimiertType.N);
            bi.setBestandSigniert(b.getDataDescriptor().isSigned() ? at.itsv.dvs.model.xsd14.BestandSigniertType.J : at.itsv.dvs.model.xsd14.BestandSigniertType.N);
            bi.setBestandVerschluesselt(b.getDataDescriptor().isEncrypted() ? at.itsv.dvs.model.xsd14.BestandVerschluesseltType.J : at.itsv.dvs.model.xsd14.BestandVerschluesseltType.N);
        } else {
            bi.setReferenzNummer(DVSUtils.createXMLReferenzNummer(b).toString());
            bi.setBestandInhalt("");
            bi.setBestandKomprimiert(BestandKomprimiertType.N);
            bi.setBestandSigniert(at.itsv.dvs.model.xsd14.BestandSigniertType.N);
            bi.setBestandVerschluesselt(at.itsv.dvs.model.xsd14.BestandVerschluesseltType.N);
        }
        return bi;
    }

    protected FileInfoType getFileInfoType(DVSBestand bestand) {
        FileInfoType fi = new FileInfoType();
        fi.setLinkAufBestandsFile(bestand.getDataDescriptor().getLink());
        fi.setHashWert(bestand.getDataDescriptor().getHash());
        fi.setInhalt(bestand.getDataDescriptor().getContentType());
        fi.setKomprimiert(bestand.getDataDescriptor().isZipped() ? at.itsv.dvs.model.xsd15.BestandKomprimiertType.J : at.itsv.dvs.model.xsd15.BestandKomprimiertType.N);
        fi.setSigniert(bestand.getDataDescriptor().isSigned() ? BestandSigniertType.J : BestandSigniertType.N);
        fi.setVerschluesselt(bestand.getDataDescriptor().isEncrypted() ? BestandVerschluesseltType.J : BestandVerschluesseltType.N);
        fi.setSatzAnzahl(BigInteger.valueOf(bestand.getSatzAnzahl()));
        return fi;
    }

    protected AboInfoType getAboInfoType(DVSBestand b) {
        if (b.getAbonnement() == null) {
            return null;
        }
        AboInfoType ai = new AboInfoType();
        ai.setAbo(AboType.fromValue(b.getAbonnement().getAbo()));
        ai.setAboKey(b.getAbonnement().getAboKey());
        return ai;
    }

    protected DDSOLInfoType getDDSOLInfoType(DVSBestand b) {
        if (b.getOlInfo() == null) {
            return null;
        }
        DDSOLInfoType di = new DDSOLInfoType();
        di.setPartnerCode(b.getOlInfo().getPartnerCode());
        di.setHinweis1(b.getOlInfo().getHint1());
        di.setHinweis2(b.getOlInfo().getHint2());
        return di;
    }

    protected void marshallXML(OutputStream out) throws JAXBException, SAXException {
        JAXBContext ctx = JAXBContext.newInstance((String)this.xmlType.getContext());
        Marshaller m = ctx.createMarshaller();
        m.setProperty("jaxb.formatted.output", (Object)true);
        SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        switch (this.xmlType) {
            case XSD15: {
                Schema schema = schemaFactory.newSchema(this.getClass().getResource("/resources/xsd/DDS_Schema_V1_5.xsd"));
                m.setSchema(schema);
                JAXBElement root = new JAXBElement(new QName("http://www.sozvers.at/ns/if/dds/draft/1/5/DDS_Schema_V1_5.xsd", "DatendrehscheibePaket"), DatendrehscheibePaketType.class, (Object)this.ddsPaket);
                m.marshal((Object)root, out);
                break;
            }
            case XSD14: {
                Schema schema = schemaFactory.newSchema(this.getClass().getResource("/resources/xsd/DDS_Schema_V1_4.xsd"));
                m.setSchema(schema);
                JAXBElement root14 = new JAXBElement(new QName("http://www.sozvers.at/ns/if/dds/draft/1/4/DDS_Schema_V1_4.xsd", "DatendrehscheibePaket"), at.itsv.dvs.model.xsd14.DatendrehscheibePaketType.class, (Object)this.ddsPaket14);
                m.marshal((Object)root14, out);
            }
        }
    }

    protected long writeBestand(OutputStream out, DVSBestand b) throws IOException {
        try (InputStream in = b.getDataLocation().getInputStream();){
            long written;
            DVSDataLocation dl = b.getDataLocation();
            if (b instanceof DVSBestandSART && ((DVSBestandSART)b).getOffSetEnd() > 0L && dl instanceof FileDataLocation) {
                ((FileDataLocation)dl).setOffSetStart(((DVSBestandSART)b).getOffSetStart());
                ((FileDataLocation)dl).setOffSetEnd(((DVSBestandSART)b).getOffSetEnd());
            }
            long l = written = IOUtils.copy((InputStream)in, (OutputStream)out);
            return l;
        }
    }

    protected void createXMLMessage() throws IOException, JAXBException, SAXException {
        switch (this.compressionType) {
            case GZIP: {
                ByteArrayOutputStream bout = new ByteArrayOutputStream();
                this.marshallXML(bout);
                long size = bout.size();
                this.addZIPEntry(DVSUtils.getDefaultXMLPaketFilename(this.VSTR), size);
                IOUtils.copy((InputStream)new ByteArrayInputStream(bout.toByteArray()), (OutputStream)this.curOutput);
                break;
            }
            default: {
                this.addZIPEntry(DVSUtils.getDefaultXMLPaketFilename(this.VSTR), -1L);
                this.marshallXML(this.curOutput);
            }
        }
    }

    protected OutputStream getZIPOutputStream(String fName) throws IOException {
        switch (this.compressionType) {
            case GZIP: {
                try {
                    return (TarArchiveOutputStream)new ArchiveStreamFactory().createArchiveOutputStream("tar", (OutputStream)new GZIPOutputStream(new FileOutputStream(fName)));
                }
                catch (ArchiveException ex) {
                    throw new IOException(ex);
                }
            }
        }
        return new ZipOutputStream(new FileOutputStream(fName));
    }

    protected void addZIPEntry(String entryName, long length) throws IOException {
        switch (this.compressionType) {
            case ZIP: {
                ((ZipOutputStream)this.curOutput).putNextEntry(new ZipEntry(entryName));
                break;
            }
            case GZIP: {
                TarArchiveEntry entry = new TarArchiveEntry(entryName);
                entry.setSize(length);
                ((TarArchiveOutputStream)this.curOutput).putArchiveEntry((ArchiveEntry)entry);
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
    }

    protected void closeZIPOutputStream() throws IOException {
        this.curOutput.flush();
        switch (this.compressionType) {
            case GZIP: {
                ((TarArchiveOutputStream)this.curOutput).closeArchiveEntry();
                break;
            }
        }
        this.curOutput.close();
    }

    public DVSConstants.XMLType getXmlType() {
        return this.xmlType;
    }

    public void setXmlType(DVSConstants.XMLType xmlType) {
        this.xmlType = xmlType;
    }
}

