/*
 * Decompiled with CFR 0.152.
 */
package at.itsv.dvs.io;

import at.itsv.dvs.io.AbstractImporter;
import at.itsv.dvs.io.DVSImportException;
import at.itsv.dvs.io.FileProvider;
import at.itsv.dvs.io.ImportListener;
import at.itsv.dvs.io.ZipEntryDataLocation;
import at.itsv.dvs.model.DVSModel;
import at.itsv.dvs.model.InvalidDataException;
import at.itsv.dvs.parser.XMLParser;
import at.itsv.dvs.util.DVSConstants;
import at.itsv.dvs.util.DVSUtils;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import javax.xml.bind.JAXBException;
import org.xml.sax.SAXException;

public class XMLPAKImporter
extends AbstractImporter {
    private DVSConstants.XMLType xmlType = DVSConstants.XMLType.XSD15;
    private String VSTR = DVSUtils.getVSTRFromProperty();

    public XMLPAKImporter(String path) {
        this(path, "UTF-8");
    }

    public XMLPAKImporter(String path, String charset) {
        this(Paths.get(path, new String[0]), charset);
    }

    public XMLPAKImporter(Path path) {
        this(path, "UTF-8");
    }

    public XMLPAKImporter(Path path, String charset) {
        this.path = path;
        this.charset = charset;
    }

    @Override
    public DVSModel doImport() throws DVSImportException {
        try {
            DVSModel dvsModel = super.doImport();
            List<Path> paths = FileProvider.provideFiles(this.path, this.pattern);
            XMLParser parser = new XMLParser(this.xmlType);
            parser.setRetainData(this.retainData);
            if (this.importListener != null) {
                parser.setImportListener(this.importListener);
            }
            int i = 0;
            int size = paths.size();
            for (Path curPath : paths) {
                for (ImportListener listener : this.getImportListener()) {
                    listener.importFile(curPath.toString(), ++i, size);
                }
                String fileVSTR = DVSUtils.getVSTRFromPath(curPath);
                if (fileVSTR == null || fileVSTR == "") {
                    if (this.VSTR != null && this.VSTR.length() > 0) {
                        fileVSTR = this.VSTR;
                    } else {
                        throw new IllegalArgumentException("Illegal value for VSTR specified.");
                    }
                }
                ZipEntryDataLocation loc = new ZipEntryDataLocation(curPath, DVSUtils.getDefaultXMLPaketFilename(fileVSTR));
                dvsModel = parser.parse(loc, dvsModel, this.getCharset());
            }
            return dvsModel;
        }
        catch (InvalidDataException | IOException | JAXBException | SAXException ex) {
            throw new DVSImportException(ex);
        }
    }

    public DVSConstants.XMLType getXmlType() {
        return this.xmlType;
    }

    public void setXmlType(DVSConstants.XMLType xmlType) {
        this.xmlType = xmlType;
    }

    public String getVSTR() {
        return this.VSTR;
    }

    public void setVSTR(String vSTR) {
        this.VSTR = vSTR;
    }
}

