/*
 * Decompiled with CFR 0.152.
 */
package at.itsv.dvs.io;

import at.itsv.dvs.io.FileDataLocation;
import at.itsv.dvs.util.DVSUtils;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.zip.GZIPInputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.commons.compress.archivers.ArchiveException;
import org.apache.commons.compress.archivers.ArchiveStreamFactory;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;

public class ZipEntryDataLocation
extends FileDataLocation {
    private CompressedFileEntry cFileEntry;
    private String zipEntryName;

    public ZipEntryDataLocation(String zipFile, String zipEntryName) throws IOException {
        this(Paths.get(zipFile, new String[0]), zipEntryName);
    }

    public ZipEntryDataLocation(Path zipPath, String zipEntryName) throws IOException {
        super(zipPath);
        switch (this.compressionType) {
            case ZIP: {
                this.cFileEntry = new ZIPFileEntry(zipPath, zipEntryName);
                break;
            }
            case GZIP: {
                this.cFileEntry = new GZIPTARFileEntry(zipPath, zipEntryName);
                break;
            }
            default: {
                throw new IOException(DVSUtils.getMessage("error.invalid.zipfile", zipPath));
            }
        }
        this.zipEntryName = zipEntryName;
    }

    @Override
    public String getLocationInfo() {
        return super.getLocationInfo() + "!" + this.zipEntryName;
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return this.cFileEntry.getInputStream();
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        throw new IOException(DVSUtils.getMessage("error.zipfile.readonly", new Object[0]));
    }

    @Override
    public long getSize() throws IOException {
        return this.cFileEntry.getSize();
    }

    public String getZipFileName() {
        return super.getLocationInfo();
    }

    public String getZipEntryName() {
        return this.zipEntryName;
    }

    public static class GZIPTARFileEntry
    implements CompressedFileEntry {
        private Path zipPath;
        private String zipEntryName;

        protected GZIPTARFileEntry(Path zipPath, String zipEntryName) throws IOException {
            this.zipPath = zipPath;
            this.zipEntryName = zipEntryName;
        }

        @Override
        public InputStream getInputStream() throws IOException {
            TarArchiveInputStream tarInputStream = this.getTarArchiveInputStream();
            if (this.findTarArchiveEntry(tarInputStream, this.zipEntryName) != null) {
                return tarInputStream;
            }
            throw new IOException("[" + this.zipEntryName + "] not found in " + this.zipPath.toString());
        }

        @Override
        public long getSize() throws IOException {
            try {
                TarArchiveEntry entry = this.getTarArchiveEntry(this.zipEntryName);
                return entry.getSize();
            }
            catch (ArchiveException ex) {
                throw new IOException(ex);
            }
        }

        protected TarArchiveInputStream getTarArchiveInputStream() throws IOException {
            try {
                return (TarArchiveInputStream)new ArchiveStreamFactory().createArchiveInputStream("tar", (InputStream)new GZIPInputStream(new FileInputStream(this.zipPath.toFile())));
            }
            catch (ArchiveException ex) {
                throw new IOException(ex);
            }
        }

        protected TarArchiveEntry getTarArchiveEntry(String zipEntryName) throws ArchiveException, IOException {
            TarArchiveInputStream tarInputStream = this.getTarArchiveInputStream();
            TarArchiveEntry entry = this.findTarArchiveEntry(tarInputStream, zipEntryName);
            if (entry != null) {
                return entry;
            }
            throw new IOException("[" + zipEntryName + "] not found in " + this.zipPath.toString());
        }

        protected TarArchiveEntry findTarArchiveEntry(TarArchiveInputStream tarInputStream, String zipEntryName) throws IOException {
            TarArchiveEntry entry = null;
            while ((entry = (TarArchiveEntry)tarInputStream.getNextEntry()) != null && !entry.getName().equals(zipEntryName)) {
            }
            return entry;
        }
    }

    public static class ZIPFileEntry
    implements CompressedFileEntry {
        private Path zipPath;
        private String zipEntryName;
        private ZipFile zipFile;
        private ZipEntry zipEntry;

        protected ZIPFileEntry(Path zipPath, String zipEntryName) throws IOException {
            this.zipPath = zipPath;
            this.zipEntryName = zipEntryName;
            if (Files.exists(zipPath, new LinkOption[0])) {
                this.zipFile = new ZipFile(zipPath.toFile());
                this.zipEntry = this.zipFile.getEntry(zipEntryName);
                if (this.zipEntry == null) {
                    throw new IOException("ZIP-Entry <" + zipEntryName + "> does not exist.");
                }
            } else {
                throw new IOException("ZIP-File <" + zipPath.toString() + "> does not exist.");
            }
        }

        @Override
        public InputStream getInputStream() throws IOException {
            return this.zipFile.getInputStream(this.zipEntry);
        }

        @Override
        public long getSize() throws IOException {
            return this.zipEntry.getSize();
        }
    }

    public static interface CompressedFileEntry {
        public InputStream getInputStream() throws IOException;

        public long getSize() throws IOException;
    }
}

