/*
 * Decompiled with CFR 0.152.
 */
package at.itsv.dvs.model;

import at.itsv.dvs.io.MemoryDataLocation;
import at.itsv.dvs.model.DVSDataDescriptor;
import at.itsv.dvs.model.DVSDataLocation;
import at.itsv.dvs.model.DVSError;
import at.itsv.dvs.model.InvalidDataException;
import at.itsv.dvs.util.DVSUtils;
import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;

public class DVSBestand {
    private long ebes;
    private String zielPartnerCode = "";
    private String ursprungsPartnerCode = "";
    private String projektKennzeichen = "";
    private String listKennzeichen = "";
    private Date erstellungsDatum;
    private String aenderungsDienstNummer = "";
    private String eingabeBestandsNummer = "";
    private String eingabeArt = "";
    private String testKennzeichen = "";
    private String komprimierungsCode = "";
    private String zusaetzlOrdnungsbegriff = "";
    private String zusaetzlInfo = "";
    private String referenzNummer = "";
    private DVSDataDescriptor dd;
    private DVSDataLocation dataLocation = new MemoryDataLocation(new byte[0]);
    private DVSAbonnement abo;
    private DVSOLInfo olInfo;
    private long satzAnzahl = 0L;
    private long satzAnzahlExpected = 0L;
    private String charset = "UTF-8";
    private List<DVSError> errorList = new ArrayList<DVSError>();

    public DVSBestand(String zVST, String uVST, String pROJ, String lIST) throws InvalidDataException {
        this(zVST, uVST, new Date(), pROJ, lIST);
    }

    public DVSBestand(String zVST, String uVST, String eRDT, String pROJ, String lIST) throws ParseException, InvalidDataException {
        this(zVST, uVST, DVSUtils.getSartDateFromString(eRDT), pROJ, lIST);
    }

    public DVSBestand(String zVST, String uVST, Date eRDT, String pROJ, String lIST) throws InvalidDataException {
        this.setZielPartnerCode(zVST);
        this.setUrsprungsPartnerCode(uVST);
        this.setProjektKennzeichen(pROJ);
        this.setListKennzeichen(lIST);
        this.setErstellungsDatum(eRDT);
    }

    protected DVSBestand() {
    }

    public void clear() {
    }

    public boolean isEmpfangsBestaetigung() {
        return false;
    }

    public long getSize() throws IOException {
        return this.dataLocation.getSize();
    }

    public void addError(DVSError error) {
        this.errorList.add(error);
    }

    public List<DVSError> getErrorList() {
        return Collections.unmodifiableList(this.errorList);
    }

    public boolean isErroneous() {
        return !this.getErrorList().isEmpty();
    }

    public long getEBES() {
        return this.ebes;
    }

    public void setEBES(long ebes) {
        this.ebes = ebes;
    }

    public String getZielPartnerCode() {
        return this.zielPartnerCode;
    }

    protected void setZielPartnerCode(String zielPartnerCode) throws InvalidDataException {
        if (!DVSUtils.isValidLengthValue(zielPartnerCode, 2, true)) {
            throw new InvalidDataException("Ungueltiger ZielPartnerCode [" + zielPartnerCode + "] angegeben. Maximallaenge=2");
        }
        this.zielPartnerCode = zielPartnerCode.toUpperCase();
    }

    public String getUrsprungsPartnerCode() {
        return this.ursprungsPartnerCode;
    }

    protected void setUrsprungsPartnerCode(String ursprungsPartnerCode) throws InvalidDataException {
        if (!DVSUtils.isValidLengthValue(ursprungsPartnerCode, 2, true)) {
            throw new InvalidDataException("Ungueltiger UrsprungsPartnerCode [" + ursprungsPartnerCode + "] angegeben. Maximallaenge=2");
        }
        this.ursprungsPartnerCode = ursprungsPartnerCode.toUpperCase();
    }

    public String getProjektKennzeichen() {
        return this.projektKennzeichen;
    }

    protected void setProjektKennzeichen(String projektKennzeichen) throws InvalidDataException {
        if (!DVSUtils.isValidLengthValue(projektKennzeichen, 2, true)) {
            throw new InvalidDataException("Ungueltiges ProjektKennzeichen [" + projektKennzeichen + "] angegeben. Maximallaenge=2");
        }
        this.projektKennzeichen = projektKennzeichen.toUpperCase();
    }

    public String getListKennzeichen() {
        return this.listKennzeichen;
    }

    protected void setListKennzeichen(String listKennzeichen) throws InvalidDataException {
        if (!DVSUtils.isValidLengthValue(listKennzeichen, 2, true)) {
            throw new InvalidDataException("Ungueltiges ListKennzeichen [" + listKennzeichen + "] angegeben. Maximallaenge=2");
        }
        this.listKennzeichen = listKennzeichen.toUpperCase();
    }

    public Date getErstellungsDatum() {
        return this.erstellungsDatum;
    }

    protected void setErstellungsDatum(Date erstellungsDatum) {
        this.erstellungsDatum = erstellungsDatum;
    }

    public String getAenderungsDienstNummer() {
        return this.aenderungsDienstNummer;
    }

    public void setAenderungsDienstNummer(String aenderungsDienstNummer) throws InvalidDataException {
        if (!DVSUtils.isValidLengthValue(aenderungsDienstNummer, 4)) {
            throw new InvalidDataException("Ungueltige AenderungsDienstNummer [" + aenderungsDienstNummer + "] angegeben. Maximallaenge=4");
        }
        this.aenderungsDienstNummer = aenderungsDienstNummer;
    }

    public String getEingabeBestandsNummer() {
        return this.eingabeBestandsNummer;
    }

    public void setEingabeBestandsNummer(String eingabeBestandsNummer) throws InvalidDataException {
        if (!DVSUtils.isValidLengthValue(eingabeBestandsNummer, 2)) {
            throw new InvalidDataException("Ungueltige EingabeBestandsNummer [" + eingabeBestandsNummer + "] angegeben. Maximallaenge=2");
        }
        this.eingabeBestandsNummer = eingabeBestandsNummer;
    }

    public String getEingabeArt() {
        return this.eingabeArt;
    }

    public void setEingabeArt(String eingabeArt) throws InvalidDataException {
        if (!DVSUtils.isValidLengthValue(eingabeArt, 2)) {
            throw new InvalidDataException("Ungueltige EingabeArt [" + eingabeArt + "] angegeben. Maximallaenge=2");
        }
        this.eingabeArt = eingabeArt;
    }

    public String getTestKennzeichen() {
        return this.testKennzeichen;
    }

    public void setTestKennzeichen(String testKennzeichen) throws InvalidDataException {
        if (!DVSUtils.isValidLengthValue(testKennzeichen, 1)) {
            throw new InvalidDataException("Ungueltiges TestKennzeichen [" + testKennzeichen + "] angegeben. Maximallaenge=1");
        }
        if (!((testKennzeichen = testKennzeichen.equals("") ? " " : testKennzeichen.toUpperCase()).equals("T") || testKennzeichen.equals(" ") || DVSUtils.isLenientErrorHandling())) {
            throw new InvalidDataException("Ungueltiges TestKennzeichen [" + testKennzeichen + "] angegeben. Unzulaessiger Wert: " + testKennzeichen);
        }
        this.testKennzeichen = testKennzeichen;
    }

    public String getKomprimierungsCode() {
        return this.komprimierungsCode;
    }

    public void setKomprimierungsCode(String komprimierungsCode) throws InvalidDataException {
        if (!DVSUtils.isValidLengthValue(komprimierungsCode, 1)) {
            throw new InvalidDataException("Ungueltiger KomprimierungsCode [" + komprimierungsCode + "] angegeben. Maximallaenge=1");
        }
        this.komprimierungsCode = komprimierungsCode;
    }

    public String getZusaetzlOrdnungsbegriff() {
        return this.zusaetzlOrdnungsbegriff;
    }

    public void setZusaetzlOrdnungsbegriff(String zusaetzlOrdnungsbegriff) throws InvalidDataException {
        if (!DVSUtils.isValidLengthValue(zusaetzlOrdnungsbegriff, 20)) {
            throw new InvalidDataException("Ungueltiger ZusaetzlOrdnungsbegriff [" + zusaetzlOrdnungsbegriff + "] angegeben. Maximallaenge=20");
        }
        this.zusaetzlOrdnungsbegriff = zusaetzlOrdnungsbegriff;
    }

    public String getZusaetzlInfo() {
        return this.zusaetzlInfo;
    }

    public void setZusaetzlInfo(String zusaetzlInfo) throws InvalidDataException {
        if (!DVSUtils.isValidLengthValue(zusaetzlInfo, 60)) {
            throw new InvalidDataException("Ungueltige ZusaetzlInfo [" + zusaetzlInfo + "] angegeben. Maximallaenge=60");
        }
        this.zusaetzlInfo = zusaetzlInfo;
    }

    public String getReferenzNummer() {
        return this.referenzNummer;
    }

    public void setReferenzNummer(String referenzNummer) throws InvalidDataException {
        if (!DVSUtils.isValidLengthValue(referenzNummer, 12)) {
            throw new InvalidDataException("Ungueltige ReferenzNummer [" + referenzNummer + "] angegeben. Maximallaenge=12");
        }
        this.referenzNummer = referenzNummer;
    }

    public DVSDataDescriptor getDataDescriptor() {
        if (this.dd == null) {
            this.dd = new DVSDataDescriptor();
        }
        return this.dd;
    }

    public void setDataDescriptor(DVSDataDescriptor dd) {
        this.dd = dd;
    }

    public DVSDataLocation getDataLocation() {
        return this.dataLocation;
    }

    public void setDataLocation(DVSDataLocation location) {
        this.dataLocation = location;
    }

    public DVSAbonnement getAbonnement() {
        return this.abo;
    }

    public void setAbonnement(DVSAbonnement abo) {
        this.abo = abo;
    }

    public DVSOLInfo getOlInfo() {
        return this.olInfo;
    }

    public void setOlInfo(DVSOLInfo olInfo) {
        this.olInfo = olInfo;
    }

    public long getSatzAnzahl() {
        return this.satzAnzahl;
    }

    protected void incrementSatzAnzahl() {
        ++this.satzAnzahl;
    }

    public void setSatzAnzahl(long satzAnzahl) {
        this.satzAnzahl = satzAnzahl;
    }

    public long getSatzAnzahlExpected() {
        return this.satzAnzahlExpected;
    }

    protected void setSatzAnzahlExpected(long satzAnzahlExpected) {
        this.satzAnzahlExpected = satzAnzahlExpected;
    }

    public String getCharset() {
        return this.charset;
    }

    public void setCharset(String charset) {
        this.charset = charset;
    }

    public static class DVSOLInfo {
        private String partnerCode = "";
        private String hint1 = "";
        private String hint2 = "";

        public DVSOLInfo(String partnerCode, String hint1, String hint2) throws InvalidDataException {
            if (!DVSUtils.isValidLengthValue(partnerCode, 2, true)) {
                throw new InvalidDataException("Ungueltiger PartnerCode [" + partnerCode + "] angegeben. Maximallaenge=2");
            }
            if (!DVSUtils.isValidLengthValue(hint1, 60)) {
                throw new InvalidDataException("Ungueltiger Hint1 [" + hint1 + "] angegeben. Maximallaenge=60");
            }
            if (!DVSUtils.isValidLengthValue(hint2, 60)) {
                throw new InvalidDataException("Ungueltiger Hint2 [" + hint2 + "] angegeben. Maximallaenge=60");
            }
            this.partnerCode = partnerCode;
            this.hint1 = hint1;
            this.hint2 = hint2;
        }

        public String getPartnerCode() {
            return this.partnerCode;
        }

        public String getHint1() {
            return this.hint1;
        }

        public String getHint2() {
            return this.hint2;
        }
    }

    public static class DVSAbonnement {
        private String abo = "";
        private String aboKey = "";

        public DVSAbonnement(String abo, String aboKey) throws InvalidDataException {
            if (!DVSUtils.isValidLengthValue(abo, 1, true)) {
                throw new InvalidDataException("Ungueltiges Abo [" + abo + "] angegeben. Maximallaenge=1");
            }
            if (!DVSUtils.isValidLengthValue(aboKey, 60)) {
                throw new InvalidDataException("Ungueltiger AboKey [" + aboKey + "]  angegeben. Maximallaenge=60");
            }
            this.abo = abo;
            this.aboKey = aboKey;
        }

        public String getAbo() {
            return this.abo;
        }

        public String getAboKey() {
            return this.aboKey;
        }
    }
}

