/*
 * Decompiled with CFR 0.152.
 */
package at.itsv.dvs.model;

import at.itsv.dvs.io.FileDataLocation;
import at.itsv.dvs.model.DVSBestand;
import at.itsv.dvs.model.DVSEmpfangsBestaetigungSART;
import at.itsv.dvs.model.DVSError;
import at.itsv.dvs.model.InvalidDataException;
import at.itsv.dvs.parser.DVSParseException;
import at.itsv.dvs.parser.LineHandler;
import at.itsv.dvs.parser.LineReader;
import at.itsv.dvs.util.DVSConstants;
import at.itsv.dvs.util.DVSUtils;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;

public class DVSBestandSART
extends DVSBestand {
    private boolean complete = false;
    private String vorSatz;
    private String nachSatz;
    private long vorSatzLineNo;
    private long nachSatzLineNo;
    private Writer writer = null;
    private long lineStart = 0L;
    private long lineEnd = -1L;
    private long offSetStart = -1L;
    private long offSetEnd = -1L;
    private boolean lineFlags = true;
    private boolean useLineNumber = false;
    private List<DVSEmpfangsBestaetigungSART> ebList = null;

    public DVSBestandSART(String line, boolean useLineNumber, long lineNumber) throws InvalidDataException, ParseException {
        this.useLineNumber = useLineNumber;
        this.parseLineStart(line, lineNumber);
        this.addLine();
    }

    public DVSBestandSART(String zVST, String uVST, String pROJ, String lIST) throws InvalidDataException {
        super(zVST, uVST, pROJ, lIST);
    }

    public DVSBestandSART(String zVST, String uVST, String eRDT, String pROJ, String lIST) throws ParseException, InvalidDataException {
        super(zVST, uVST, eRDT, pROJ, lIST);
    }

    public DVSBestandSART(String zVST, String uVST, Date eRDT, String pROJ, String lIST) throws ParseException, InvalidDataException {
        super(zVST, uVST, eRDT, pROJ, lIST);
    }

    @Override
    public void clear() {
        if (this.ebList != null) {
            this.ebList.clear();
        }
    }

    @Override
    public long getSize() throws IOException {
        if (this.lineEnd == -1L) {
            return super.getSize();
        }
        return this.offSetEnd - this.offSetStart;
    }

    private void parseLineStart(String line, long lineNumber) throws InvalidDataException {
        if (line == null || !line.startsWith(DVSConstants.DAORG_Satzkennzeichen.BESTAND_VORSATZ.toString())) {
            throw new InvalidDataException(DVSUtils.getMessage("error.sart.invalid.vorsatz", lineNumber, line));
        }
        String message = "";
        this.setVorSatz(line);
        this.setVorSatzLineNo(lineNumber);
        int length = line.length();
        if (length >= 3) {
            this.setZielPartnerCode(line.substring(1, 3).trim());
        } else {
            message = DVSUtils.getMessage("error.sart.invalid.vorsatz.length", lineNumber, line.length());
            if (DVSUtils.isLenientErrorHandling()) {
                this.addError(new DVSError(DVSConstants.DVS_ERROR.ZVST_ERROR, DVSConstants.DAORG_FECO.SART_BESTAND_VORSATZ, lineNumber, 1L, message));
            } else {
                throw new InvalidDataException(message);
            }
        }
        if (length >= 5) {
            this.setUrsprungsPartnerCode(line.substring(3, 5).trim());
        } else {
            message = DVSUtils.getMessage("error.sart.invalid.vorsatz.length", lineNumber, line.length());
            if (DVSUtils.isLenientErrorHandling()) {
                this.addError(new DVSError(DVSConstants.DVS_ERROR.UVST_ERROR, DVSConstants.DAORG_FECO.SART_BESTAND_VORSATZ, lineNumber, 3L, message));
            } else {
                throw new InvalidDataException(message);
            }
        }
        if (length >= 11) {
            String dateString = line.substring(5, 11).trim();
            try {
                this.setErstellungsDatum(DVSUtils.getSartDateFromString(dateString));
            }
            catch (ParseException ex) {
                message = DVSUtils.getMessage("error.sart.invalid.vorsatz.date", lineNumber, dateString);
                if (DVSUtils.isLenientErrorHandling()) {
                    this.addError(new DVSError(DVSConstants.DVS_ERROR.ERDT_ERROR, DVSConstants.DAORG_FECO.SART_PAKET_KOPFSATZ, lineNumber, 5L, message));
                }
                throw new InvalidDataException(message, ex);
            }
        } else {
            message = DVSUtils.getMessage("error.sart.invalid.vorsatz.length", lineNumber, line.length());
            if (DVSUtils.isLenientErrorHandling()) {
                this.addError(new DVSError(DVSConstants.DVS_ERROR.ERDT_ERROR, DVSConstants.DAORG_FECO.SART_BESTAND_VORSATZ, lineNumber, 5L, message));
            } else {
                throw new InvalidDataException(message);
            }
        }
        if (length >= 13) {
            this.setProjektKennzeichen(line.substring(11, 13).trim());
        } else {
            message = DVSUtils.getMessage("error.sart.invalid.vorsatz.length", lineNumber, line.length());
            if (DVSUtils.isLenientErrorHandling()) {
                this.addError(new DVSError(DVSConstants.DVS_ERROR.PROJ_ERROR, DVSConstants.DAORG_FECO.SART_BESTAND_VORSATZ, lineNumber, 11L, message));
            } else {
                throw new InvalidDataException(message);
            }
        }
        if (length >= 17) {
            this.setAenderungsDienstNummer(line.substring(13, 17).trim());
        } else {
            message = DVSUtils.getMessage("error.sart.invalid.vorsatz.length", lineNumber, line.length());
            if (DVSUtils.isLenientErrorHandling()) {
                this.addError(new DVSError(DVSConstants.DVS_ERROR.SART_GENERAL_DATA_ERROR, DVSConstants.DAORG_FECO.SART_BESTAND_VORSATZ, lineNumber, 13L, message));
            } else {
                throw new InvalidDataException(message);
            }
        }
        if (length >= 19) {
            this.setEingabeBestandsNummer(line.substring(17, 19).trim());
        } else {
            message = DVSUtils.getMessage("error.sart.invalid.vorsatz.length", lineNumber, line.length());
            if (DVSUtils.isLenientErrorHandling()) {
                this.addError(new DVSError(DVSConstants.DVS_ERROR.SART_GENERAL_DATA_ERROR, DVSConstants.DAORG_FECO.SART_BESTAND_VORSATZ, lineNumber, 17L, message));
            } else {
                throw new InvalidDataException(message);
            }
        }
        if (length >= 21) {
            this.setEingabeArt(line.substring(19, 21).trim());
        } else {
            message = DVSUtils.getMessage("error.sart.invalid.vorsatz.length", lineNumber, line.length());
            if (DVSUtils.isLenientErrorHandling()) {
                this.addError(new DVSError(DVSConstants.DVS_ERROR.SART_GENERAL_DATA_ERROR, DVSConstants.DAORG_FECO.SART_BESTAND_VORSATZ, lineNumber, 19L, message));
            } else {
                throw new InvalidDataException(message);
            }
        }
        if (length >= 23) {
            this.setListKennzeichen(line.substring(21, 23).trim());
        } else {
            message = DVSUtils.getMessage("error.sart.invalid.vorsatz.length", lineNumber, line.length());
            if (DVSUtils.isLenientErrorHandling()) {
                this.addError(new DVSError(DVSConstants.DVS_ERROR.SART_GENERAL_DATA_ERROR, DVSConstants.DAORG_FECO.SART_BESTAND_VORSATZ, lineNumber, 19L, message));
            } else {
                throw new InvalidDataException(message);
            }
        }
        if (length >= 24) {
            this.setTestKennzeichen(line.substring(23, 24).trim());
        }
        if (length >= 25) {
            this.setKomprimierungsCode(line.substring(24, 25).trim());
        }
        if (length >= 45) {
            this.setZusaetzlOrdnungsbegriff(line.substring(25, 45).trim());
        }
        if (this.useLineNumber) {
            this.lineStart = lineNumber + 1L;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void parseLineEnd(String line, long lineNumber) throws InvalidDataException {
        if (line == null || !line.startsWith(DVSConstants.DAORG_Satzkennzeichen.BESTAND_NACHSATZ.toString())) {
            throw new InvalidDataException(DVSUtils.getMessage("error.sart.invalid.nachsatz", lineNumber, line));
        }
        String message = "";
        this.setNachSatz(line);
        this.setNachSatzLineNo(lineNumber);
        int length = line.length();
        if (length >= 3) {
            String zvst = line.substring(1, 3).trim();
            message = DVSUtils.getMessage("error.sart.invalid.nachsatz.zvst", lineNumber, zvst, this.getZielPartnerCode(), this.getVorSatzLineNo());
            if (!this.getZielPartnerCode().equals(zvst)) {
                if (!DVSUtils.isLenientErrorHandling()) throw new InvalidDataException(message);
                this.addError(new DVSError(DVSConstants.DVS_ERROR.ZVST_ERROR, DVSConstants.DAORG_FECO.SART_BESTAND_NACHSATZ, lineNumber, 1L, message));
            }
        } else {
            message = DVSUtils.getMessage("error.sart.invalid.nachsatz.length", lineNumber, line.length());
            if (!DVSUtils.isLenientErrorHandling()) throw new InvalidDataException(message);
            this.addError(new DVSError(DVSConstants.DVS_ERROR.ZVST_ERROR, DVSConstants.DAORG_FECO.SART_BESTAND_NACHSATZ, lineNumber, 1L, message));
        }
        if (length >= 5) {
            String uvst = line.substring(3, 5).trim();
            message = DVSUtils.getMessage("error.sart.invalid.nachsatz.uvst", lineNumber, uvst, this.getUrsprungsPartnerCode(), this.getVorSatzLineNo());
            if (!this.getUrsprungsPartnerCode().equals(uvst)) {
                if (!DVSUtils.isLenientErrorHandling()) throw new InvalidDataException(message);
                this.addError(new DVSError(DVSConstants.DVS_ERROR.UVST_ERROR, DVSConstants.DAORG_FECO.SART_BESTAND_NACHSATZ, lineNumber, 3L, message));
            }
        } else {
            message = DVSUtils.getMessage("error.sart.invalid.nachsatz.length", lineNumber, line.length());
            if (!DVSUtils.isLenientErrorHandling()) throw new InvalidDataException(message);
            this.addError(new DVSError(DVSConstants.DVS_ERROR.UVST_ERROR, DVSConstants.DAORG_FECO.SART_BESTAND_NACHSATZ, lineNumber, 3L, message));
        }
        if (length >= 13) {
            long sanz = -1L;
            try {
                sanz = Long.parseLong(line.substring(5, 13).trim());
            }
            catch (NumberFormatException ex) {
                // empty catch block
            }
            this.setSatzAnzahlExpected(sanz);
            if (sanz == -1L || sanz != this.getSatzAnzahl()) {
                message = DVSUtils.getMessage("error.sart.invalid.nachsatz.sanz", lineNumber, sanz, this.getSatzAnzahl());
                if (!DVSUtils.isLenientErrorHandling()) throw new InvalidDataException(message);
                this.addError(new DVSError(DVSConstants.DVS_ERROR.SANZ_ERROR, DVSConstants.DAORG_FECO.SART_BESTAND_NACHSATZ, lineNumber, 5L, message));
            }
        } else {
            message = DVSUtils.getMessage("error.sart.invalid.nachsatz.length", lineNumber, line.length());
            if (!DVSUtils.isLenientErrorHandling()) throw new InvalidDataException(message);
            this.addError(new DVSError(DVSConstants.DVS_ERROR.SANZ_ERROR, DVSConstants.DAORG_FECO.SART_BESTAND_NACHSATZ, lineNumber, 5L, message));
        }
        if (!this.useLineNumber) return;
        this.lineEnd = lineNumber - 1L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finish(String line, long lineNumber, long byteOffset) throws InvalidDataException {
        try {
            this.offSetEnd = byteOffset;
            if (line != null) {
                this.addLine();
                this.parseLineEnd(line, lineNumber);
            }
        }
        finally {
            this.close();
        }
    }

    public void close() {
        try {
            this.complete = true;
            if (this.writer != null) {
                this.writer.flush();
                this.writer.close();
                this.writer = null;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void addLine() {
        this.incrementSatzAnzahl();
    }

    public long countLines() throws IOException, DVSParseException {
        new LineReader(this.getDataLocation().getInputStream(), new LineHandler(){

            @Override
            public boolean handleLine(String line, long lineNumber, long byteOffset) throws DVSParseException {
                DVSBestandSART.this.addLine();
                return true;
            }
        }).start();
        return this.getSatzAnzahl();
    }

    public void dumpLine(String line) throws IOException {
        if (this.writer == null) {
            File f = DVSUtils.createDVSTempFile();
            this.setDataLocation(new FileDataLocation(f.toPath()));
            this.writer = new OutputStreamWriter((OutputStream)new BufferedOutputStream(this.getDataLocation().getOutputStream()), this.getCharset());
        }
        this.writer.write(line + "\n");
    }

    @Override
    public boolean isEmpfangsBestaetigung() {
        return "EB".equals(this.getListKennzeichen());
    }

    public List<DVSEmpfangsBestaetigungSART> getEBList() throws IOException, DVSParseException {
        if (!this.isEmpfangsBestaetigung()) {
            return null;
        }
        if (this.ebList == null) {
            this.ebList = new ArrayList<DVSEmpfangsBestaetigungSART>();
        }
        if (this.ebList.isEmpty()) {
            this.loadEBList();
        }
        return Collections.unmodifiableList(this.ebList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadEBList() throws IOException, DVSParseException {
        try (LineReader lr = new LineReader(this.getDataLocation().getInputStream(), this.getCharset(), new LineHandler(){

            @Override
            public boolean handleLine(String line, long lineNumber, long byteOffset) throws DVSParseException {
                DVSEmpfangsBestaetigungSART ebSART = new DVSEmpfangsBestaetigungSART(line, lineNumber);
                DVSBestandSART.this.addEmpfangsBestaetigung(ebSART);
                return true;
            }
        });){
            lr.start();
        }
    }

    public void addEmpfangsBestaetigung(DVSEmpfangsBestaetigungSART eb) {
        if (this.ebList == null) {
            this.ebList = new ArrayList<DVSEmpfangsBestaetigungSART>();
        }
        this.ebList.add(eb);
    }

    public boolean isComplete() {
        return this.complete;
    }

    public String getVorSatz() {
        return this.vorSatz;
    }

    protected void setVorSatz(String vorSatz) {
        this.vorSatz = vorSatz;
    }

    public String getNachSatz() {
        return this.nachSatz;
    }

    protected void setNachSatz(String nachSatz) {
        this.nachSatz = nachSatz;
    }

    public long getVorSatzLineNo() {
        return this.vorSatzLineNo;
    }

    protected void setVorSatzLineNo(long vorSatzLineNo) {
        this.vorSatzLineNo = vorSatzLineNo;
    }

    public long getNachSatzLineNo() {
        return this.nachSatzLineNo;
    }

    protected void setNachSatzLineNo(long nachSatzLineNo) {
        this.nachSatzLineNo = nachSatzLineNo;
    }

    public long getLineStart() {
        return this.useLineNumber ? this.lineStart : 0L;
    }

    public void setLineStart(long lineStart) {
        this.lineStart = lineStart;
    }

    public long getLineEnd() {
        return this.useLineNumber ? this.lineEnd : -1L;
    }

    public void setLineEnd(long lineEnd) {
        this.lineEnd = lineEnd;
    }

    public boolean hasLineFlags() {
        return this.lineFlags;
    }

    public void setLineFlags(boolean lineFlags) {
        this.lineFlags = lineFlags;
    }

    public long getOffSetStart() {
        return this.offSetStart;
    }

    public void setOffSetStart(long offSetStart) {
        this.offSetStart = offSetStart;
    }

    public long getOffSetEnd() {
        return this.offSetEnd;
    }

    public void setOffSetEnd(long offSetEnd) {
        this.offSetEnd = offSetEnd;
    }
}

