/*
 * Decompiled with CFR 0.152.
 */
package at.itsv.dvs.model;

import at.itsv.dvs.model.DVSBestand;
import at.itsv.dvs.model.DVSEmpfangsBestaetigungXML;
import at.itsv.dvs.model.InvalidDataException;
import at.itsv.dvs.model.xsd15.AboInfoType;
import at.itsv.dvs.model.xsd15.BestandKomprimiertType;
import at.itsv.dvs.model.xsd15.BestandSigniertType;
import at.itsv.dvs.model.xsd15.BestandType;
import at.itsv.dvs.model.xsd15.BestandVerschluesseltType;
import at.itsv.dvs.model.xsd15.BestandsInfoType;
import at.itsv.dvs.model.xsd15.DDSOLInfoType;
import at.itsv.dvs.model.xsd15.FileInfoType;
import at.itsv.dvs.util.DVSUtils;
import java.text.ParseException;
import java.util.Date;
import java.util.Objects;

public class DVSBestandXML
extends DVSBestand {
    private DVSEmpfangsBestaetigungXML eb;

    public DVSBestandXML(BestandType bestandType) throws InvalidDataException {
        Objects.requireNonNull(bestandType, "bestandType must not be null");
        this.initBestand(bestandType.getBestandsInfo());
        this.initBestand(bestandType.getFileInfo());
        this.initBestand(bestandType.getAboInfo());
        this.initBestand(bestandType.getDDSOLInfo());
    }

    public DVSBestandXML(String zVST, String uVST, String pROJ, String lIST) throws InvalidDataException {
        super(zVST, uVST, pROJ, lIST);
    }

    public DVSBestandXML(String zVST, String uVST, String eRDT, String pROJ, String lIST) throws ParseException, InvalidDataException {
        super(zVST, uVST, eRDT, pROJ, lIST);
    }

    public DVSBestandXML(String zVST, String uVST, Date eRDT, String pROJ, String lIST) throws InvalidDataException {
        super(zVST, uVST, eRDT, pROJ, lIST);
    }

    @Override
    public void clear() {
        this.eb = null;
    }

    private void initBestand(BestandsInfoType bi) throws InvalidDataException {
        Objects.requireNonNull(bi, "bi must not be null");
        this.setZielPartnerCode(bi.getZielpartnerCode());
        this.setUrsprungsPartnerCode(bi.getUrsprungspartnerCode());
        this.setProjektKennzeichen(bi.getProjektKennzeichen());
        this.setListKennzeichen(bi.getListKennzeichen());
        if (bi.getErstellungsdatum() != null) {
            this.setErstellungsDatum(DVSUtils.xmlGregorianCalendar2Date(bi.getErstellungsdatum()));
        }
        this.setAenderungsDienstNummer(bi.getAenderungsdienstNummer() != null ? bi.getAenderungsdienstNummer() : "");
        this.setEingabeBestandsNummer(bi.getEingabeBestandsNummer() != null ? bi.getEingabeBestandsNummer() : "");
        this.setEingabeArt(bi.getEingabeArt() != null ? bi.getEingabeArt() : "");
        this.setTestKennzeichen(bi.getTestKennzeichen() != null ? bi.getTestKennzeichen() : " ");
        this.setZusaetzlOrdnungsbegriff(bi.getZusaetzlOrdnungsbegriff() != null ? bi.getZusaetzlOrdnungsbegriff() : "");
        this.setReferenzNummer(bi.getReferenzNummer() != null ? bi.getReferenzNummer() : "");
        this.setZusaetzlInfo(bi.getZusaetzlInfo() != null ? bi.getZusaetzlInfo() : "");
    }

    private void initBestand(FileInfoType fi) throws InvalidDataException {
        if (fi == null) {
            return;
        }
        this.getDataDescriptor().setLink(fi.getLinkAufBestandsFile());
        this.getDataDescriptor().setContentType(fi.getInhalt());
        this.getDataDescriptor().setSigned(fi.getSigniert() == BestandSigniertType.J);
        this.getDataDescriptor().setEncrypted(fi.getVerschluesselt() == BestandVerschluesseltType.J);
        this.getDataDescriptor().setZipped(fi.getKomprimiert() == BestandKomprimiertType.J);
        this.getDataDescriptor().setHash(fi.getHashWert());
        if (fi.getSatzAnzahl() != null) {
            this.setSatzAnzahl(fi.getSatzAnzahl().longValue());
        }
    }

    private void initBestand(AboInfoType ai) throws InvalidDataException {
        if (ai == null) {
            return;
        }
        DVSBestand.DVSAbonnement abo = new DVSBestand.DVSAbonnement(ai.getAbo().toString(), ai.getAboKey());
        this.setAbonnement(abo);
    }

    private void initBestand(DDSOLInfoType di) throws InvalidDataException {
        if (di == null) {
            return;
        }
        DVSBestand.DVSOLInfo olInfo = new DVSBestand.DVSOLInfo(di.getPartnerCode(), di.getHinweis1(), di.getHinweis2());
        this.setOlInfo(olInfo);
    }

    @Override
    public boolean isEmpfangsBestaetigung() {
        return "DD".equals(this.getProjektKennzeichen()) && "EB".equals(this.getListKennzeichen());
    }

    public DVSEmpfangsBestaetigungXML getEmpfangsBestaetigung() {
        return this.eb;
    }

    public void setEmpfangsBestaetigung(DVSEmpfangsBestaetigungXML eb) {
        this.eb = eb;
    }
}

