/*
 * Decompiled with CFR 0.152.
 */
package at.itsv.dvs.model;

import at.itsv.dvs.model.InvalidDataException;
import at.itsv.dvs.util.DVSUtils;

public class DVSDataDescriptor {
    private String link = "";
    private String contentType = "";
    private boolean signed = false;
    private boolean encrypted = false;
    private boolean zipped = false;
    private String hash = "";

    protected DVSDataDescriptor() {
    }

    public String getLink() {
        return this.link;
    }

    public void setLink(String link) throws InvalidDataException {
        if (!DVSUtils.isValidLengthValue(link, 64)) {
            throw new InvalidDataException("Ungueltiger Link [" + link + "] angegeben. Maximallaenge=64");
        }
        this.link = link;
    }

    public String getContentType() {
        return this.contentType;
    }

    public void setContentType(String type) throws InvalidDataException {
        if (!DVSUtils.isValidLengthValue(type, 12)) {
            throw new InvalidDataException("Ungueltiger Inhalt [" + type + "] angegeben. Maximallaenge=12");
        }
        this.contentType = type;
    }

    public boolean isSigned() {
        return this.signed;
    }

    public void setSigned(boolean signed) {
        this.signed = signed;
    }

    public boolean isEncrypted() {
        return this.encrypted;
    }

    public void setEncrypted(boolean encrypted) {
        this.encrypted = encrypted;
    }

    public boolean isZipped() {
        return this.zipped;
    }

    public void setZipped(boolean zipped) {
        this.zipped = zipped;
    }

    public String getHash() {
        return this.hash;
    }

    public void setHash(String hash) throws InvalidDataException {
        if (!DVSUtils.isValidLengthValue(hash, 128)) {
            throw new InvalidDataException("Ungueltiger Hashwert [" + hash + "] angegeben. Maximallaenge=128");
        }
        this.hash = hash;
    }

    public Object clone() {
        DVSDataDescriptor clone = new DVSDataDescriptor();
        try {
            clone.setContentType(this.getContentType());
            clone.setEncrypted(this.isEncrypted());
            clone.setHash(this.getHash());
            clone.setLink(this.getLink());
            clone.setSigned(this.isSigned());
            clone.setZipped(this.isZipped());
        }
        catch (InvalidDataException invalidDataException) {
            // empty catch block
        }
        return clone;
    }
}

