/*
 * Decompiled with CFR 0.152.
 */
package at.itsv.dvs.model;

import at.itsv.dvs.model.DVSBestand;
import at.itsv.dvs.model.DVSError;
import at.itsv.dvs.model.DVSPaket;
import at.itsv.dvs.util.DVSConstants;
import at.itsv.dvs.util.DVSUtils;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;

public class DVSEmpfangsBestaetigungSART {
    private long satzAnzahl = 0L;
    private String feco = "000";
    private String paketZielPartnerCode;
    private String paketUrsprungsPartnerCode;
    private Date paketErstellungsDatum;
    private Date paketSendeDatum;
    private Date paketSendeZeit;
    private String paketPaketBezeichnung;
    private String zielPartnerCode;
    private String ursprungsPartnerCode;
    private String projektKennzeichen;
    private String listKennzeichen;
    private Date erstellungsDatum;
    private String aenderungsDienstNummer;
    private String eingabeBestandsNummer;
    private String eingabeArt;
    private String testKennzeichen;
    private String komprimierungsCode;
    private String zusaetzlOrdnungsbegriff;
    private String extraInfo;
    private List<DVSError> errorList = new ArrayList<DVSError>();

    public DVSEmpfangsBestaetigungSART(String line, long lineNumber) {
        this.parseLine(line, lineNumber);
    }

    public DVSEmpfangsBestaetigungSART(DVSPaket paket, DVSBestand bestand) {
        this.satzAnzahl = bestand.getSatzAnzahl();
        if (bestand.getErrorList().size() > 0) {
            this.feco = bestand.getErrorList().get(0).getFECO().toString();
            this.feco = bestand.getErrorList().size() > 1 ? this.feco + "9" : this.feco + "0";
        }
        this.paketZielPartnerCode = paket.getZielPartnerCode();
        this.paketUrsprungsPartnerCode = paket.getUrsprungsPartnerCode();
        this.paketErstellungsDatum = paket.getErstellungsDatum();
        this.paketSendeDatum = paket.getSendeDatum();
        this.paketSendeZeit = paket.getSendeZeit();
        this.paketPaketBezeichnung = paket.getPaketBezeichnung();
        this.zielPartnerCode = bestand.getZielPartnerCode();
        this.ursprungsPartnerCode = bestand.getUrsprungsPartnerCode();
        this.projektKennzeichen = bestand.getProjektKennzeichen();
        this.listKennzeichen = bestand.getListKennzeichen();
        this.erstellungsDatum = bestand.getErstellungsDatum();
        this.aenderungsDienstNummer = bestand.getAenderungsDienstNummer();
        this.eingabeBestandsNummer = bestand.getEingabeBestandsNummer();
        this.eingabeArt = bestand.getEingabeArt();
        this.testKennzeichen = bestand.getTestKennzeichen();
        this.komprimierungsCode = bestand.getKomprimierungsCode();
        this.zusaetzlOrdnungsbegriff = bestand.getZusaetzlOrdnungsbegriff();
    }

    private void parseLine(String line, long lineNumber) {
        if (line == null || !line.startsWith("EB")) {
            this.addError(new DVSError(DVSConstants.DVS_ERROR.EB_ERROR, DVSConstants.DAORG_FECO.GENERAL, lineNumber, 1L));
            return;
        }
        int length = line.length();
        if (length >= 10) {
            long sanz = -1L;
            try {
                sanz = Long.parseLong(line.substring(2, 10).trim());
            }
            catch (NumberFormatException ex) {
                // empty catch block
            }
            this.satzAnzahl = sanz;
            if (sanz == -1L) {
                this.addError(new DVSError(DVSConstants.DVS_ERROR.SANZ_ERROR, DVSConstants.DAORG_FECO.GENERAL, lineNumber, 3L));
            }
        } else {
            this.addError(new DVSError(DVSConstants.DVS_ERROR.EB_ERROR, DVSConstants.DAORG_FECO.GENERAL, lineNumber, 1L));
        }
        if (length >= 13) {
            this.feco = line.substring(10, 13).trim();
        } else {
            this.addError(new DVSError(DVSConstants.DVS_ERROR.EB_ERROR, DVSConstants.DAORG_FECO.GENERAL, lineNumber, 1L));
        }
        if (length >= 14) {
            if (!DVSConstants.DAORG_Satzkennzeichen.PAKET_KOPFSATZ.toString().equals(line.substring(13, 14).trim())) {
                this.addError(new DVSError(DVSConstants.DVS_ERROR.EB_ERROR, DVSConstants.DAORG_FECO.GENERAL, lineNumber, 14L));
            }
        } else {
            this.addError(new DVSError(DVSConstants.DVS_ERROR.EB_ERROR, DVSConstants.DAORG_FECO.GENERAL, lineNumber, 1L));
        }
        if (length >= 16) {
            this.paketZielPartnerCode = line.substring(14, 16).trim();
        } else {
            this.addError(new DVSError(DVSConstants.DVS_ERROR.EB_ERROR, DVSConstants.DAORG_FECO.GENERAL, lineNumber, 1L));
        }
        if (length >= 18) {
            this.paketUrsprungsPartnerCode = line.substring(16, 18).trim();
        } else {
            this.addError(new DVSError(DVSConstants.DVS_ERROR.EB_ERROR, DVSConstants.DAORG_FECO.GENERAL, lineNumber, 1L));
        }
        if (length >= 24) {
            try {
                this.paketErstellungsDatum = DVSUtils.getSartDateFromString(line.substring(18, 24).trim());
            }
            catch (ParseException ex) {
                this.addError(new DVSError(DVSConstants.DVS_ERROR.EB_ERROR, DVSConstants.DAORG_FECO.GENERAL, lineNumber, 19L));
            }
        } else {
            this.addError(new DVSError(DVSConstants.DVS_ERROR.EB_ERROR, DVSConstants.DAORG_FECO.GENERAL, lineNumber, 1L));
        }
        if (length >= 30) {
            try {
                String sdate = line.substring(24, 30).trim();
                if (sdate.length() > 0) {
                    this.paketSendeDatum = DVSUtils.getSartDateFromString(sdate);
                }
            }
            catch (ParseException ex) {
                this.addError(new DVSError(DVSConstants.DVS_ERROR.EB_ERROR, DVSConstants.DAORG_FECO.GENERAL, lineNumber, 25L));
            }
        } else {
            this.addError(new DVSError(DVSConstants.DVS_ERROR.EB_ERROR, DVSConstants.DAORG_FECO.GENERAL, lineNumber, 1L));
        }
        if (length >= 36) {
            try {
                String sdate = line.substring(30, 36).trim();
                if (sdate.length() > 0) {
                    this.paketSendeZeit = DVSUtils.getSartTimeFromString(sdate);
                }
            }
            catch (ParseException ex) {
                this.addError(new DVSError(DVSConstants.DVS_ERROR.EB_ERROR, DVSConstants.DAORG_FECO.GENERAL, lineNumber, 31L));
            }
        } else {
            this.addError(new DVSError(DVSConstants.DVS_ERROR.EB_ERROR, DVSConstants.DAORG_FECO.GENERAL, lineNumber, 1L));
        }
        if (length >= 61) {
            this.paketPaketBezeichnung = line.substring(41, 61).trim();
        } else {
            this.addError(new DVSError(DVSConstants.DVS_ERROR.EB_ERROR, DVSConstants.DAORG_FECO.GENERAL, lineNumber, 1L));
        }
        if (length >= 62) {
            if (!DVSConstants.DAORG_Satzkennzeichen.BESTAND_VORSATZ.toString().equals(line.substring(61, 62).trim())) {
                this.addError(new DVSError(DVSConstants.DVS_ERROR.EB_ERROR, DVSConstants.DAORG_FECO.GENERAL, lineNumber, 62L));
            }
        } else {
            this.addError(new DVSError(DVSConstants.DVS_ERROR.EB_ERROR, DVSConstants.DAORG_FECO.GENERAL, lineNumber, 1L));
        }
        if (length >= 64) {
            this.zielPartnerCode = line.substring(62, 64).trim();
        } else {
            this.addError(new DVSError(DVSConstants.DVS_ERROR.EB_ERROR, DVSConstants.DAORG_FECO.GENERAL, lineNumber, 1L));
        }
        if (length >= 66) {
            this.ursprungsPartnerCode = line.substring(64, 66).trim();
        } else {
            this.addError(new DVSError(DVSConstants.DVS_ERROR.EB_ERROR, DVSConstants.DAORG_FECO.GENERAL, lineNumber, 1L));
        }
        if (length >= 72) {
            try {
                this.erstellungsDatum = DVSUtils.getSartDateFromString(line.substring(66, 72).trim());
            }
            catch (ParseException ex) {
                this.addError(new DVSError(DVSConstants.DVS_ERROR.EB_ERROR, DVSConstants.DAORG_FECO.GENERAL, lineNumber, 67L));
            }
        } else {
            this.addError(new DVSError(DVSConstants.DVS_ERROR.EB_ERROR, DVSConstants.DAORG_FECO.GENERAL, lineNumber, 1L));
        }
        if (length >= 74) {
            this.projektKennzeichen = line.substring(72, 74).trim();
        } else {
            this.addError(new DVSError(DVSConstants.DVS_ERROR.EB_ERROR, DVSConstants.DAORG_FECO.GENERAL, lineNumber, 1L));
        }
        if (length >= 78) {
            this.aenderungsDienstNummer = line.substring(74, 78).trim();
        } else {
            this.addError(new DVSError(DVSConstants.DVS_ERROR.EB_ERROR, DVSConstants.DAORG_FECO.GENERAL, lineNumber, 1L));
        }
        if (length >= 80) {
            this.eingabeBestandsNummer = line.substring(78, 80).trim();
        } else {
            this.addError(new DVSError(DVSConstants.DVS_ERROR.EB_ERROR, DVSConstants.DAORG_FECO.GENERAL, lineNumber, 1L));
        }
        if (length >= 82) {
            this.eingabeArt = line.substring(80, 82).trim();
        } else {
            this.addError(new DVSError(DVSConstants.DVS_ERROR.EB_ERROR, DVSConstants.DAORG_FECO.GENERAL, lineNumber, 1L));
        }
        if (length >= 84) {
            this.listKennzeichen = line.substring(82, 84).trim();
        } else {
            this.addError(new DVSError(DVSConstants.DVS_ERROR.EB_ERROR, DVSConstants.DAORG_FECO.GENERAL, lineNumber, 1L));
        }
        if (length >= 85) {
            this.testKennzeichen = line.substring(84, 85).trim();
        } else {
            this.addError(new DVSError(DVSConstants.DVS_ERROR.EB_ERROR, DVSConstants.DAORG_FECO.GENERAL, lineNumber, 1L));
        }
        if (length >= 86) {
            this.komprimierungsCode = line.substring(85, 86).trim();
        } else {
            this.addError(new DVSError(DVSConstants.DVS_ERROR.EB_ERROR, DVSConstants.DAORG_FECO.GENERAL, lineNumber, 1L));
        }
        if (length >= 106) {
            this.zusaetzlOrdnungsbegriff = line.substring(86, 106).trim();
        } else {
            this.addError(new DVSError(DVSConstants.DVS_ERROR.EB_ERROR, DVSConstants.DAORG_FECO.GENERAL, lineNumber, 1L));
        }
    }

    public void addError(DVSError error) {
        this.errorList.add(error);
    }

    public boolean isErroneous() {
        return !this.getErrorList().isEmpty();
    }

    public List<DVSError> getErrorList() {
        return Collections.unmodifiableList(this.errorList);
    }

    public long getSatzAnzahl() {
        return this.satzAnzahl;
    }

    public String getFECO() {
        return this.feco;
    }

    public String getPaketZielPartnerCode() {
        return this.paketZielPartnerCode;
    }

    public String getPaketUrsprungsPartnerCode() {
        return this.paketUrsprungsPartnerCode;
    }

    public Date getPaketErstellungsDatum() {
        return this.paketErstellungsDatum;
    }

    public Date getPaketSendeDatum() {
        return this.paketSendeDatum;
    }

    public Date getPaketSendeZeit() {
        return this.paketSendeZeit;
    }

    public String getPaketPaketBezeichnung() {
        return this.paketPaketBezeichnung;
    }

    public String getZielPartnerCode() {
        return this.zielPartnerCode;
    }

    public String getUrsprungsPartnerCode() {
        return this.ursprungsPartnerCode;
    }

    public String getProjektKennzeichen() {
        return this.projektKennzeichen;
    }

    public String getListKennzeichen() {
        return this.listKennzeichen;
    }

    public Date getErstellungsDatum() {
        return this.erstellungsDatum;
    }

    public String getAenderungsDienstNummer() {
        return this.aenderungsDienstNummer;
    }

    public String getEingabeBestandsNummer() {
        return this.eingabeBestandsNummer;
    }

    public String getEingabeArt() {
        return this.eingabeArt;
    }

    public String getTestKennzeichen() {
        return this.testKennzeichen;
    }

    public String getKomprimierungsCode() {
        return this.komprimierungsCode;
    }

    public String getZusaetzlOrdnungsbegriff() {
        return this.zusaetzlOrdnungsbegriff;
    }

    public String getExtraInfo() {
        return this.extraInfo;
    }

    public void setExtraInfo(String extraInfo) {
        this.extraInfo = extraInfo;
    }
}

