/*
 * Decompiled with CFR 0.152.
 */
package at.itsv.dvs.model;

import at.itsv.dvs.model.DVSBestand;
import at.itsv.dvs.model.DVSBestandXML;
import at.itsv.dvs.model.DVSError;
import at.itsv.dvs.model.xsd14.EmpfangsbestaetigungType;
import at.itsv.dvs.model.xsd14.EmpfangsbestaetigungsListeType;
import at.itsv.dvs.model.xsd15.EmpfangsbestaetigungsFileType;
import at.itsv.dvs.model.xsd15.EmpfangsbestaetigungsKopfType;
import at.itsv.dvs.util.DVSConstants;
import at.itsv.dvs.util.DVSUtils;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.namespace.QName;

public class DVSEmpfangsBestaetigungXML {
    private String zielPartnerCode = "";
    private String ursprungsPartnerCode = "";
    private Date erstellungsTimeStamp = new Date();
    private String referenzNummer = "";
    private List<DVSEmpfangsBestaetigungXMLInfo> ebInfoList = new ArrayList<DVSEmpfangsBestaetigungXMLInfo>();

    public DVSEmpfangsBestaetigungXML(EmpfangsbestaetigungsFileType ebFileType) {
        Objects.requireNonNull(ebFileType, "ebFileType must not be null");
        EmpfangsbestaetigungsKopfType ebKopf = ebFileType.getEmpfangsbestaetigungsKopf();
        Objects.requireNonNull(ebKopf, "ebKopf must not be null");
        at.itsv.dvs.model.xsd15.EmpfangsbestaetigungsListeType ebListType = ebFileType.getEmpfangsbestaetigungsListe();
        Objects.requireNonNull(ebListType, "ebListType must not be null");
        List<at.itsv.dvs.model.xsd15.EmpfangsbestaetigungType> ebList = ebListType.getEmpfangsbestaetigung();
        Objects.requireNonNull(ebList, "ebList must not be null");
        this.zielPartnerCode = ebKopf.getZielpartnerCode();
        this.ursprungsPartnerCode = ebKopf.getUrsprungspartnerCode();
        if (ebKopf.getErstellungsTimeStamp() != null) {
            this.erstellungsTimeStamp = DVSUtils.xmlGregorianCalendar2Date(ebKopf.getErstellungsTimeStamp());
        }
        for (at.itsv.dvs.model.xsd15.EmpfangsbestaetigungType eb : ebList) {
            this.ebInfoList.add(new DVSEmpfangsBestaetigungXMLInfo(eb));
        }
    }

    DVSEmpfangsBestaetigungXML(at.itsv.dvs.model.xsd14.EmpfangsbestaetigungsFileType ebFileType) {
        Objects.requireNonNull(ebFileType, "ebFileType must not be null");
        at.itsv.dvs.model.xsd14.EmpfangsbestaetigungsKopfType ebKopf = ebFileType.getEmpfangsbestaetigungsKopf();
        Objects.requireNonNull(ebKopf, "ebKopf must not be null");
        EmpfangsbestaetigungsListeType ebListType = ebFileType.getEmpfangsbestaetigungsListe();
        Objects.requireNonNull(ebListType, "ebListType must not be null");
        List<EmpfangsbestaetigungType> ebList = ebListType.getEmpfangsbestaetigung();
        Objects.requireNonNull(ebList, "ebList must not be null");
        this.zielPartnerCode = ebKopf.getZielpartnerCode();
        this.ursprungsPartnerCode = ebKopf.getUrsprungspartnerCode();
        if (ebKopf.getErstellungsTimeStamp() != null) {
            this.erstellungsTimeStamp = DVSUtils.xmlGregorianCalendar2Date(ebKopf.getErstellungsTimeStamp());
        }
        for (EmpfangsbestaetigungType eb : ebList) {
            this.ebInfoList.add(new DVSEmpfangsBestaetigungXMLInfo(eb));
        }
    }

    DVSEmpfangsBestaetigungXML(String ZVST, String UVST, String referenzNummer) {
        this.zielPartnerCode = ZVST;
        this.ursprungsPartnerCode = UVST;
        this.erstellungsTimeStamp = new Date();
        this.referenzNummer = referenzNummer;
    }

    public void addEmpfangsBestaetigungInfos(DVSBestand bestand) {
        String ddsReferenzNummer = this.getDDSReferenzNummer(bestand);
        String partnerReferenzNummer = this.getPartnerReferenzNummer(bestand);
        for (DVSError error : bestand.getErrorList()) {
            String feco = error.getFECO().toString();
            feco = bestand.getErrorList().size() > 1 ? feco + "9" : feco + "0";
            this.ebInfoList.add(new DVSEmpfangsBestaetigungXMLInfo(feco, "", "", ddsReferenzNummer, partnerReferenzNummer));
        }
        if (this.ebInfoList.size() == 0) {
            this.ebInfoList.add(new DVSEmpfangsBestaetigungXMLInfo("000", "", "", ddsReferenzNummer, partnerReferenzNummer));
        }
    }

    protected String getDDSReferenzNummer(DVSBestand bestand) {
        if (!(bestand instanceof DVSBestandXML)) {
            return "";
        }
        if (!DVSUtils.isRunningAsDVS()) {
            return ((DVSBestandXML)bestand).getReferenzNummer();
        }
        return this.referenzNummer;
    }

    protected String getPartnerReferenzNummer(DVSBestand bestand) {
        if (!(bestand instanceof DVSBestandXML)) {
            return "";
        }
        if (DVSUtils.isRunningAsDVS()) {
            return ((DVSBestandXML)bestand).getReferenzNummer();
        }
        return "";
    }

    public String toXMLString(DVSConstants.XMLType xmlType) throws JAXBException, DatatypeConfigurationException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        switch (xmlType) {
            case XSD15: {
                this.marshalXML15(bos);
                break;
            }
            case XSD14: {
                this.marshalXML14(bos);
            }
        }
        return bos.toString();
    }

    protected void marshalXML15(OutputStream out) throws JAXBException, DatatypeConfigurationException {
        EmpfangsbestaetigungsFileType ebFileType = new EmpfangsbestaetigungsFileType();
        EmpfangsbestaetigungsKopfType ebKopfType = new EmpfangsbestaetigungsKopfType();
        ebKopfType.setZielpartnerCode(this.getZielPartnerCode());
        ebKopfType.setUrsprungspartnerCode(this.getUrsprungsPartnerCode());
        ebKopfType.setErstellungsTimeStamp(DVSUtils.date2XMLGregorianCalendar(this.getErstellungsTimeStamp()));
        DVSUtils.xmlGregorianCalendar2XSDATETIME(ebKopfType.getErstellungsTimeStamp());
        ebFileType.setEmpfangsbestaetigungsKopf(ebKopfType);
        at.itsv.dvs.model.xsd15.EmpfangsbestaetigungsListeType ebListeType = new at.itsv.dvs.model.xsd15.EmpfangsbestaetigungsListeType();
        if (this.ebInfoList.size() > 0) {
            DVSEmpfangsBestaetigungXMLInfo ebInfo = this.ebInfoList.get(0);
            at.itsv.dvs.model.xsd15.EmpfangsbestaetigungType ebType = new at.itsv.dvs.model.xsd15.EmpfangsbestaetigungType();
            ebType.setFehlerCode(ebInfo.getFeco());
            ebType.setHinweis1(ebInfo.getHint1());
            ebType.setHinweis2(ebInfo.getHint2());
            ebType.setDDSReferenzNummer(ebInfo.getDdsReferenzNummer());
            ebType.setPartnerReferenzNummer(ebInfo.getPartnerReferenzNummer());
            ebListeType.getEmpfangsbestaetigung().add(ebType);
        }
        ebFileType.setEmpfangsbestaetigungsListe(ebListeType);
        JAXBContext ctx = JAXBContext.newInstance((String)DVSConstants.XMLType.XSD15.getContext());
        Marshaller m = ctx.createMarshaller();
        m.setProperty("jaxb.formatted.output", (Object)true);
        JAXBElement root = new JAXBElement(new QName("http://www.sozvers.at/ns/if/dds/draft/1/5/DDS_Schema_V1_5.xsd", "EmpfangsbestaetigungsFile"), EmpfangsbestaetigungsFileType.class, (Object)ebFileType);
        m.marshal((Object)root, out);
    }

    protected void marshalXML14(OutputStream out) throws JAXBException, DatatypeConfigurationException {
        at.itsv.dvs.model.xsd14.EmpfangsbestaetigungsFileType ebFileType = new at.itsv.dvs.model.xsd14.EmpfangsbestaetigungsFileType();
        at.itsv.dvs.model.xsd14.EmpfangsbestaetigungsKopfType ebKopfType = new at.itsv.dvs.model.xsd14.EmpfangsbestaetigungsKopfType();
        ebKopfType.setZielpartnerCode(this.getZielPartnerCode());
        ebKopfType.setUrsprungspartnerCode(this.getUrsprungsPartnerCode());
        ebKopfType.setErstellungsTimeStamp(DVSUtils.date2XMLGregorianCalendar(this.getErstellungsTimeStamp()));
        DVSUtils.xmlGregorianCalendar2XSDATETIME(ebKopfType.getErstellungsTimeStamp());
        ebFileType.setEmpfangsbestaetigungsKopf(ebKopfType);
        EmpfangsbestaetigungsListeType ebListeType = new EmpfangsbestaetigungsListeType();
        if (this.ebInfoList.size() > 0) {
            DVSEmpfangsBestaetigungXMLInfo ebInfo = this.ebInfoList.get(0);
            EmpfangsbestaetigungType ebType = new EmpfangsbestaetigungType();
            ebType.setFehlerCode(ebInfo.getFeco());
            ebType.setHinweis1(ebInfo.getHint1());
            ebType.setHinweis2(ebInfo.getHint2());
            ebType.setDDSReferenzNummer(ebInfo.getDdsReferenzNummer());
            ebType.setPartnerReferenzNummer(ebInfo.getPartnerReferenzNummer());
            ebListeType.getEmpfangsbestaetigung().add(ebType);
        }
        ebFileType.setEmpfangsbestaetigungsListe(ebListeType);
        JAXBContext ctx = JAXBContext.newInstance((String)DVSConstants.XMLType.XSD14.getContext());
        Marshaller m = ctx.createMarshaller();
        m.setProperty("jaxb.formatted.output", (Object)true);
        JAXBElement root14 = new JAXBElement(new QName("http://www.sozvers.at/ns/if/dds/draft/1/4/DDS_Schema_V1_4.xsd", "EmpfangsbestaetigungsFile"), at.itsv.dvs.model.xsd14.EmpfangsbestaetigungsFileType.class, (Object)ebFileType);
        m.marshal((Object)root14, out);
    }

    public String getZielPartnerCode() {
        return this.zielPartnerCode;
    }

    public String getUrsprungsPartnerCode() {
        return this.ursprungsPartnerCode;
    }

    public Date getErstellungsTimeStamp() {
        return this.erstellungsTimeStamp;
    }

    public List<DVSEmpfangsBestaetigungXMLInfo> getEBInfoListe() {
        return Collections.unmodifiableList(this.ebInfoList);
    }

    public static class DVSEmpfangsBestaetigungXMLInfo {
        private String feco = "";
        private String hint1 = "";
        private String hint2 = "";
        private String ddsReferenzNummer = "";
        private String partnerReferenzNummer = "";

        public DVSEmpfangsBestaetigungXMLInfo(String feco, String hint1, String hint2, String ddsReferenzNummer, String partnerReferenzNummer) {
            this.feco = feco;
            this.hint1 = hint1;
            this.hint2 = hint2;
            this.ddsReferenzNummer = ddsReferenzNummer;
            this.partnerReferenzNummer = partnerReferenzNummer;
        }

        public DVSEmpfangsBestaetigungXMLInfo(at.itsv.dvs.model.xsd15.EmpfangsbestaetigungType eb) {
            this.feco = eb.getFehlerCode();
            this.hint1 = eb.getHinweis1();
            this.hint2 = eb.getHinweis2();
            this.ddsReferenzNummer = eb.getDDSReferenzNummer();
            this.partnerReferenzNummer = eb.getPartnerReferenzNummer();
        }

        public DVSEmpfangsBestaetigungXMLInfo(EmpfangsbestaetigungType eb) {
            this.feco = eb.getFehlerCode();
            this.hint1 = eb.getHinweis1();
            this.hint2 = eb.getHinweis2();
            this.ddsReferenzNummer = eb.getDDSReferenzNummer();
            this.partnerReferenzNummer = eb.getPartnerReferenzNummer();
        }

        public String getFeco() {
            return this.feco;
        }

        public String getHint1() {
            return this.hint1;
        }

        public String getHint2() {
            return this.hint2;
        }

        public String getDdsReferenzNummer() {
            return this.ddsReferenzNummer;
        }

        public String getPartnerReferenzNummer() {
            return this.partnerReferenzNummer;
        }
    }
}

