/*
 * Decompiled with CFR 0.152.
 */
package at.itsv.dvs.model;

import at.itsv.dvs.io.MemoryDataLocation;
import at.itsv.dvs.model.DVSBestand;
import at.itsv.dvs.model.DVSBestandSART;
import at.itsv.dvs.model.DVSBestandXML;
import at.itsv.dvs.model.DVSEmpfangsBestaetigungSART;
import at.itsv.dvs.model.DVSEmpfangsBestaetigungXML;
import at.itsv.dvs.model.DVSError;
import at.itsv.dvs.model.DVSPaket;
import at.itsv.dvs.model.DVSPaketSART;
import at.itsv.dvs.model.DVSPaketXML;
import at.itsv.dvs.model.InvalidDataException;
import at.itsv.dvs.util.DVSConstants;
import at.itsv.dvs.util.DVSUtils;
import at.itsv.dvs.util.refno.ReferenzNummerException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.xml.bind.JAXBException;
import javax.xml.datatype.DatatypeConfigurationException;

public class DVSModel {
    private List<DVSPaket> paketList = new ArrayList<DVSPaket>();
    private List<DVSError> errorList = new ArrayList<DVSError>();

    public void convert2EBSART(String ZVST, String UVST) throws InvalidDataException {
        long bCount = 0L;
        DVSPaketSART ebPaket = new DVSPaketSART(ZVST, UVST);
        DVSBestandSART ebBestand = new DVSBestandSART(ZVST, UVST, "DD", "EB");
        for (DVSPaket paket : this.paketList) {
            List<DVSBestand> bestandList = paket.getBestandListe();
            for (DVSBestand bestand : bestandList) {
                DVSEmpfangsBestaetigungSART eb = new DVSEmpfangsBestaetigungSART(paket, bestand);
                ebBestand.addEmpfangsBestaetigung(eb);
                ++bCount;
            }
        }
        ebBestand.setSatzAnzahl(bCount + 2L);
        ebPaket.setSatzAnzahl(bCount + 4L);
        this.paketList.clear();
        ebPaket.addBestand(ebBestand);
        this.paketList.add(ebPaket);
    }

    public void convert2EBXML(String ZVST, String UVST, DVSConstants.XMLType xmlType) throws JAXBException, DatatypeConfigurationException, InvalidDataException, IOException, ReferenzNummerException {
        DVSPaketXML ebPaket = new DVSPaketXML(ZVST, UVST);
        for (DVSPaket paket : this.paketList) {
            List<DVSBestand> bestandList = paket.getBestandListe();
            for (DVSBestand bestand : bestandList) {
                String referenzNummer = DVSUtils.createXMLReferenzNummer(bestand).toString();
                DVSEmpfangsBestaetigungXML eb = new DVSEmpfangsBestaetigungXML(ZVST, UVST, referenzNummer);
                eb.addEmpfangsBestaetigungInfos(bestand);
                DVSBestandXML ebBestand = new DVSBestandXML(ZVST, UVST, "DD", "EB");
                ebBestand.setEmpfangsBestaetigung(eb);
                ebBestand.setReferenzNummer(referenzNummer);
                ebBestand.setTestKennzeichen(bestand.getTestKennzeichen());
                String ebXml = eb.toXMLString(xmlType);
                MemoryDataLocation mloc = new MemoryDataLocation(ebXml.getBytes());
                ebBestand.setDataLocation(mloc);
                ebPaket.addBestand(ebBestand);
            }
        }
        this.paketList.clear();
        this.paketList.add(ebPaket);
    }

    public int getPaketCount() {
        return this.paketList.size();
    }

    public int getBestandCount() {
        int count = 0;
        for (DVSPaket paket : this.paketList) {
            count += paket.getBestandCount();
        }
        return count;
    }

    public List<DVSPaket> getPakete() {
        return Collections.unmodifiableList(this.paketList);
    }

    public void addPaket(DVSPaket paket) {
        this.paketList.add(paket);
    }

    public void addError(DVSError error) {
        this.errorList.add(error);
    }

    public List<DVSError> getErrorList() {
        return Collections.unmodifiableList(this.errorList);
    }

    public boolean isErraneous() {
        return !this.getErrorList().isEmpty();
    }
}

