/*
 * Decompiled with CFR 0.152.
 */
package at.itsv.dvs.model;

import at.itsv.dvs.model.DVSBestand;
import at.itsv.dvs.model.DVSError;
import at.itsv.dvs.model.InvalidDataException;
import at.itsv.dvs.util.DVSUtils;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;

public class DVSPaket {
    private long epak;
    private String zielPartnerCode = "";
    private String ursprungsPartnerCode = "";
    private Date erstellungsDatum;
    private Date sendeDatum;
    private Date sendeZeit;
    private String paketBezeichnung = "";
    private long satzAnzahl = 0L;
    private long satzAnzahlExpected = 0L;
    private List<DVSBestand> bestandList = new ArrayList<DVSBestand>();
    private List<DVSError> errorList = new ArrayList<DVSError>();

    public DVSPaket(String zVST, String uVST) throws InvalidDataException {
        this(zVST, uVST, new Date());
    }

    public DVSPaket(String zVST, String uVST, String eRDT) throws ParseException, InvalidDataException {
        this(zVST, uVST, DVSUtils.getSartDateFromString(eRDT));
    }

    public DVSPaket(String zVST, String uVST, Date eRDT) throws InvalidDataException {
        this.setZielPartnerCode(zVST);
        this.setUrsprungsPartnerCode(uVST);
        this.setErstellungsDatum(eRDT);
        this.setSendeDatum(eRDT);
        this.setSendeZeit(eRDT);
    }

    protected DVSPaket() {
    }

    public List<DVSBestand> getBestandListe() {
        return Collections.unmodifiableList(this.bestandList);
    }

    public void clear() {
        for (DVSBestand bestand : this.bestandList) {
            bestand.clear();
        }
        this.bestandList.clear();
    }

    public void addBestand(DVSBestand bestand) {
        this.bestandList.add(bestand);
    }

    public int getBestandCount() {
        return this.bestandList.size();
    }

    public void addError(DVSError error) {
        this.errorList.add(error);
    }

    public List<DVSError> getErrorList() {
        return Collections.unmodifiableList(this.errorList);
    }

    public boolean isErroneous() {
        return !this.getErrorList().isEmpty();
    }

    public boolean hasErroneousBestand() {
        for (DVSBestand bestand : this.bestandList) {
            if (!bestand.isErroneous()) continue;
            return true;
        }
        return false;
    }

    public long getEPAK() {
        return this.epak;
    }

    public void setEPAK(long epak) {
        this.epak = epak;
    }

    public String getZielPartnerCode() {
        return this.zielPartnerCode;
    }

    protected void setZielPartnerCode(String zielPartnerCode) throws InvalidDataException {
        if (!DVSUtils.isValidLengthValue(zielPartnerCode, 2, true)) {
            throw new InvalidDataException("Ungueltiger ZielPartnerCode [" + zielPartnerCode + "] angegeben. Maximallaenge=2");
        }
        this.zielPartnerCode = zielPartnerCode;
    }

    public String getUrsprungsPartnerCode() {
        return this.ursprungsPartnerCode;
    }

    protected void setUrsprungsPartnerCode(String ursprungsPartnerCode) throws InvalidDataException {
        if (!DVSUtils.isValidLengthValue(ursprungsPartnerCode, 2, true)) {
            throw new InvalidDataException("Ungueltiger UrsprungsPartnerCode [" + ursprungsPartnerCode + "] angegeben. Maximallaenge=2");
        }
        this.ursprungsPartnerCode = ursprungsPartnerCode;
    }

    public Date getErstellungsDatum() {
        return this.erstellungsDatum;
    }

    protected void setErstellungsDatum(Date erstellungsDatum) {
        this.erstellungsDatum = erstellungsDatum;
    }

    public Date getSendeDatum() {
        return this.sendeDatum;
    }

    public void setSendeDatum(Date sendeDatum) {
        this.sendeDatum = sendeDatum;
    }

    public Date getSendeZeit() {
        return this.sendeZeit;
    }

    public void setSendeZeit(Date sendeZeit) {
        this.sendeZeit = sendeZeit;
    }

    public String getPaketBezeichnung() {
        return this.paketBezeichnung;
    }

    public void setPaketBezeichnung(String paketBezeichnung) throws InvalidDataException {
        if (!DVSUtils.isValidLengthValue(paketBezeichnung, 20)) {
            throw new InvalidDataException("Ungueltige PaketBezeichnung [" + paketBezeichnung + "] angegeben. Maximallaenge=20");
        }
        this.paketBezeichnung = paketBezeichnung;
    }

    public long getSatzAnzahl() {
        return this.satzAnzahl;
    }

    protected void incrementSatzAnzahl() {
        ++this.satzAnzahl;
    }

    public void setSatzAnzahl(long satzAnzahl) {
        this.satzAnzahl = satzAnzahl;
    }

    public long getSatzAnzahlExpected() {
        return this.satzAnzahlExpected;
    }

    protected void setSatzAnzahlExpected(long satzAnzahlExpected) {
        this.satzAnzahlExpected = satzAnzahlExpected;
    }
}

