/*
 * Decompiled with CFR 0.152.
 */
package at.itsv.dvs.model;

import at.itsv.dvs.model.DVSError;
import at.itsv.dvs.model.DVSPaket;
import at.itsv.dvs.model.InvalidDataException;
import at.itsv.dvs.util.DVSConstants;
import at.itsv.dvs.util.DVSUtils;
import java.text.ParseException;
import java.util.Date;

public class DVSPaketSART
extends DVSPaket {
    private boolean complete = false;
    private String paketKopfsatz;
    private String paketEndesatz;
    private long paketKopfsatzLineNo;
    private long paketEndesatzLineNo;

    public DVSPaketSART(String line, long lineNumber) throws InvalidDataException, ParseException {
        this.parseLineStart(line, lineNumber);
        this.addLine();
    }

    public DVSPaketSART(String zVST, String uVST) throws InvalidDataException {
        super(zVST, uVST);
        this.setSatzAnzahl(2L);
    }

    public DVSPaketSART(String zVST, String uVST, String eRDT) throws ParseException, InvalidDataException {
        super(zVST, uVST, eRDT);
        this.setSatzAnzahl(2L);
    }

    public DVSPaketSART(String zVST, String uVST, Date eRDT) throws InvalidDataException {
        super(zVST, uVST, eRDT);
        this.setSatzAnzahl(2L);
    }

    private void parseLineStart(String line, long lineNumber) throws InvalidDataException {
        String dateString;
        if (line == null || !line.startsWith(DVSConstants.DAORG_Satzkennzeichen.PAKET_KOPFSATZ.toString())) {
            throw new InvalidDataException(DVSUtils.getMessage("error.sart.invalid.kopfsatz", lineNumber, line));
        }
        String message = "";
        this.setPaketKopfsatz(line);
        this.setPaketKopfsatzLineNo(lineNumber);
        int length = line.length();
        if (length >= 3) {
            this.setZielPartnerCode(line.substring(1, 3).trim());
        } else {
            message = DVSUtils.getMessage("error.sart.invalid.kopfsatz.length", lineNumber, line.length());
            if (DVSUtils.isLenientErrorHandling()) {
                this.addError(new DVSError(DVSConstants.DVS_ERROR.ZVST_ERROR, DVSConstants.DAORG_FECO.SART_PAKET_KOPFSATZ, lineNumber, 1L, message));
            } else {
                throw new InvalidDataException(message);
            }
        }
        if (length >= 5) {
            this.setUrsprungsPartnerCode(line.substring(3, 5).trim());
        } else {
            message = DVSUtils.getMessage("error.sart.invalid.kopfsatz.length", lineNumber, line.length());
            if (DVSUtils.isLenientErrorHandling()) {
                this.addError(new DVSError(DVSConstants.DVS_ERROR.UVST_ERROR, DVSConstants.DAORG_FECO.SART_PAKET_KOPFSATZ, lineNumber, 3L, message));
            } else {
                throw new InvalidDataException(message);
            }
        }
        if (length >= 11) {
            dateString = line.substring(5, 11).trim();
            try {
                this.setErstellungsDatum(DVSUtils.getSartDateFromString(dateString));
            }
            catch (ParseException ex) {
                message = DVSUtils.getMessage("error.sart.invalid.kopfsatz.date", lineNumber, dateString);
                if (DVSUtils.isLenientErrorHandling()) {
                    this.addError(new DVSError(DVSConstants.DVS_ERROR.ERDT_ERROR, DVSConstants.DAORG_FECO.SART_PAKET_KOPFSATZ, lineNumber, 5L, message));
                }
                throw new InvalidDataException(message, ex);
            }
        } else {
            message = DVSUtils.getMessage("error.sart.invalid.kopfsatz.length", lineNumber, line.length());
            if (DVSUtils.isLenientErrorHandling()) {
                this.addError(new DVSError(DVSConstants.DVS_ERROR.ERDT_ERROR, DVSConstants.DAORG_FECO.SART_PAKET_KOPFSATZ, lineNumber, 5L, message));
            } else {
                throw new InvalidDataException(message);
            }
        }
        if (length >= 17 && (dateString = line.substring(11, 17).trim()).length() > 0) {
            try {
                this.setSendeDatum(DVSUtils.getSartDateFromString(dateString));
            }
            catch (ParseException ex) {
                message = DVSUtils.getMessage("error.sart.invalid.kopfsatz.date", lineNumber, dateString);
                if (DVSUtils.isLenientErrorHandling()) {
                    this.addError(new DVSError(DVSConstants.DVS_ERROR.SDDT_ERROR, DVSConstants.DAORG_FECO.SART_PAKET_KOPFSATZ, lineNumber, 11L, message));
                }
                throw new InvalidDataException(message, ex);
            }
        }
        if (length >= 23 && (dateString = line.substring(17, 23).trim()).length() > 0) {
            try {
                this.setSendeZeit(DVSUtils.getSartTimeFromString(dateString));
            }
            catch (ParseException ex) {
                message = DVSUtils.getMessage("error.sart.invalid.kopfsatz.date", lineNumber, dateString);
                if (DVSUtils.isLenientErrorHandling()) {
                    this.addError(new DVSError(DVSConstants.DVS_ERROR.SDZT_ERROR, DVSConstants.DAORG_FECO.SART_PAKET_KOPFSATZ, lineNumber, 17L, message));
                }
                throw new InvalidDataException(message, ex);
            }
        }
        if (length >= 48) {
            this.setPaketBezeichnung(line.substring(28, 48).trim());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void parseLineEnd(String line, long lineNumber) throws InvalidDataException {
        if (line == null || !line.startsWith(DVSConstants.DAORG_Satzkennzeichen.PAKET_ENDESATZ.toString())) {
            throw new InvalidDataException(DVSUtils.getMessage("error.sart.invalid.endesatz", lineNumber, line));
        }
        String message = "";
        this.setPaketEndesatz(line);
        this.setPaketEndesatzLineNo(lineNumber);
        int length = line.length();
        if (length >= 3) {
            String zvst = line.substring(1, 3).trim();
            if (!this.getZielPartnerCode().equals(zvst)) {
                message = DVSUtils.getMessage("error.sart.invalid.endesatz.zvst", lineNumber, zvst, this.getZielPartnerCode(), this.getPaketKopfsatzLineNo());
                if (!DVSUtils.isLenientErrorHandling()) throw new InvalidDataException(message);
                this.addError(new DVSError(DVSConstants.DVS_ERROR.ZVST_ERROR, DVSConstants.DAORG_FECO.SART_PAKET_ENDESATZ, lineNumber, 1L, message));
            }
        } else {
            message = DVSUtils.getMessage("error.sart.invalid.endesatz.length", lineNumber, line.length());
            if (!DVSUtils.isLenientErrorHandling()) throw new InvalidDataException(message);
            this.addError(new DVSError(DVSConstants.DVS_ERROR.ZVST_ERROR, DVSConstants.DAORG_FECO.SART_PAKET_ENDESATZ, lineNumber, 1L, message));
        }
        if (length >= 5) {
            String uvst = line.substring(3, 5).trim();
            if (!this.getUrsprungsPartnerCode().equals(uvst)) {
                message = DVSUtils.getMessage("error.sart.invalid.endesatz.uvst", lineNumber, uvst, this.getUrsprungsPartnerCode(), this.getPaketKopfsatzLineNo());
                if (!DVSUtils.isLenientErrorHandling()) throw new InvalidDataException(message);
                this.addError(new DVSError(DVSConstants.DVS_ERROR.UVST_ERROR, DVSConstants.DAORG_FECO.SART_PAKET_ENDESATZ, lineNumber, 3L, message));
            }
        } else {
            message = DVSUtils.getMessage("error.sart.invalid.endesatz.length", lineNumber, line.length());
            if (!DVSUtils.isLenientErrorHandling()) throw new InvalidDataException(message);
            this.addError(new DVSError(DVSConstants.DVS_ERROR.UVST_ERROR, DVSConstants.DAORG_FECO.SART_PAKET_ENDESATZ, lineNumber, 3L, message));
        }
        if (length >= 13) {
            long sanz = -1L;
            try {
                sanz = Long.parseLong(line.substring(5, 13).trim());
            }
            catch (NumberFormatException ex) {
                // empty catch block
            }
            this.setSatzAnzahlExpected(sanz);
            if (sanz != -1L && sanz == this.getSatzAnzahl()) return;
            message = DVSUtils.getMessage("error.sart.invalid.endesatz.sanz", lineNumber, sanz, this.getSatzAnzahl());
            if (!DVSUtils.isLenientErrorHandling()) throw new InvalidDataException(message);
            this.addError(new DVSError(DVSConstants.DVS_ERROR.SANZ_ERROR, DVSConstants.DAORG_FECO.SART_PAKET_ENDESATZ, lineNumber, 5L, message));
            return;
        }
        message = DVSUtils.getMessage("error.sart.invalid.endesatz.length", lineNumber, line.length());
        if (!DVSUtils.isLenientErrorHandling()) throw new InvalidDataException(message);
        this.addError(new DVSError(DVSConstants.DVS_ERROR.SANZ_ERROR, DVSConstants.DAORG_FECO.SART_PAKET_ENDESATZ, lineNumber, 5L, message));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finish(String line, long lineNumber) throws InvalidDataException {
        try {
            this.addLine();
            this.parseLineEnd(line, lineNumber);
        }
        finally {
            this.complete = true;
        }
    }

    public void addLine() {
        this.incrementSatzAnzahl();
    }

    public boolean isComplete() {
        return this.complete;
    }

    public String getPaketKopfsatz() {
        return this.paketKopfsatz;
    }

    protected void setPaketKopfsatz(String paketKopfsatz) {
        this.paketKopfsatz = paketKopfsatz;
    }

    public String getPaketEndesatz() {
        return this.paketEndesatz;
    }

    protected void setPaketEndesatz(String paketEndesatz) {
        this.paketEndesatz = paketEndesatz;
    }

    public long getPaketKopfsatzLineNo() {
        return this.paketKopfsatzLineNo;
    }

    protected void setPaketKopfsatzLineNo(long paketKopfsatzLineNo) {
        this.paketKopfsatzLineNo = paketKopfsatzLineNo;
    }

    public long getPaketEndesatzLineNo() {
        return this.paketEndesatzLineNo;
    }

    protected void setPaketEndesatzLineNo(long paketEndesatzLineNo) {
        this.paketEndesatzLineNo = paketEndesatzLineNo;
    }
}

