/*
 * Decompiled with CFR 0.152.
 */
package at.itsv.dvs.parser;

import at.itsv.dvs.model.DVSError;
import at.itsv.dvs.parser.DVSParseException;
import at.itsv.dvs.parser.LineErrorHandler;
import at.itsv.dvs.parser.LineHandler;
import at.itsv.dvs.parser.filter.LineFilter;
import at.itsv.dvs.parser.validator.LineValidator;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;

public class LineReader {
    private BufferedReader br;
    private LineHandler lh;
    private LineErrorHandler eh;
    private String charset;
    private boolean crlf = false;
    private long lineNumber = 0L;
    private long byteOffset = 0L;
    private long skipTil = -1L;
    private long readTil = -1L;
    private List<LineFilter> lineFilterList = new ArrayList<LineFilter>();
    private LineFilter lastLineFilter = null;
    private List<LineValidator> lineValidatorList = new ArrayList<LineValidator>();

    public LineReader(InputStream in, LineHandler lh) throws UnsupportedEncodingException {
        this(in, lh, false);
    }

    public LineReader(InputStream in, LineHandler lh, boolean crlf) throws UnsupportedEncodingException {
        this(in, "UTF-8", lh, crlf);
    }

    public LineReader(InputStream in, String charset, LineHandler lh) throws UnsupportedEncodingException {
        this(in, charset, lh, false);
    }

    public LineReader(InputStream in, String charset, LineHandler lh, boolean crlf) throws UnsupportedEncodingException {
        this.br = new BufferedReader(new InputStreamReader(in, charset));
        this.lh = lh;
        this.charset = charset;
        this.crlf = crlf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long start() throws IOException, DVSParseException {
        try {
            String line = null;
            while ((line = this.br.readLine()) != null) {
                ++this.lineNumber;
                if (this.lineNumber < this.skipTil) continue;
                if (this.lineNumber > this.readTil && this.readTil > 0L) {
                    break;
                }
                for (LineFilter filter : this.lineFilterList) {
                    line = filter.applyLineFilter(line, this.lineNumber, this.byteOffset);
                }
                for (LineValidator validator : this.lineValidatorList) {
                    DVSError error = validator.isLineValid(line, this.lineNumber, this.byteOffset);
                    if (error == null || this.eh == null) continue;
                    if (error.getErrorObject() == null) {
                        error.setErrorObject(line);
                    }
                    if (this.eh.handleLineError(error)) continue;
                    throw new DVSParseException(error.toString());
                }
                if (!this.lh.handleLine(line, this.lineNumber, this.byteOffset)) {
                    break;
                }
                this.byteOffset += (long)(line.getBytes(this.charset).length + (this.crlf ? 2 : 1));
            }
        }
        finally {
            this.close();
        }
        return this.lineNumber;
    }

    public void close() throws IOException {
        this.br.close();
    }

    public void addLineFilter(LineFilter lineFilter) {
        this.addLineFilter(lineFilter, false);
    }

    public void addLineFilter(LineFilter lineFilter, boolean isLast) {
        if (isLast) {
            this.lastLineFilter = lineFilter;
            this.lineFilterList.add(lineFilter);
        } else if (this.lastLineFilter == null) {
            this.lineFilterList.add(lineFilter);
        } else {
            this.lineFilterList.add(this.lineFilterList.indexOf(this.lastLineFilter), lineFilter);
        }
    }

    public void addLineValidator(LineValidator lineValidator) {
        this.lineValidatorList.add(lineValidator);
    }

    public LineErrorHandler getErrorHandler() {
        return this.eh;
    }

    public void setErrorHandler(LineErrorHandler eh) {
        this.eh = eh;
    }

    public long getSkipTil() {
        return this.skipTil;
    }

    public void setSkipTil(long skipTil) {
        this.skipTil = skipTil;
    }

    public long getReadTil() {
        return this.readTil;
    }

    public void setReadTil(long readTil) {
        this.readTil = readTil;
    }
}

