/*
 * Decompiled with CFR 0.152.
 */
package at.itsv.dvs.parser;

import at.itsv.dvs.io.ImportListener;
import at.itsv.dvs.model.DVSBestandSART;
import at.itsv.dvs.model.DVSDataLocation;
import at.itsv.dvs.model.DVSEmpfangsBestaetigungSART;
import at.itsv.dvs.model.DVSError;
import at.itsv.dvs.model.DVSModel;
import at.itsv.dvs.model.DVSPaketSART;
import at.itsv.dvs.model.InvalidDataException;
import at.itsv.dvs.parser.DVSParseException;
import at.itsv.dvs.parser.LineErrorHandler;
import at.itsv.dvs.parser.LineHandler;
import at.itsv.dvs.parser.LineReader;
import at.itsv.dvs.parser.validator.MaxLengthValidator;
import at.itsv.dvs.util.DVSConstants;
import at.itsv.dvs.util.DVSUtils;
import java.io.IOException;
import java.io.InputStream;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class SARTParser
implements LineHandler,
LineErrorHandler {
    private DVSConstants.SARTType sartType;
    private String charset = "UTF-8";
    private Set<DVSConstants.DAORG_Satzkennzeichen> expectedLineFlags = new HashSet<DVSConstants.DAORG_Satzkennzeichen>();
    private DVSModel dvsModel = null;
    private DVSDataLocation curDataLocation = null;
    private DVSPaketSART curPaket = null;
    private DVSBestandSART curBestand = null;
    private boolean splitData = false;
    private boolean crlf = false;
    private boolean firstBestandLine = false;
    protected List<ImportListener> importListener = new ArrayList<ImportListener>();
    private boolean retainData = true;

    public SARTParser(DVSConstants.SARTType sartType) {
        this.sartType = sartType;
    }

    public DVSModel parse(DVSDataLocation dl) throws DVSParseException, IOException {
        return this.parse(dl, new DVSModel());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DVSModel parse(DVSDataLocation dl, DVSModel dvsModel) throws DVSParseException, IOException {
        this.dvsModel = dvsModel;
        this.curDataLocation = dl;
        this.expectedLineFlags.clear();
        this.setLineFeed();
        switch (this.sartType) {
            case EINZELBESTAND: {
                if (this.curPaket == null) {
                    throw new DVSParseException("SART Parser not setup correctly. Missing PAKET for SART-Type EINZELBESTAND.");
                }
                if (this.curBestand == null) {
                    throw new DVSParseException("SART Parser not setup correctly. Missing BESTAND for SART-Type EINZELBESTAND.");
                }
                this.curPaket.addBestand(this.curBestand);
                this.curPaket.setSatzAnzahl(this.curPaket.getSatzAnzahl() + this.curBestand.getSatzAnzahl());
                this.expectedLineFlags.add(DVSConstants.DAORG_Satzkennzeichen.VORLAUFSATZ);
                this.expectedLineFlags.add(DVSConstants.DAORG_Satzkennzeichen.DATENSATZ);
                break;
            }
            case SAMMELBESTAND: {
                if (this.curPaket == null) {
                    throw new DVSParseException("SART Parser not setup correctly. Missing PAKET for SART-Type SAMMELBESTAND.");
                }
                if (this.isRetainData()) {
                    this.dvsModel.addPaket(this.curPaket);
                }
                this.expectedLineFlags.add(DVSConstants.DAORG_Satzkennzeichen.BESTAND_VORSATZ);
                break;
            }
            default: {
                this.expectedLineFlags.add(DVSConstants.DAORG_Satzkennzeichen.PAKET_KOPFSATZ);
            }
        }
        LineReader lr = new LineReader(this.curDataLocation.getInputStream(), this.charset, this, this.crlf);
        lr.addLineValidator(new MaxLengthValidator());
        lr.setErrorHandler(this);
        try {
            long lineCount = lr.start();
            if (this.sartType != DVSConstants.SARTType.EINZELBESTAND && this.curBestand != null && !this.curBestand.isComplete()) {
                this.curBestand.addError(new DVSError(DVSConstants.DVS_ERROR.BESTAND_NACHSATZ_MISSING, DVSConstants.DAORG_FECO.SART_BESTAND_NACHSATZ, lineCount, 0L));
                this.curBestand.close();
            }
            if (this.sartType != DVSConstants.SARTType.SAMMELBESTAND && this.sartType != DVSConstants.SARTType.EINZELBESTAND && this.curPaket != null && !this.curPaket.isComplete()) {
                this.curPaket.addError(new DVSError(DVSConstants.DVS_ERROR.PAKET_ENDESATZ_MISSING, DVSConstants.DAORG_FECO.SART_PAKET_ENDESATZ, lineCount, 0L));
                this.handlePaketEnd(null, lineCount);
            }
        }
        finally {
            lr.close();
        }
        return dvsModel;
    }

    public void reset() {
        this.dvsModel = null;
        this.curDataLocation = null;
        this.curPaket = null;
        this.curBestand = null;
    }

    @Override
    public boolean handleLine(String line, long lineNumber, long byteOffset) throws DVSParseException {
        DVSConstants.DAORG_Satzkennzeichen lineFlag = this.getLineFlag(line);
        if (lineFlag == DVSConstants.DAORG_Satzkennzeichen.UNDEFINED) {
            lineFlag = DVSConstants.DAORG_Satzkennzeichen.DATENSATZ;
        }
        if (!this.isValidLineFlag(lineFlag)) {
            if (DVSUtils.isLenientErrorHandling()) {
                this.handleStructureError(lineFlag, lineNumber, byteOffset);
            } else {
                throw new DVSParseException(DVSUtils.getMessage("error.sart.invalid.lineflag", new Object[]{lineFlag.name(), lineFlag, this.curDataLocation.getLocationInfo(), lineNumber}));
            }
        }
        this.expectedLineFlags.clear();
        switch (lineFlag) {
            case PAKET_KOPFSATZ: {
                this.curPaket = this.handlePaketStart(line, lineNumber);
                this.expectedLineFlags.add(DVSConstants.DAORG_Satzkennzeichen.BESTAND_VORSATZ);
                break;
            }
            case PAKET_ENDESATZ: {
                this.handlePaketEnd(line, lineNumber);
                this.expectedLineFlags.add(DVSConstants.DAORG_Satzkennzeichen.PAKET_KOPFSATZ);
                break;
            }
            case BESTAND_VORSATZ: {
                this.curBestand = this.handleBestandStart(line, lineNumber);
                if (!this.splitData || this.curBestand.isEmpfangsBestaetigung()) {
                    this.curBestand.setDataLocation(this.curDataLocation);
                    if (!this.splitData) {
                        this.firstBestandLine = true;
                    }
                }
                this.expectedLineFlags.add(DVSConstants.DAORG_Satzkennzeichen.VORLAUFSATZ);
                this.expectedLineFlags.add(DVSConstants.DAORG_Satzkennzeichen.DATENSATZ);
                break;
            }
            case BESTAND_NACHSATZ: {
                if (this.splitData) {
                    this.handleBestandEnd(line, lineNumber, -1L);
                } else {
                    this.handleBestandEnd(line, lineNumber, byteOffset - (long)(this.crlf ? 2 : 1));
                }
                this.expectedLineFlags.add(DVSConstants.DAORG_Satzkennzeichen.BESTAND_VORSATZ);
                this.expectedLineFlags.add(DVSConstants.DAORG_Satzkennzeichen.PAKET_ENDESATZ);
                break;
            }
            case VORLAUFSATZ: {
                this.expectedLineFlags.add(DVSConstants.DAORG_Satzkennzeichen.VORLAUFSATZ);
                this.expectedLineFlags.add(DVSConstants.DAORG_Satzkennzeichen.DATENSATZ);
            }
            case DATENSATZ: {
                this.curPaket.addLine();
                this.curBestand.addLine();
                if (!this.curBestand.isEmpfangsBestaetigung()) {
                    if (this.firstBestandLine) {
                        this.firstBestandLine = false;
                        this.curBestand.setOffSetStart(byteOffset);
                    }
                    if (this.splitData) {
                        try {
                            this.curBestand.dumpLine(line);
                        }
                        catch (IOException ex) {
                            throw new DVSParseException(ex);
                        }
                    }
                } else {
                    DVSEmpfangsBestaetigungSART eb = this.handleEmpfangsBestaetigungLine(line, lineNumber);
                    this.curBestand.addEmpfangsBestaetigung(eb);
                }
                this.expectedLineFlags.add(DVSConstants.DAORG_Satzkennzeichen.DATENSATZ);
                this.expectedLineFlags.add(DVSConstants.DAORG_Satzkennzeichen.BESTAND_NACHSATZ);
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
        return true;
    }

    private boolean isValidLineFlag(DVSConstants.DAORG_Satzkennzeichen lineFlag) {
        return this.expectedLineFlags.contains((Object)lineFlag);
    }

    private void handleStructureError(DVSConstants.DAORG_Satzkennzeichen lineFlag, long lineNumber, long byteOffset) throws DVSParseException {
        if (this.expectedLineFlags.contains((Object)DVSConstants.DAORG_Satzkennzeichen.PAKET_ENDESATZ)) {
            if (this.curPaket != null) {
                this.curPaket.addError(new DVSError(DVSConstants.DVS_ERROR.PAKET_ENDESATZ_MISSING, DVSConstants.DAORG_FECO.SART_PAKET_ENDESATZ, lineNumber, 0L));
                this.handlePaketEnd(null, lineNumber);
            }
            switch (lineFlag) {
                case BESTAND_NACHSATZ: 
                case VORLAUFSATZ: 
                case DATENSATZ: {
                    this.curPaket = this.createDummyPaket();
                    this.curPaket.addError(new DVSError(DVSConstants.DVS_ERROR.PAKET_KOPFSATZ_MISSING, DVSConstants.DAORG_FECO.SART_PAKET_KOPFSATZ, lineNumber, 0L));
                    this.curBestand = this.createDummyBestand(this.curPaket);
                    this.curBestand.addError(new DVSError(DVSConstants.DVS_ERROR.BESTAND_VORSATZ_MISSING, DVSConstants.DAORG_FECO.SART_BESTAND_VORSATZ, lineNumber, 0L));
                    break;
                }
            }
            return;
        }
        if (this.expectedLineFlags.contains((Object)DVSConstants.DAORG_Satzkennzeichen.BESTAND_VORSATZ)) {
            switch (lineFlag) {
                case PAKET_KOPFSATZ: {
                    if (this.curPaket == null) break;
                    this.curPaket.addError(new DVSError(DVSConstants.DVS_ERROR.PAKET_ENDESATZ_MISSING, DVSConstants.DAORG_FECO.SART_PAKET_ENDESATZ, lineNumber, 0L));
                    this.handlePaketEnd(null, lineNumber);
                    break;
                }
                case BESTAND_NACHSATZ: 
                case VORLAUFSATZ: 
                case DATENSATZ: {
                    this.curBestand = this.createDummyBestand(this.curPaket);
                    this.curBestand.addError(new DVSError(DVSConstants.DVS_ERROR.BESTAND_VORSATZ_MISSING, DVSConstants.DAORG_FECO.SART_BESTAND_VORSATZ, lineNumber, 0L));
                    break;
                }
                case PAKET_ENDESATZ: {
                    break;
                }
            }
            return;
        }
        if (this.expectedLineFlags.contains((Object)DVSConstants.DAORG_Satzkennzeichen.PAKET_KOPFSATZ)) {
            switch (lineFlag) {
                case PAKET_ENDESATZ: 
                case BESTAND_VORSATZ: {
                    this.curPaket = this.createDummyPaket();
                    this.curPaket.addError(new DVSError(DVSConstants.DVS_ERROR.PAKET_KOPFSATZ_MISSING, DVSConstants.DAORG_FECO.SART_PAKET_KOPFSATZ, lineNumber, 0L));
                    break;
                }
                case BESTAND_NACHSATZ: 
                case VORLAUFSATZ: 
                case DATENSATZ: {
                    this.curPaket = this.createDummyPaket();
                    this.curPaket.addError(new DVSError(DVSConstants.DVS_ERROR.PAKET_KOPFSATZ_MISSING, DVSConstants.DAORG_FECO.SART_PAKET_KOPFSATZ, lineNumber, 0L));
                    this.curBestand = this.createDummyBestand(this.curPaket);
                    this.curBestand.addError(new DVSError(DVSConstants.DVS_ERROR.BESTAND_VORSATZ_MISSING, DVSConstants.DAORG_FECO.SART_BESTAND_VORSATZ, lineNumber, 0L));
                    break;
                }
            }
            if (this.isRetainData()) {
                this.dvsModel.addPaket(this.curPaket);
            }
            return;
        }
        if (this.expectedLineFlags.contains((Object)DVSConstants.DAORG_Satzkennzeichen.DATENSATZ)) {
            switch (lineFlag) {
                case VORLAUFSATZ: {
                    if (this.curBestand != null) {
                        this.curBestand.addError(new DVSError(DVSConstants.DVS_ERROR.SART_STRUCTURE_ERROR, DVSConstants.DAORG_FECO.SART_DATENSATZ, lineNumber, 0L));
                    }
                    return;
                }
            }
        }
        if (this.expectedLineFlags.contains((Object)DVSConstants.DAORG_Satzkennzeichen.BESTAND_NACHSATZ)) {
            if (this.curBestand != null) {
                this.curBestand.addError(new DVSError(DVSConstants.DVS_ERROR.BESTAND_NACHSATZ_MISSING, DVSConstants.DAORG_FECO.SART_BESTAND_NACHSATZ, lineNumber, 0L));
                this.handleBestandEnd(null, lineNumber, byteOffset);
            }
            switch (lineFlag) {
                case PAKET_KOPFSATZ: {
                    if (this.curPaket == null) break;
                    this.curPaket.addError(new DVSError(DVSConstants.DVS_ERROR.PAKET_ENDESATZ_MISSING, DVSConstants.DAORG_FECO.SART_PAKET_ENDESATZ, lineNumber, 0L));
                    this.handlePaketEnd(null, lineNumber);
                    break;
                }
            }
            return;
        }
        if (this.expectedLineFlags.contains((Object)DVSConstants.DAORG_Satzkennzeichen.VORLAUFSATZ) || this.expectedLineFlags.contains((Object)DVSConstants.DAORG_Satzkennzeichen.DATENSATZ)) {
            switch (lineFlag) {
                case PAKET_KOPFSATZ: {
                    if (this.curBestand != null) {
                        this.curBestand.addError(new DVSError(DVSConstants.DVS_ERROR.BESTAND_NACHSATZ_MISSING, DVSConstants.DAORG_FECO.SART_BESTAND_NACHSATZ, lineNumber, 0L));
                        this.handleBestandEnd(null, lineNumber, byteOffset);
                    }
                    if (this.curPaket == null) break;
                    this.curPaket.addError(new DVSError(DVSConstants.DVS_ERROR.PAKET_ENDESATZ_MISSING, DVSConstants.DAORG_FECO.SART_PAKET_ENDESATZ, lineNumber, 0L));
                    break;
                }
                case PAKET_ENDESATZ: 
                case BESTAND_VORSATZ: {
                    if (this.curBestand == null) break;
                    this.curBestand.addError(new DVSError(DVSConstants.DVS_ERROR.BESTAND_NACHSATZ_MISSING, DVSConstants.DAORG_FECO.SART_BESTAND_NACHSATZ, lineNumber, 0L));
                    this.handleBestandEnd(null, lineNumber, byteOffset);
                    break;
                }
            }
            return;
        }
    }

    private DVSPaketSART createDummyPaket() {
        DVSPaketSART paket = null;
        try {
            return new DVSPaketSART("XX", "XX");
        }
        catch (InvalidDataException invalidDataException) {
            return paket;
        }
    }

    private DVSBestandSART createDummyBestand(DVSPaketSART paket) {
        DVSBestandSART bestand = null;
        try {
            bestand = new DVSBestandSART("XX", "XX", "XX", "XX");
            paket.addBestand(bestand);
            paket.addLine();
        }
        catch (InvalidDataException invalidDataException) {
            // empty catch block
        }
        return bestand;
    }

    private DVSPaketSART handlePaketStart(String line, long lineNumber) throws DVSParseException {
        DVSPaketSART dvsPaket = null;
        try {
            dvsPaket = new DVSPaketSART(line, lineNumber);
            if (this.isRetainData()) {
                this.dvsModel.addPaket(dvsPaket);
            }
        }
        catch (InvalidDataException | ParseException ex) {
            throw new DVSParseException(ex);
        }
        return dvsPaket;
    }

    private DVSPaketSART handlePaketEnd(String line, long lineNumber) throws DVSParseException {
        DVSPaketSART dvsPaket = this.curPaket;
        try {
            if (line != null) {
                dvsPaket.finish(line, lineNumber);
            }
            for (ImportListener listener : this.getImportListener()) {
                listener.importPaket(this.curPaket);
            }
            if (!this.isRetainData()) {
                dvsPaket.clear();
            }
        }
        catch (InvalidDataException ex) {
            throw new DVSParseException(ex);
        }
        return dvsPaket;
    }

    private DVSBestandSART handleBestandStart(String line, long lineNumber) throws DVSParseException {
        DVSBestandSART dvsBestand = null;
        try {
            dvsBestand = new DVSBestandSART(line, !this.splitData, lineNumber);
            dvsBestand.setCharset(this.charset);
            this.curPaket.addBestand(dvsBestand);
            this.curPaket.addLine();
        }
        catch (InvalidDataException | ParseException ex) {
            throw new DVSParseException(ex);
        }
        return dvsBestand;
    }

    private DVSBestandSART handleBestandEnd(String line, long lineNumber, long byteOffset) throws DVSParseException {
        DVSBestandSART dvsBestand = this.curBestand;
        try {
            if (line != null) {
                dvsBestand.finish(line, lineNumber, byteOffset);
                this.curPaket.addLine();
            }
            for (ImportListener listener : this.getImportListener()) {
                listener.importBestand(this.curBestand);
            }
        }
        catch (InvalidDataException ex) {
            throw new DVSParseException(ex);
        }
        return dvsBestand;
    }

    private DVSEmpfangsBestaetigungSART handleEmpfangsBestaetigungLine(String line, long lineNumber) throws DVSParseException {
        DVSEmpfangsBestaetigungSART eb = new DVSEmpfangsBestaetigungSART(line.substring(1), lineNumber);
        return eb;
    }

    @Override
    public boolean handleLineError(DVSError error) {
        error.setDataLocation(this.curDataLocation);
        DVSConstants.DAORG_Satzkennzeichen lineFlag = this.getLineFlag((String)error.getErrorObject());
        switch (lineFlag) {
            case PAKET_KOPFSATZ: 
            case PAKET_ENDESATZ: {
                if (this.curPaket == null) break;
                this.curPaket.addError(error);
                break;
            }
            default: {
                if (this.curBestand == null) break;
                this.curBestand.addError(error);
            }
        }
        return DVSUtils.isLenientErrorHandling();
    }

    protected DVSConstants.DAORG_Satzkennzeichen getLineFlag(String line) {
        if (line != null && line.length() > 0) {
            return DVSConstants.DAORG_Satzkennzeichen.fromString(line.substring(0, 1));
        }
        return DVSConstants.DAORG_Satzkennzeichen.UNDEFINED;
    }

    private void setLineFeed() throws IOException {
        try (InputStream in = this.curDataLocation.getInputStream();){
            int read = 0;
            byte prev = 0;
            byte[] buf = new byte[1024];
            while ((read = in.read(buf)) != -1) {
                for (int i = 0; i < buf.length; ++i) {
                    if (buf[i] != 10) continue;
                    if (i == 0 && prev == 13 || buf[i - 1] == 13) {
                        this.crlf = true;
                    }
                    return;
                }
                prev = buf[buf.length - 1];
                buf = new byte[1024];
            }
        }
    }

    public String getCharset() {
        return this.charset;
    }

    public void setCharset(String charset) {
        this.charset = charset;
    }

    public DVSPaketSART getCurrentPaket() {
        return this.curPaket;
    }

    public void setCurrentPaket(DVSPaketSART curPaket) {
        this.curPaket = curPaket;
    }

    public DVSBestandSART getCurrentBestand() {
        return this.curBestand;
    }

    public void setCurrentBestand(DVSBestandSART curBestand) {
        this.curBestand = curBestand;
    }

    public boolean isSplitData() {
        return this.splitData;
    }

    public void setSplitData(boolean splitData) {
        this.splitData = splitData;
    }

    public boolean isCRLF() {
        return this.crlf;
    }

    public List<ImportListener> getImportListener() {
        return this.importListener;
    }

    public void setImportListener(List<ImportListener> importListener) {
        this.importListener = importListener;
    }

    public void addImportListener(ImportListener listener) {
        this.importListener.add(listener);
    }

    public boolean isRetainData() {
        return this.retainData;
    }

    public void setRetainData(boolean retainData) {
        this.retainData = retainData;
    }
}

