/*
 * Decompiled with CFR 0.152.
 */
package at.itsv.dvs.parser;

import at.itsv.dvs.io.FileDataLocation;
import at.itsv.dvs.io.ImportListener;
import at.itsv.dvs.io.ZipEntryDataLocation;
import at.itsv.dvs.model.DVSBestandXML;
import at.itsv.dvs.model.DVSDataLocation;
import at.itsv.dvs.model.DVSEmpfangsBestaetigungXML;
import at.itsv.dvs.model.DVSError;
import at.itsv.dvs.model.DVSModel;
import at.itsv.dvs.model.DVSPaketXML;
import at.itsv.dvs.model.InvalidDataException;
import at.itsv.dvs.model.xsd14.BestandKomprimiertType;
import at.itsv.dvs.model.xsd14.BestandType;
import at.itsv.dvs.model.xsd14.BestandsInfoType;
import at.itsv.dvs.model.xsd14.EmpfangsbestaetigungType;
import at.itsv.dvs.model.xsd15.BestandSigniertType;
import at.itsv.dvs.model.xsd15.BestandVerschluesseltType;
import at.itsv.dvs.model.xsd15.BestandsListeType;
import at.itsv.dvs.model.xsd15.DatendrehscheibePaketType;
import at.itsv.dvs.model.xsd15.EmpfangsbestaetigungsFileType;
import at.itsv.dvs.model.xsd15.EmpfangsbestaetigungsKopfType;
import at.itsv.dvs.model.xsd15.EmpfangsbestaetigungsListeType;
import at.itsv.dvs.model.xsd15.FileInfoType;
import at.itsv.dvs.model.xsd15.PaketkopfType;
import at.itsv.dvs.parser.LineErrorHandler;
import at.itsv.dvs.util.DVSConstants;
import at.itsv.dvs.util.DVSUtils;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.ValidationEvent;
import javax.xml.bind.ValidationEventHandler;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class XMLParser
implements LineErrorHandler {
    private DVSConstants.XMLType xmlType;
    private List<ImportListener> importListener = new ArrayList<ImportListener>();
    private boolean retainData = true;

    public XMLParser(DVSConstants.XMLType xmlType) {
        this.xmlType = xmlType;
    }

    public DVSModel parse(FileDataLocation dl, String charSet) throws IOException, JAXBException, SAXException, InvalidDataException {
        return this.parse(dl, new DVSModel(), charSet);
    }

    public DVSModel parse(FileDataLocation dl, DVSModel dvsModel, String charSet) throws IOException, JAXBException, SAXException, InvalidDataException {
        if (dvsModel == null) {
            dvsModel = new DVSModel();
        }
        ValidatingListener vl = new ValidatingListener(dl);
        DatendrehscheibePaketType p = this.unmarshalXML(dl, vl, charSet);
        Map<Object, DVSError> errorMap = vl.getErrorMap();
        if (errorMap.containsKey(p)) {
            dvsModel.addError(errorMap.get(p));
        }
        DVSPaketXML paket = new DVSPaketXML(p.getPaketkopf());
        if (errorMap.containsKey(p.getPaketkopf())) {
            paket.addError(errorMap.get(p.getPaketkopf()));
        }
        if (this.isRetainData()) {
            dvsModel.addPaket(paket);
        }
        List<at.itsv.dvs.model.xsd15.BestandType> l = p.getBestandsListe().getBestand();
        for (at.itsv.dvs.model.xsd15.BestandType b : l) {
            DVSBestandXML bestand = new DVSBestandXML(b);
            bestand.setDataLocation(new ZipEntryDataLocation(dl.getPath(), b.getFileInfo().getLinkAufBestandsFile()));
            if (errorMap.containsKey(b.getBestandsInfo())) {
                bestand.addError(errorMap.get(b.getBestandsInfo()));
            }
            paket.addBestand(bestand);
            for (ImportListener listener : this.getImportListener()) {
                listener.importBestand(bestand);
            }
            if (!bestand.isEmpfangsBestaetigung()) continue;
            this.parseEmpfangsBestaetigung(bestand);
        }
        for (ImportListener listener : this.getImportListener()) {
            listener.importPaket(paket);
        }
        if (!this.isRetainData()) {
            paket.clear();
        }
        return dvsModel;
    }

    protected DatendrehscheibePaketType unmarshalXML(DVSDataLocation dl, ValidatingListener vl, String charSet) throws IOException, JAXBException, SAXException {
        try (InputStream in = dl.getInputStream();){
            JAXBContext ctx = JAXBContext.newInstance((String)this.xmlType.getContext());
            Unmarshaller um = ctx.createUnmarshaller();
            um.setEventHandler((ValidationEventHandler)vl);
            um.setListener((Unmarshaller.Listener)vl);
            DatendrehscheibePaketType ddsPaket = null;
            SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            switch (this.xmlType) {
                case XSD15: {
                    Schema schema = schemaFactory.newSchema(this.getClass().getResource("/resources/xsd/DDS_Schema_V1_5.xsd"));
                    um.setSchema(schema);
                    try {
                        JAXBElement root = um.unmarshal((Source)new StreamSource(in), DatendrehscheibePaketType.class);
                        ddsPaket = (DatendrehscheibePaketType)root.getValue();
                        if (ddsPaket.getPaketkopf() == null || ddsPaket.getBestandsListe() == null) {
                            throw new IOException("Invalid XML version provided");
                        }
                        break;
                    }
                    catch (JAXBException ex) {
                        if (DVSUtils.isLenientErrorHandling()) {
                            ddsPaket = vl.getDdsPaket();
                            if (ddsPaket == null) {
                                throw ex;
                            }
                            if (ddsPaket.getPaketkopf() == null) {
                                ddsPaket.setPaketkopf(new PaketkopfType());
                            }
                            if (ddsPaket.getBestandsListe() != null) break;
                            ddsPaket.setBestandsListe(new BestandsListeType());
                            break;
                        }
                        throw ex;
                    }
                }
                case XSD14: {
                    Schema schema = schemaFactory.newSchema(this.getClass().getResource("/resources/xsd/DDS_Schema_V1_4.xsd"));
                    um.setSchema(schema);
                    try {
                        JAXBElement root14 = um.unmarshal((Source)new StreamSource(in), at.itsv.dvs.model.xsd14.DatendrehscheibePaketType.class);
                        if (((at.itsv.dvs.model.xsd14.DatendrehscheibePaketType)root14.getValue()).getPaketkopf() == null || ((at.itsv.dvs.model.xsd14.DatendrehscheibePaketType)root14.getValue()).getBestandsListe() == null) {
                            throw new IOException("Invalid XML version provided");
                        }
                        ddsPaket = this.convertXSD14toXSD15((at.itsv.dvs.model.xsd14.DatendrehscheibePaketType)root14.getValue());
                        break;
                    }
                    catch (JAXBException ex) {
                        if (DVSUtils.isLenientErrorHandling()) {
                            at.itsv.dvs.model.xsd14.DatendrehscheibePaketType ddsPaket14 = vl.getDdsPaket14();
                            if (ddsPaket14 == null) {
                                throw ex;
                            }
                            if (ddsPaket14.getPaketkopf() == null) {
                                ddsPaket14.setPaketkopf(new at.itsv.dvs.model.xsd14.PaketkopfType());
                            }
                            if (ddsPaket14.getBestandsListe() == null) {
                                ddsPaket14.setBestandsListe(new at.itsv.dvs.model.xsd14.BestandsListeType());
                            }
                            ddsPaket = this.convertXSD14toXSD15(ddsPaket14);
                            break;
                        }
                        throw ex;
                    }
                }
            }
            DatendrehscheibePaketType datendrehscheibePaketType = ddsPaket;
            return datendrehscheibePaketType;
        }
    }

    protected DatendrehscheibePaketType convertXSD14toXSD15(at.itsv.dvs.model.xsd14.DatendrehscheibePaketType ddsPaket14) {
        DatendrehscheibePaketType ddsPaket = new DatendrehscheibePaketType();
        PaketkopfType paketKopf = new PaketkopfType();
        paketKopf.setUrsprungspartnerCode(ddsPaket14.getPaketkopf().getUrsprungspartnerCode());
        paketKopf.setZielpartnerCode(ddsPaket14.getPaketkopf().getZielpartnerCode());
        paketKopf.setErstellungsdatum(ddsPaket14.getPaketkopf().getErstellungsdatum());
        paketKopf.setPaketbezeichnung(ddsPaket14.getPaketkopf().getPaketbezeichnung());
        paketKopf.setSendedatum(ddsPaket14.getPaketkopf().getSendedatum());
        paketKopf.setSendezeit(ddsPaket14.getPaketkopf().getSendezeit());
        ddsPaket.setPaketkopf(paketKopf);
        BestandsListeType bestandsListe = new BestandsListeType();
        List<BestandType> bestandsListe14 = ddsPaket14.getBestandsListe().getBestand();
        for (BestandType bestand14 : bestandsListe14) {
            at.itsv.dvs.model.xsd15.BestandType bestand = new at.itsv.dvs.model.xsd15.BestandType();
            at.itsv.dvs.model.xsd15.BestandsInfoType bestandsInfo = new at.itsv.dvs.model.xsd15.BestandsInfoType();
            bestandsInfo.setAenderungsdienstNummer(bestand14.getBestandsInfo().getAenderungsdienstNummer());
            bestandsInfo.setEingabeArt(bestand14.getBestandsInfo().getEingabeArt());
            bestandsInfo.setEingabeBestandsNummer(bestand14.getBestandsInfo().getEingabeBestandsNummer());
            bestandsInfo.setErstellungsdatum(bestand14.getBestandsInfo().getErstellungsdatum());
            bestandsInfo.setListKennzeichen(bestand14.getBestandsInfo().getListKennzeichen());
            bestandsInfo.setProjektKennzeichen(bestand14.getBestandsInfo().getProjektKennzeichen());
            bestandsInfo.setReferenzNummer(bestand14.getBestandsInfo().getReferenzNummer());
            bestandsInfo.setTestKennzeichen(bestand14.getBestandsInfo().getTestKennzeichen());
            bestandsInfo.setUrsprungspartnerCode(bestand14.getBestandsInfo().getUrsprungspartnerCode());
            bestandsInfo.setZielpartnerCode(bestand14.getBestandsInfo().getZielpartnerCode());
            bestandsInfo.setZusaetzlInfo("");
            bestandsInfo.setZusaetzlOrdnungsbegriff(bestand14.getBestandsInfo().getZusaetzlOrdnungsbegriff());
            FileInfoType fileInfo = new FileInfoType();
            fileInfo.setHashWert("");
            fileInfo.setInhalt(bestand14.getBestandsInfo().getBestandInhalt());
            fileInfo.setKomprimiert(bestand14.getBestandsInfo().getBestandKomprimiert() == BestandKomprimiertType.J ? at.itsv.dvs.model.xsd15.BestandKomprimiertType.J : at.itsv.dvs.model.xsd15.BestandKomprimiertType.N);
            fileInfo.setLinkAufBestandsFile(bestand14.getLinkAufBestandsFile());
            fileInfo.setSatzAnzahl(null);
            fileInfo.setSigniert(bestand14.getBestandsInfo().getBestandSigniert() == at.itsv.dvs.model.xsd14.BestandSigniertType.J ? BestandSigniertType.J : BestandSigniertType.N);
            fileInfo.setVerschluesselt(bestand14.getBestandsInfo().getBestandVerschluesselt() == at.itsv.dvs.model.xsd14.BestandVerschluesseltType.J ? BestandVerschluesseltType.J : BestandVerschluesseltType.N);
            bestand.setBestandsInfo(bestandsInfo);
            bestand.setFileInfo(fileInfo);
            bestandsListe.getBestand().add(bestand);
        }
        ddsPaket.setBestandsListe(bestandsListe);
        return ddsPaket;
    }

    protected void parseEmpfangsBestaetigung(DVSBestandXML bestand) throws IOException, JAXBException, SAXException {
        ValidatingListener vl = new ValidatingListener(bestand.getDataLocation());
        EmpfangsbestaetigungsFileType ebFile = this.unmarshalXMLEB(bestand.getDataLocation(), vl);
        DVSEmpfangsBestaetigungXML eb = new DVSEmpfangsBestaetigungXML(ebFile);
        bestand.setEmpfangsBestaetigung(eb);
    }

    protected EmpfangsbestaetigungsFileType unmarshalXMLEB(DVSDataLocation dl, ValidatingListener vl) throws IOException, JAXBException, SAXException {
        try (InputStream in = dl.getInputStream();){
            JAXBContext ctx = JAXBContext.newInstance((String)this.xmlType.getContext());
            Unmarshaller um = ctx.createUnmarshaller();
            EmpfangsbestaetigungsFileType ebFileType = null;
            SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            switch (this.xmlType) {
                case XSD15: {
                    Schema schema = schemaFactory.newSchema(this.getClass().getResource("/resources/xsd/DDS_Schema_V1_5.xsd"));
                    um.setSchema(schema);
                    JAXBElement root = um.unmarshal((Source)new StreamSource(in), EmpfangsbestaetigungsFileType.class);
                    ebFileType = (EmpfangsbestaetigungsFileType)root.getValue();
                    break;
                }
                case XSD14: {
                    Schema schema = schemaFactory.newSchema(this.getClass().getResource("/resources/xsd/DDS_Schema_V1_4.xsd"));
                    um.setSchema(schema);
                    JAXBElement root14 = um.unmarshal((Source)new StreamSource(in), at.itsv.dvs.model.xsd14.EmpfangsbestaetigungsFileType.class);
                    ebFileType = this.convertEBXSD14toXSD15((at.itsv.dvs.model.xsd14.EmpfangsbestaetigungsFileType)root14.getValue());
                    break;
                }
            }
            EmpfangsbestaetigungsFileType empfangsbestaetigungsFileType = ebFileType;
            return empfangsbestaetigungsFileType;
        }
    }

    protected EmpfangsbestaetigungsFileType convertEBXSD14toXSD15(at.itsv.dvs.model.xsd14.EmpfangsbestaetigungsFileType ebFileType14) {
        EmpfangsbestaetigungsFileType ebFile = new EmpfangsbestaetigungsFileType();
        EmpfangsbestaetigungsKopfType ebKopf = new EmpfangsbestaetigungsKopfType();
        ebKopf.setZielpartnerCode(ebFileType14.getEmpfangsbestaetigungsKopf().getZielpartnerCode());
        ebKopf.setUrsprungspartnerCode(ebFileType14.getEmpfangsbestaetigungsKopf().getUrsprungspartnerCode());
        ebKopf.setErstellungsTimeStamp(ebFileType14.getEmpfangsbestaetigungsKopf().getErstellungsTimeStamp());
        ebFile.setEmpfangsbestaetigungsKopf(ebKopf);
        EmpfangsbestaetigungsListeType ebList = new EmpfangsbestaetigungsListeType();
        List<EmpfangsbestaetigungType> ebList14 = ebFileType14.getEmpfangsbestaetigungsListe().getEmpfangsbestaetigung();
        for (EmpfangsbestaetigungType eb14 : ebList14) {
            at.itsv.dvs.model.xsd15.EmpfangsbestaetigungType eb = new at.itsv.dvs.model.xsd15.EmpfangsbestaetigungType();
            eb.setFehlerCode(eb14.getFehlerCode());
            eb.setHinweis1(eb14.getHinweis1());
            eb.setHinweis2(eb14.getHinweis2());
            eb.setDDSReferenzNummer(eb14.getDDSReferenzNummer());
            eb.setPartnerReferenzNummer(eb14.getPartnerReferenzNummer());
            ebList.getEmpfangsbestaetigung().add(eb);
        }
        ebFile.setEmpfangsbestaetigungsListe(ebList);
        return ebFile;
    }

    @Override
    public boolean handleLineError(DVSError error) {
        return DVSUtils.isLenientErrorHandling();
    }

    public List<ImportListener> getImportListener() {
        return this.importListener;
    }

    public void setImportListener(List<ImportListener> importListener) {
        this.importListener = importListener;
    }

    public void addImportListener(ImportListener listener) {
        this.importListener.add(listener);
    }

    public boolean isRetainData() {
        return this.retainData;
    }

    public void setRetainData(boolean retainData) {
        this.retainData = retainData;
    }

    public static class ValidatingListener
    extends Unmarshaller.Listener
    implements ValidationEventHandler {
        private DVSDataLocation dl = null;
        private Object curObject = null;
        private Object curParent = null;
        private Map<Object, DVSError> errorMap = new HashMap<Object, DVSError>();
        private DatendrehscheibePaketType ddsPaket = null;
        private at.itsv.dvs.model.xsd14.DatendrehscheibePaketType ddsPaket14 = null;

        public ValidatingListener() {
        }

        public ValidatingListener(DVSDataLocation dl) {
            this.dl = dl;
        }

        public void beforeUnmarshal(Object target, Object parent) {
            this.curObject = target;
            this.curParent = parent;
        }

        public void afterUnmarshal(Object target, Object parent) {
            if (target instanceof DatendrehscheibePaketType) {
                this.ddsPaket = (DatendrehscheibePaketType)target;
            } else if (parent instanceof DatendrehscheibePaketType) {
                this.ddsPaket = (DatendrehscheibePaketType)parent;
            }
            if (target instanceof at.itsv.dvs.model.xsd14.DatendrehscheibePaketType) {
                this.ddsPaket14 = (at.itsv.dvs.model.xsd14.DatendrehscheibePaketType)target;
            } else if (parent instanceof at.itsv.dvs.model.xsd14.DatendrehscheibePaketType) {
                this.ddsPaket14 = (at.itsv.dvs.model.xsd14.DatendrehscheibePaketType)parent;
            }
            this.curObject = null;
            this.curParent = null;
        }

        public boolean handleEvent(ValidationEvent event) {
            String message = event.getMessage();
            int lineNumber = event.getLocator().getLineNumber();
            int columnNumber = event.getLocator().getColumnNumber();
            boolean hasError = false;
            DVSConstants.DAORG_FECO feco = DVSConstants.DAORG_FECO.GENERAL;
            DVSConstants.DVS_ERROR dvsError = DVSConstants.DVS_ERROR.GENERAL_ERROR;
            if (this.isStructureError(event) && (this.ddsPaket != null || this.ddsPaket14 != null) && !this.errorMap.containsKey(this.curObject)) {
                dvsError = DVSConstants.DVS_ERROR.XML_STRUCTURE_ERROR;
                if (this.curObject == null || this.isDatendrehscheibePaket(this.curObject)) {
                    feco = DVSConstants.DAORG_FECO.XML_TAG_DDPAKET_MISSING;
                    this.curObject = this.ddsPaket != null ? this.ddsPaket : this.ddsPaket14;
                } else if (this.isPaketKopf(this.curObject)) {
                    feco = DVSConstants.DAORG_FECO.XML_TAG_PAKETKOPF_STRUCTURE_ERROR;
                } else if (this.isBestandInfo(this.curObject)) {
                    feco = DVSConstants.DAORG_FECO.XML_TAG_INFO_STRUCTURE_ERROR;
                }
                hasError = true;
            } else if (this.isContentError(message) && !this.errorMap.containsKey(this.curObject)) {
                dvsError = DVSConstants.DVS_ERROR.XML_CONTENT_ERROR;
                if (this.isPaketKopf(this.curObject)) {
                    feco = DVSConstants.DAORG_FECO.XML_TAG_PAKETKOPF_CONTENT_INVALID;
                } else if (this.isBestandInfo(this.curObject)) {
                    feco = DVSConstants.DAORG_FECO.XML_TAG_INFO_CONTENT_INVALID;
                }
                hasError = true;
            } else if (this.isFormatError(message) && !this.errorMap.containsKey(this.curObject)) {
                dvsError = DVSConstants.DVS_ERROR.XML_CONTENT_ERROR;
                if (this.isPaketKopf(this.curObject)) {
                    feco = DVSConstants.DAORG_FECO.XML_TAG_PAKETKOPF_FORMAT_INVALID;
                } else if (this.isBestandInfo(this.curObject)) {
                    feco = DVSConstants.DAORG_FECO.XML_TAG_INFO_FORMAT_INVALID;
                }
                hasError = true;
            }
            if (hasError) {
                DVSError error = new DVSError(dvsError, feco, lineNumber, columnNumber);
                error.setMessage(message);
                error.setDataLocation(this.dl);
                this.errorMap.put(this.curObject, error);
            }
            return true;
        }

        public Map<Object, DVSError> getErrorMap() {
            return this.errorMap;
        }

        public DatendrehscheibePaketType getDdsPaket() {
            return this.ddsPaket;
        }

        public at.itsv.dvs.model.xsd14.DatendrehscheibePaketType getDdsPaket14() {
            return this.ddsPaket14;
        }

        private boolean isStructureError(ValidationEvent event) {
            return event.getLinkedException() instanceof SAXParseException;
        }

        private boolean isContentError(String errorMsg) {
            if (errorMsg == null) {
                return false;
            }
            return errorMsg.startsWith("cvc-pattern-valid");
        }

        private boolean isFormatError(String errorMsg) {
            if (errorMsg == null) {
                return false;
            }
            return errorMsg.startsWith("cvc-datatype-valid");
        }

        private boolean isDatendrehscheibePaket(Object o) {
            return this.curObject instanceof DatendrehscheibePaketType || this.curObject instanceof at.itsv.dvs.model.xsd14.DatendrehscheibePaketType;
        }

        private boolean isPaketKopf(Object o) {
            return o instanceof PaketkopfType || o instanceof at.itsv.dvs.model.xsd14.PaketkopfType;
        }

        private boolean isBestandInfo(Object o) {
            return o instanceof at.itsv.dvs.model.xsd15.BestandsInfoType || o instanceof BestandsInfoType;
        }
    }
}

