/*
 * Decompiled with CFR 0.152.
 */
package at.itsv.dvs.parser.validator;

import at.itsv.dvs.model.DVSError;
import at.itsv.dvs.parser.validator.LineValidator;
import at.itsv.dvs.util.DVSConstants;
import java.io.UnsupportedEncodingException;

public class CharacterValidator
implements LineValidator {
    private String charset = "UTF-8";

    public CharacterValidator() {
    }

    public CharacterValidator(String charset) throws UnsupportedEncodingException {
        "".getBytes(charset);
        this.charset = charset;
    }

    @Override
    public DVSError isLineValid(String line, long lineNumber, long byteOffset) {
        char[] chars = line.toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            if (this.isValidCharacter(chars[i])) continue;
            return new DVSError(DVSConstants.DVS_ERROR.DATENSATZ_INVALID_CHARACTER, DVSConstants.DAORG_FECO.SART_DATENSATZ, lineNumber, i);
        }
        return null;
    }

    private boolean isValidCharacter(int b) {
        if (b >= 32 && b <= 126) {
            return true;
        }
        switch (this.charset) {
            case "ISO-8859-1": {
                return this.test819(b);
            }
            case "IBM850": {
                return this.test850(b);
            }
            case "UTF-8": {
                return this.testUTF8(b);
            }
        }
        throw new AssertionError();
    }

    private boolean test819(int b) {
        switch (b) {
            case 196: 
            case 214: 
            case 220: 
            case 223: 
            case 228: 
            case 246: 
            case 252: {
                return true;
            }
        }
        return false;
    }

    private boolean test850(int b) {
        switch (b) {
            case 129: 
            case 132: 
            case 142: 
            case 148: 
            case 153: 
            case 154: 
            case 225: {
                return true;
            }
        }
        return false;
    }

    private boolean testUTF8(int b) {
        return b >= 192 && b <= 255 || b >= 256 && b <= 383 || b >= 384 && b <= 591 || b >= 7680 && b <= 7935;
    }
}

