/*
 * Decompiled with CFR 0.152.
 */
package at.itsv.dvs.util;

import java.text.SimpleDateFormat;

public interface DVSConstants {
    public static final String DVS_CHARSET_DEFAULT = "UTF-8";
    public static final String DVS_CHARSET_819 = "ISO-8859-1";
    public static final String DVS_CHARSET_850 = "IBM850";
    public static final String DVS_FILE_PREFIX = "dd";
    public static final String DVS_FILE_EXPORT_PREFIX = "dvs";
    public static final String DVS_FILE_PREFIX_OLD_STYLE = "rmt";
    public static final String DVS_FILE_SUFFIX_OLD_STYLE = "ddftp";
    public static final String DVS_FILE_SUFFIX_OUT_OLD_STYLE = "ddau";
    public static final long DVS_MAX_LINE_LENGTH = 32752L;
    public static final String DVS_PROPERTY_VSTR = "at.itsv.dvs.VSTR";
    public static final String DVS_PROPERTY_RUNNING_AS_DVS = "at.itsv.dvs.running.as.dvs";
    public static final String DVS_PROPERTY_LENIENT_ERROR = "at.itsv.dvs.lenient.error.handling";
    public static final String DVS_PROPERTY_TMP_DIR = "at.itsv.dvs.tmp.dir";
    public static final String DVS_PROPERTY_REFID_DIR = "at.itsv.dvs.ref.dir";
    public static final String DVS_PROPERTY_KEEP_TMP_FILES = "at.itsv.dvs.keep.tmpfiles";
    public static final String DVS_PROPERTY_REFNOGENERATOR = "at.itsv.dvs.RefNoGeneratorClass";
    public static final String DVS_PROPERTY_IMPORTLISTENER = "at.itsv.dvs.ImportListener";
    public static final String DVS_PROPERTY_EXPORTLISTENER = "at.itsv.dvs.ExportListener";
    public static final String DVS_XSD_V15 = "/resources/xsd/DDS_Schema_V1_5.xsd";
    public static final String DVS_XSD_V14 = "/resources/xsd/DDS_Schema_V1_4.xsd";
    public static final String DVS_XSD_NAMESPACE_URI_V15 = "http://www.sozvers.at/ns/if/dds/draft/1/5/DDS_Schema_V1_5.xsd";
    public static final String DVS_XSD_NAMESPACE_URI_V14 = "http://www.sozvers.at/ns/if/dds/draft/1/4/DDS_Schema_V1_4.xsd";
    public static final String DVS_XSD_LOCALPART_DDS = "DatendrehscheibePaket";
    public static final String DVS_XSD_LOCALPART_EB = "EmpfangsbestaetigungsFile";
    public static final String SART_DATE_FORMAT_PATTERN = "ddMMyy";
    public static final SimpleDateFormat SART_DATE_FORMAT = new SimpleDateFormat("ddMMyy");
    public static final String SART_TIME_FORMAT_PATTERN = "HHmmss";
    public static final SimpleDateFormat SART_TIME_FORMAT = new SimpleDateFormat("HHmmss");
    public static final String SART_DEFAULT_FOBL = "00001";
    public static final String DVS_DEFAULT_TESTKZ = " ";
    public static final String DVS_TESTKZ = "T";
    public static final String FILE_DATE_FORMAT_PATTERN = "yyyyMMdd";
    public static final SimpleDateFormat FILE_DATE_FORMAT = new SimpleDateFormat("yyyyMMdd");
    public static final String FILE_DATE_OLD_STYLE_FORMAT_PATTERN = "ddMM";
    public static final SimpleDateFormat FILE_DATE_OLD_STYLE_FORMAT = new SimpleDateFormat("ddMM");
    public static final String EB_PROJ = "DD";
    public static final String EB_LIST = "EB";
    public static final String DEFAULT_EB_ZVST = "99";
    public static final String FECO_NO_ERROR = "000";
    public static final String FECO_SINGLE_ERROR_SUFFIX = "0";
    public static final String FECO_MULTIPLE_ERROR_SUFFIX = "9";
    public static final String DVS_TMPFILE_PREFIX = "dvs";
    public static final String DVS_DD_PREFIX = "dd";
    public static final String DVS_RMT_PREFIX = "rmt";
    public static final String DVS_PAKETINFO_SUFFIX = ".paketinfo.xml";
    public static final String DVS_UTF_SUFFIX = ".utf";
    public static final String DVS_XML_SUFFIX = ".xml";
    public static final String DVS_DEFAULT_REFNOGENERATOR = "at.itsv.dvs.util.refno.DefaultReferenzNummerGenerator";

    public static enum DirectionType {
        IN("ein"),
        OUT("aus");

        private final String direction;

        private DirectionType(String direction) {
            this.direction = direction;
        }

        public String getDirection() {
            return this.direction;
        }

        public String toString() {
            return this.direction;
        }

        public static String list() {
            String list = "";
            for (DirectionType dt : DirectionType.values()) {
                list = list == "" ? dt.name() : list + "," + dt.name();
            }
            return list;
        }
    }

    public static enum CompressionType {
        ZIP(".zip"),
        GZIP(".gz"),
        NONE("");

        private final String extension;

        private CompressionType(String extension) {
            this.extension = extension;
        }

        public String toString() {
            return this.extension;
        }

        public static CompressionType fromString(String text) {
            if (text != null) {
                for (CompressionType zt : CompressionType.values()) {
                    if (!text.endsWith(zt.extension)) continue;
                    return zt;
                }
            }
            return NONE;
        }

        public static String list() {
            String list = "";
            for (CompressionType zt : CompressionType.values()) {
                list = list.length() == 0 ? zt.name() : list + "," + zt.name();
            }
            return list;
        }
    }

    public static enum XMLType {
        XSD14("at.itsv.dvs.model.xsd14"),
        XSD15("at.itsv.dvs.model.xsd15");

        private final String context;

        private XMLType(String context) {
            this.context = context;
        }

        public String getContext() {
            return this.context;
        }

        public String toString() {
            return this.context;
        }
    }

    public static enum SARTType {
        PAKET,
        SAMMELBESTAND,
        EINZELBESTAND;

    }

    public static enum DAORG_FECO {
        SART_TESTKZ("12"),
        SART_PAKET_KOPFSATZ("13"),
        SART_BESTAND_VORSATZ("14"),
        SART_BESTAND_NACHSATZ("15"),
        SART_PAKET_ENDESATZ("16"),
        SART_DATENSATZ("17"),
        SART_DOPPELEINGABE("18"),
        XML_NO_ZIP_FILE("21"),
        XML_TAG_DDPAKET_MISSING("22"),
        XML_WRONG_XSD_VERSION("23"),
        XML_TAG_PAKETKOPF_STRUCTURE_ERROR("24"),
        XML_TAG_INFO_STRUCTURE_ERROR("25"),
        XML_TAG_PAKETKOPF_FORMAT_INVALID("26"),
        XML_TAG_PAKETKOPF_CONTENT_INVALID("27"),
        XML_TAG_INFO_FORMAT_INVALID("28"),
        XML_TAG_INFO_CONTENT_INVALID("29"),
        XML_TAG_DATAFILE_MISSING("30"),
        XML_BESTAND_DUPLICATE("31"),
        XML_TEST_FLAG_INVALID("32"),
        GENERAL("");

        private final String feco;

        private DAORG_FECO(String feco) {
            this.feco = feco;
        }

        public String toString() {
            return this.feco;
        }

        public static DAORG_FECO fromString(String text) {
            if (text != null) {
                for (DAORG_FECO fc : DAORG_FECO.values()) {
                    if (!text.equalsIgnoreCase(fc.feco)) continue;
                    return fc;
                }
            }
            return null;
        }
    }

    public static enum DAORG_Satzkennzeichen {
        PAKET_KOPFSATZ("0"),
        PAKET_ENDESATZ("9"),
        BESTAND_VORSATZ("1"),
        BESTAND_NACHSATZ("4"),
        VORLAUFSATZ("2"),
        DATENSATZ("3"),
        UNDEFINED(null);

        private final String lineFlag;

        private DAORG_Satzkennzeichen(String lineFlag) {
            this.lineFlag = lineFlag;
        }

        public String toString() {
            return this.lineFlag;
        }

        public static DAORG_Satzkennzeichen fromString(String text) {
            if (text != null) {
                for (DAORG_Satzkennzeichen lf : DAORG_Satzkennzeichen.values()) {
                    if (!text.equalsIgnoreCase(lf.lineFlag)) continue;
                    return lf;
                }
            }
            return UNDEFINED;
        }
    }

    public static enum DVS_ERROR {
        PAKET_KOPFSATZ_MISSING("Paketkopfsatz fehlt"),
        PAKET_ENDESATZ_MISSING("Paketendesatz fehlt"),
        BESTAND_VORSATZ_MISSING("Vorsatz fehlt"),
        BESTAND_NACHSATZ_MISSING("Nachsatz fehlt"),
        DATENSATZ_MISSING("Eingabedaten fehlen"),
        DATENSATZ_LENGTH_EXCEEDED("Eingabedaten Zeile zu lang"),
        DATENSATZ_INVALID_CHARACTER("Eingabedaten falsches Zeichen"),
        ZVST_ERROR("ZVST fehlerhaft"),
        UVST_ERROR("UVST fehlerhaft"),
        ERDT_ERROR("ERDT fehlerhaft"),
        PROJ_ERROR("PROJ fehlerhaft"),
        SDDT_ERROR("SDDT fehlerhaft"),
        SDZT_ERROR("SDZT fehlerhaft"),
        SANZ_ERROR("SANZ fehlerhaft"),
        SART_STRUCTURE_ERROR("SART Struktur fehlerhaft"),
        SART_GENERAL_DATA_ERROR("Allgemeiner SART Fehler"),
        XML_CONTENT_ERROR("XML Daten fehlerhaft"),
        XML_STRUCTURE_ERROR("XML Struktur fehlerhaft"),
        EB_ERROR("Empfangsbestaetigung fehlerhaft"),
        GENERAL_ERROR("Allgemeiner Fehler");

        private final String error;

        private DVS_ERROR(String error) {
            this.error = error;
        }

        public String toString() {
            return this.error;
        }

        public static DVS_ERROR fromString(String text) {
            if (text != null) {
                for (DVS_ERROR err : DVS_ERROR.values()) {
                    if (!text.equalsIgnoreCase(err.error)) continue;
                    return err;
                }
            }
            return null;
        }
    }
}

