/*
 * Decompiled with CFR 0.152.
 */
package at.itsv.dvs.util;

import at.itsv.dvs.io.ExportListener;
import at.itsv.dvs.io.ImportListener;
import at.itsv.dvs.model.DVSBestand;
import at.itsv.dvs.model.DVSDataDescriptor;
import at.itsv.dvs.model.InvalidDataException;
import at.itsv.dvs.util.DVSConstants;
import at.itsv.dvs.util.MessageManager;
import at.itsv.dvs.util.refno.DVSReferenzNummer;
import at.itsv.dvs.util.refno.DVSReferenzNummerGenerator;
import at.itsv.dvs.util.refno.ReferenzNummerException;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.file.Path;
import java.text.ParseException;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Objects;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;

public class DVSUtils {
    private static MessageManager msgManager = MessageManager.getMessageManager("resources.msg.messages");
    private static DVSReferenzNummerGenerator refNoGenerator = null;
    private static String refNoGeneratorClass = System.getProperty("at.itsv.dvs.RefNoGeneratorClass", "at.itsv.dvs.util.refno.DefaultReferenzNummerGenerator");
    private static ImportListener importListener = null;
    private static String importListenerName = System.getProperty("at.itsv.dvs.ImportListener");
    private static ExportListener exportListener = null;
    private static String exportListenerName = System.getProperty("at.itsv.dvs.ExportListener");

    public static String getMessage(String key, Object ... args) {
        return msgManager.getMessage(key, args);
    }

    public static ImportListener getImportListener() {
        if (importListenerName == null || importListenerName.length() == 0) {
            return null;
        }
        if (importListener == null) {
            try {
                Object o = Class.forName(importListenerName).newInstance();
                if (!(o instanceof ImportListener)) {
                    return null;
                }
                importListener = (ImportListener)o;
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException ex) {
                return null;
            }
        }
        return importListener;
    }

    public static ExportListener getExportListener() {
        if (exportListenerName == null || exportListenerName.length() == 0) {
            return null;
        }
        if (exportListener == null) {
            try {
                Object o = Class.forName(exportListenerName).newInstance();
                if (!(o instanceof ExportListener)) {
                    return null;
                }
                exportListener = (ExportListener)o;
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException ex) {
                return null;
            }
        }
        return exportListener;
    }

    public static DVSReferenzNummer createXMLReferenzNummer(DVSBestand bestand) throws ReferenzNummerException {
        if (refNoGenerator == null) {
            try {
                Object o = Class.forName(refNoGeneratorClass).newInstance();
                if (!(o instanceof DVSReferenzNummerGenerator)) {
                    throw new ReferenzNummerException("Ungueltige Klasse [" + refNoGeneratorClass + "] fuer Referenznummerngenerator angegeben.");
                }
                refNoGenerator = (DVSReferenzNummerGenerator)o;
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException ex) {
                throw new ReferenzNummerException(ex);
            }
        }
        DVSReferenzNummer refNo = null;
        try {
            refNo = refNoGenerator.generateReferenzNummer(DVSUtils.deepCopyBestand(bestand));
        }
        catch (InvalidDataException ex) {
            throw new ReferenzNummerException(ex);
        }
        if (refNo == null) {
            throw new ReferenzNummerException("Referenznummer von Generator [" + refNoGeneratorClass + "] darf nicht null sein.");
        }
        return refNo;
    }

    private static DVSBestand deepCopyBestand(DVSBestand bestand) throws InvalidDataException {
        DVSBestand copy = new DVSBestand(bestand.getZielPartnerCode(), bestand.getUrsprungsPartnerCode(), bestand.getProjektKennzeichen(), bestand.getListKennzeichen());
        if (bestand.getAbonnement() != null) {
            copy.setAbonnement(new DVSBestand.DVSAbonnement(bestand.getAbonnement().getAbo(), bestand.getAbonnement().getAboKey()));
        }
        copy.setAenderungsDienstNummer(bestand.getAenderungsDienstNummer());
        copy.setCharset(bestand.getCharset());
        if (bestand.getDataDescriptor() != null) {
            copy.setDataDescriptor((DVSDataDescriptor)bestand.getDataDescriptor().clone());
        }
        copy.setEBES(bestand.getEBES());
        copy.setEingabeArt(bestand.getEingabeArt());
        copy.setEingabeBestandsNummer(bestand.getEingabeBestandsNummer());
        copy.setKomprimierungsCode(bestand.getKomprimierungsCode());
        if (bestand.getOlInfo() != null) {
            copy.setOlInfo(new DVSBestand.DVSOLInfo(bestand.getOlInfo().getPartnerCode(), bestand.getOlInfo().getHint1(), bestand.getOlInfo().getHint2()));
        }
        copy.setSatzAnzahl(bestand.getSatzAnzahl());
        copy.setTestKennzeichen(bestand.getTestKennzeichen());
        copy.setZusaetzlInfo(bestand.getZusaetzlInfo());
        copy.setZusaetzlOrdnungsbegriff(bestand.getZusaetzlOrdnungsbegriff());
        return copy;
    }

    public static String padRight(String s, int n) {
        if (n > 0) {
            s = String.format("%1$-" + n + "s", s);
        }
        return s;
    }

    public static String padLeft(String s, int n) {
        if (n > 0) {
            s = String.format("%1$" + n + "s", s);
        }
        return s;
    }

    public static String padRight(String s, int n, char character) {
        if (n > 0) {
            s = String.format("%1$-" + n + "s", s).replace(' ', character);
        }
        return s;
    }

    public static String padLeft(String s, int n, char character) {
        if (n > 0) {
            s = String.format("%1$" + n + "s", s).replace(' ', character);
        }
        return s;
    }

    public static Date getFileDateFromString(String dateStr) throws ParseException {
        return DVSConstants.FILE_DATE_FORMAT.parse(dateStr);
    }

    public static String getFileDateString(Date date) {
        return DVSConstants.FILE_DATE_FORMAT.format(date);
    }

    public static String getSartDateString(Date date) {
        return DVSConstants.SART_DATE_FORMAT.format(date);
    }

    public static Date getSartDateFromString(String sartDateStr) throws ParseException {
        return DVSConstants.SART_DATE_FORMAT.parse(sartDateStr);
    }

    public static String getSartTimeString(Date date) {
        return DVSConstants.SART_TIME_FORMAT.format(date);
    }

    public static Date getSartTimeFromString(String sartDateStr) throws ParseException {
        return DVSConstants.SART_TIME_FORMAT.parse(sartDateStr);
    }

    public static Date xmlGregorianCalendar2Date(XMLGregorianCalendar xgc) {
        Objects.requireNonNull(xgc, "xgc must not be null");
        return xgc.toGregorianCalendar().getTime();
    }

    public static XMLGregorianCalendar date2XMLGregorianCalendar(Date date) throws DatatypeConfigurationException {
        Objects.requireNonNull(date, "date must not be null");
        GregorianCalendar gregory = new GregorianCalendar();
        gregory.setTime(date);
        return DatatypeFactory.newInstance().newXMLGregorianCalendar(gregory);
    }

    public static void xmlGregorianCalendar2XSDATE(XMLGregorianCalendar xgc) {
        Objects.requireNonNull(xgc, "xgc must not be null");
        xgc.setTime(Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE);
        xgc.setTimezone(Integer.MIN_VALUE);
    }

    public static void xmlGregorianCalendar2XSDATETIME(XMLGregorianCalendar xgc) {
        Objects.requireNonNull(xgc, "xgc must not be null");
        xgc.setMillisecond(Integer.MIN_VALUE);
        xgc.setTimezone(Integer.MIN_VALUE);
    }

    public static void xmlGregorianCalendar2XSTIME(XMLGregorianCalendar xgc) {
        Objects.requireNonNull(xgc, "xgc must not be null");
        xgc.setDay(Integer.MIN_VALUE);
        xgc.setMonth(Integer.MIN_VALUE);
        xgc.setYear(Integer.MIN_VALUE);
        xgc.setMillisecond(Integer.MIN_VALUE);
        xgc.setTimezone(Integer.MIN_VALUE);
    }

    public static DVSConstants.CompressionType getCompressionTypeFromPath(Path path) {
        Objects.requireNonNull(path, "path must not be null");
        String name = path.getFileName().toString();
        return DVSConstants.CompressionType.fromString(name);
    }

    public static String getVSTRFromPath(Path path) {
        Objects.requireNonNull(path, "path must not be null");
        String fileName = path.getName(path.getNameCount() - 1).toString();
        if (fileName.startsWith("rmt")) {
            return fileName.substring(3, 5);
        }
        if (fileName.startsWith("dd")) {
            return fileName.substring(5, 7);
        }
        return null;
    }

    public static String getVSTRFromProperty() {
        return System.getProperty("at.itsv.dvs.VSTR");
    }

    public static String getDefaultXMLPaketFilename(String VSTR) {
        return "dd" + VSTR + ".paketinfo.xml";
    }

    public static String trimExtension(Path path) {
        Objects.requireNonNull(path, "path must not be null");
        String fileName = path.getName(path.getNameCount() - 1).toString();
        return DVSUtils.trimExtension(fileName);
    }

    public static String trimExtension(String path) {
        Objects.requireNonNull(path, "path must not be null");
        path = path.substring(0, path.lastIndexOf(46));
        return path;
    }

    public static boolean isLenientErrorHandling() {
        return Boolean.parseBoolean(System.getProperty("at.itsv.dvs.lenient.error.handling"));
    }

    public static boolean isRunningAsDVS() {
        return Boolean.parseBoolean(System.getProperty("at.itsv.dvs.running.as.dvs"));
    }

    public static File createDVSTempFile() throws IOException {
        File tmpDir = null;
        if (DVSUtils.getTempDirectory() != null) {
            tmpDir = new File(DVSUtils.getTempDirectory());
        }
        File f = File.createTempFile("dvs", null, tmpDir);
        if (!DVSUtils.keepTempFiles()) {
            f.deleteOnExit();
        }
        return f;
    }

    public static String getTempDirectory() {
        return System.getProperty("at.itsv.dvs.tmp.dir");
    }

    public static boolean keepTempFiles() {
        return Boolean.parseBoolean(System.getProperty("at.itsv.dvs.keep.tmpfiles"));
    }

    public static boolean isValidLengthValue(String value, int length) {
        return DVSUtils.isValidLengthValue(value, length, false);
    }

    public static boolean isValidLengthValue(String value, int length, boolean fixLength) {
        if (value == null) {
            return false;
        }
        if (fixLength && value.length() != length) {
            return false;
        }
        return fixLength || value.length() <= length;
    }

    public static String fullURLencode(String s) {
        try {
            s = URLEncoder.encode(s, "UTF-8").replaceAll("\\+", "%20").replaceAll("\\*", "%2A");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return s;
    }

    public static String fullURLdecode(String s) {
        try {
            s = URLDecoder.decode(s, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return s;
    }
}

