/*
 * Decompiled with CFR 0.152.
 */
package at.itsv.dvs.util;

import java.text.FieldPosition;
import java.text.MessageFormat;
import java.util.Hashtable;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class MessageManager {
    private String bundleName;
    private ResourceBundle bundle;
    private static Hashtable<String, MessageManager> managers = new Hashtable();

    private MessageManager(String bundleName) {
        this.bundleName = bundleName;
        this.bundle = ResourceBundle.getBundle(bundleName);
    }

    public String getMessage(String key, Object ... args) {
        try {
            String value = this.bundle.getString(key);
            if (value == null) {
                value = key;
            }
            MessageFormat mf = new MessageFormat(value);
            return mf.format(args, new StringBuffer(), (FieldPosition)null).toString();
        }
        catch (MissingResourceException ex) {
            return null;
        }
    }

    public String getBundleName() {
        return this.bundleName;
    }

    public static MessageManager getMessageManager(String bundleName) {
        MessageManager mgr = managers.get(bundleName);
        if (mgr == null) {
            mgr = new MessageManager(bundleName);
            managers.put(bundleName, mgr);
        }
        return mgr;
    }
}

