/*
 * Decompiled with CFR 0.152.
 */
package at.itsv.dvs.util.refno;

import at.itsv.dvs.model.DVSBestand;
import at.itsv.dvs.util.DVSUtils;
import at.itsv.dvs.util.refno.DVSReferenzNummer;
import at.itsv.dvs.util.refno.DVSReferenzNummerGenerator;
import at.itsv.dvs.util.refno.ReferenzNummerException;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.text.SimpleDateFormat;
import java.util.Date;

public class DefaultReferenzNummerGenerator
implements DVSReferenzNummerGenerator {
    @Override
    public DVSReferenzNummer generateReferenzNummer(DVSBestand bestand) throws ReferenzNummerException {
        try {
            Throwable throwable;
            SimpleDateFormat ddMM = new SimpleDateFormat("ddMM");
            String fileName = ddMM.format(new Date());
            String refDir = System.getProperty("at.itsv.dvs.ref.dir", System.getProperty("user.home"));
            refDir = refDir + (refDir.endsWith(File.separator) ? "" : File.separator) + ".dvs" + File.separator + "ref";
            Path path = Paths.get(refDir, new String[0]);
            Files.createDirectories(path, new FileAttribute[0]);
            DefaultReferenzNummerGenerator.removeOldRefFiles(path, fileName);
            String filePath = refDir + File.separator + fileName;
            path = Paths.get(filePath, new String[0]);
            int referenzNummer = 0;
            if (!Files.exists(path, new LinkOption[0])) {
                Files.createFile(path, new FileAttribute[0]);
            } else {
                throwable = null;
                try (BufferedReader reader = Files.newBufferedReader(path, Charset.defaultCharset());){
                    String s = reader.readLine();
                    if (s != null) {
                        referenzNummer = Integer.parseInt(s);
                    }
                }
                catch (Throwable x2) {
                    throwable = x2;
                    throw x2;
                }
            }
            throwable = null;
            try (BufferedWriter writer = Files.newBufferedWriter(path, Charset.defaultCharset(), new OpenOption[0]);){
                writer.write("" + ++referenzNummer);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            return new DVSReferenzNummer(fileName + DVSUtils.padLeft("" + referenzNummer, 8, '0'));
        }
        catch (IOException | NumberFormatException ex) {
            throw new ReferenzNummerException(ex);
        }
    }

    private static void removeOldRefFiles(Path path, String curFile) throws IOException {
        DirectoryStream<Path> stream = Files.newDirectoryStream(path);
        for (Path entry : stream) {
            if (entry.getFileName().toString().equals(curFile)) continue;
            Files.delete(entry);
        }
    }
}

