package at.itsv.dvs.tool.main;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;

import at.itsv.dvs.common.config.MandantTool;
import at.itsv.dvs.common.config.RegelTool;
import at.itsv.dvs.common.exception.DVSBaseException;
import at.itsv.dvs.common.spring.SpringAdapter;
import at.itsv.dvs.common.utils.StringUtil;

/**
 * Main application to configure DVS relevant DB tables.
 */
public class Tool {


  private enum Table {
    REGEL("REGEL"), MANDANT("MANDANT");

    private String value;

    Table(String value) {
      this.value = value;
    }

    public String getValue() {
      return value;
    }

    public static Table parse(String valueStr) {
      String value = StringUtil.getSafeString(valueStr);
      for (Table table : Table.values()) {
        if (table.value.equals(value)) {
          return table;
        }
      }
      return null;
    }
  }

  private enum Action {
    LIST("-list"), LISTDEFAULT("-listdefault"), INSERT("-insert");

    private String value;

    Action(String value) {
      this.value = value;
    }

    public String getValue() {
      return value;
    }

    public static Action parse(String valueStr) {
      String value = StringUtil.getSafeString(valueStr);
      for (Action action : Action.values()) {
        if (action.value.equals(value)) {
          return action;
        }
      }
      return null;
    }
  }

  /**
   * Main application to configure DVS relevant DB tables.
   * @param args
   * @throws DVSBaseException
   * @throws FileNotFoundException
   */
  public static void main(String[] args) throws DVSBaseException, FileNotFoundException {

    // check arguments
    if (args.length != 3) {
      System.out.println("Anzahl Parameter ungültig: " + getUsage());
      System.exit(1);
    }

    Table table = Table.parse(args[0]);
    if (table == null) {
      System.out.println("Erster Parameter ungültig: " + getUsage());
      System.exit(1);
    }

    Action action = Action.parse(args[1]);
    if (action == null) {
      System.out.println("Zweiter Parameter ungültig: " + getUsage());
      System.exit(1);
    }

    String filename = args[2];

    switch (table) {
      case REGEL:
       RegelTool regelTool = (RegelTool) SpringAdapter.getContext().getBean("regelTool");
        switch (action) {
          case LIST:
            regelTool.list(new FileOutputStream(filename));
            break;
          case LISTDEFAULT:
            regelTool.listdefault(new FileOutputStream(filename));
            break;
          case INSERT:
            regelTool.insert(new FileInputStream(filename), filename);
            break;
          default:
            // Should never be reached
            System.out.println("Zweiter Parameter für ersten Parameter " + table.value + " ungültig: " + getUsage());
            System.exit(1);
        }
        break;
      case MANDANT:
        MandantTool mandantTool = (MandantTool) SpringAdapter.getContext().getBean("mandantTool");
        switch (action) {
          case LIST:
            mandantTool.list(new FileOutputStream(filename));
            break;
          case INSERT:
            mandantTool.insert(new FileInputStream(filename), filename);
            break;
          default:
            System.out.println("Zweiter Parameter für ersten Parameter " + table.value + " ungültig: " + getUsage());
            System.exit(1);
        }
        break;
    }

  }

  private static String getUsage() {

    return "Usage:\nTool (REGEL|MANDANT) (-list|-listdefault|-insert) <file>";
  }

}
