/*
 * Decompiled with CFR 0.152.
 */
package at.itsv.dvs.common.config;

import at.itsv.dvs.common.config.CheckParam;
import at.itsv.dvs.common.dao.IBenutzerDao;
import at.itsv.dvs.common.dao.IMandantDao;
import at.itsv.dvs.common.dao.IProzessDao;
import at.itsv.dvs.common.dao.IRolleDao;
import at.itsv.dvs.common.entity.Benutzer;
import at.itsv.dvs.common.entity.Mandant;
import at.itsv.dvs.common.entity.Rolle;
import at.itsv.dvs.common.events.Event;
import at.itsv.dvs.common.events.EventCodeEnum;
import at.itsv.dvs.common.exception.DVSBaseException;
import at.itsv.dvs.common.exception.NonexistentEntityException;
import at.itsv.dvs.common.utils.CsvUtils;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.util.Date;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
@Qualifier(value="mandantTool")
public class MandantTool {
    protected final Logger _log = Logger.getLogger(this.getClass());
    private static final CheckParam[] CHECK_PARAMS = new CheckParam[]{new CheckParam("Mandant", -1, 2, false), new CheckParam("Bezeichnung Mandant", 0, 100, false), new CheckParam("DDS User", 0, 50, false), new CheckParam("DDS Passwort", 0, 50, false), new CheckParam("Mandant aktive?", 0, null, true), new CheckParam("Login Benutzer", null, 50, false), new CheckParam("Passwort Benutzer", 5, 50, false), new CheckParam("Email-Adresse", null, 50, false), new CheckParam("Benutzer aktiv?", 5, null, true), new CheckParam("Vorname", null, 50, false), new CheckParam("Nachname", null, 50, false), new CheckParam("Rolle", null, 50, false)};
    private OutputStream _os;
    BufferedWriter _writer;
    BufferedReader _reader;
    @Autowired
    private IBenutzerDao _benutzerDao;
    @Autowired
    private IMandantDao _mandantDao;
    @Autowired
    private IRolleDao _rolleDao;
    @Autowired
    private IProzessDao _prozessDao;
    List<Mandant> _mandantListExisting;
    List<Benutzer> _benutzerListExisting;
    List<Rolle> _rolleListExisting;
    boolean _success = true;
    private String _filename;

    public void list(OutputStream os) throws DVSBaseException {
        this._os = os;
        List mandantList = this._mandantDao.select();
        try {
            this.createWriter();
            for (Mandant mandant : mandantList) {
                this._mandantDao.loadBenutzers(mandant);
                Set<Benutzer> benutzerSet = mandant.getBenutzers();
                if (benutzerSet.isEmpty()) {
                    this.writeEntry(mandant, null, null);
                    continue;
                }
                for (Benutzer benutzer : benutzerSet) {
                    this._benutzerDao.loadRolles(benutzer);
                    Set<Rolle> rolleSet = benutzer.getRolles();
                    if (rolleSet.isEmpty()) {
                        this.writeEntry(mandant, benutzer, null);
                        continue;
                    }
                    for (Rolle rolle : rolleSet) {
                        this.writeEntry(mandant, benutzer, rolle);
                    }
                }
            }
        }
        catch (IOException e) {
            this._log.error("error writing data", e);
            throw new DVSBaseException(new Event(EventCodeEnum.AL01, e.getMessage()));
        }
        finally {
            CsvUtils.closeWriter(this._writer);
        }
    }

    private void writeEntry(Mandant mandant, Benutzer benutzer, Rolle rolle) throws IOException {
        this._log.debug("write entry for mandant <" + mandant + "> benutzer <" + benutzer + "> rolle <" + rolle + ">.");
        String[] entry = new String[12];
        for (int i = 0; i < 12; ++i) {
            entry[0] = null;
        }
        if (mandant != null) {
            entry[0] = mandant.getMandantId();
            entry[1] = mandant.getBezeichnung();
            entry[2] = mandant.getDdsUser();
            entry[3] = mandant.getDdsPassword();
            entry[4] = Boolean.toString(mandant.isActive());
        }
        if (benutzer != null) {
            entry[5] = benutzer.getLogin();
            entry[6] = benutzer.getPassword();
            entry[7] = benutzer.getEmail();
            entry[8] = Boolean.toString(benutzer.isActive());
            entry[9] = benutzer.getFirstName();
            entry[10] = benutzer.getLastName();
        }
        if (rolle != null) {
            entry[11] = rolle.getRolleName();
        }
        CsvUtils.writeLine(this._writer, entry);
    }

    private void createWriter() throws DVSBaseException {
        try {
            this._writer = new BufferedWriter(new OutputStreamWriter(this._os, "UTF-8"), 59);
            String[] header = new String[CHECK_PARAMS.length];
            for (int i = 0; i < CHECK_PARAMS.length; ++i) {
                header[i] = CHECK_PARAMS[i].getDescription();
            }
            CsvUtils.writeLine(this._writer, header);
            this._writer.flush();
        }
        catch (UnsupportedEncodingException e) {
            new RuntimeException(e);
        }
        catch (IOException e) {
            this._log.error("error writing data", e);
            throw new DVSBaseException(new Event(EventCodeEnum.AL01, e.getMessage()));
        }
    }

    @Transactional(rollbackFor={DVSBaseException.class})
    public void insert(InputStream is, String fileName) throws DVSBaseException {
        this.initializeForReading(is, fileName);
        try {
            String[] entry;
            int line = 1;
            while ((entry = CsvUtils.readLine(this._reader)) != null) {
                if (line == 1) {
                    this._log.info("skip first line");
                } else if (entry.length == 0) {
                    this._log.info("line " + line + " is empty or comment");
                } else if (!this.checkLine(entry, Integer.toString(line))) {
                    this._success = false;
                } else {
                    Mandant dbMandant = this.setMandant(entry);
                    this.setBenutzerAndRolle(entry, dbMandant);
                }
                ++line;
            }
            if (this._success) {
                this.deleteEntries();
            }
        }
        catch (IOException e) {
            this._log.error("error reading file", e);
            throw new DVSBaseException(new Event(EventCodeEnum.DT01, this._filename));
        }
        finally {
            CsvUtils.closeReader(this._reader);
        }
        if (!this._success) {
            throw new DVSBaseException(new Event(EventCodeEnum.BM07, this._filename));
        }
        new Event(EventCodeEnum.BM06, this._filename).writeProtokoll(null, null);
    }

    private void deleteEntries() {
        for (Rolle delRolle : this._rolleListExisting) {
            try {
                this._log.info("delete Rolle " + delRolle);
                this._rolleDao.delete(delRolle.getRolleId());
            }
            catch (NonexistentEntityException e) {
                throw new RuntimeException(e);
            }
        }
        for (Benutzer delBenutzer : this._benutzerListExisting) {
            try {
                this._log.info("delete Benutzer " + delBenutzer);
                this._benutzerDao.delete(delBenutzer.getBenutzerId());
            }
            catch (NonexistentEntityException e) {
                throw new RuntimeException(e);
            }
        }
        for (Mandant delMandant : this._mandantListExisting) {
            if (!this._prozessDao.selectByMandantId(delMandant.getMandantId()).isEmpty()) {
                new Event(EventCodeEnum.BM08, delMandant.getMandantId());
                this._success = false;
                continue;
            }
            try {
                this._log.info("delete mandant " + delMandant);
                this._mandantDao.delete(delMandant.getMandantId());
            }
            catch (NonexistentEntityException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private void setBenutzerAndRolle(String[] entry, Mandant dbMandant) {
        Benutzer csvBenutzer = null;
        if (entry[5] != null) {
            csvBenutzer = new Benutzer();
            csvBenutzer.setMandant(dbMandant);
            csvBenutzer.setLogin(entry[5]);
            csvBenutzer.setPassword(entry[6]);
            csvBenutzer.setEmail(entry[7]);
            csvBenutzer.setActive(Boolean.parseBoolean(entry[8]));
            csvBenutzer.setFirstName(entry[9]);
            csvBenutzer.setLastName(entry[10]);
            Benutzer dbBenutzer = this._benutzerDao.selectByLoginAndMandantId(csvBenutzer.getLogin(), csvBenutzer.getMandant().getMandantId());
            if (dbBenutzer == null) {
                dbBenutzer = csvBenutzer;
                dbBenutzer.setLastChange(new Date());
                this._benutzerDao.insert(dbBenutzer);
                this._log.info("insert new benutzer: " + dbBenutzer);
            } else {
                this._benutzerListExisting.remove(dbBenutzer);
                if (StringUtils.equals(dbBenutzer.getEmail(), csvBenutzer.getEmail()) && StringUtils.equals(dbBenutzer.getPassword(), csvBenutzer.getPassword()) && StringUtils.equals(dbBenutzer.getFirstName(), csvBenutzer.getFirstName()) && StringUtils.equals(dbBenutzer.getLastName(), csvBenutzer.getLastName()) && dbBenutzer.isActive() == csvBenutzer.isActive()) {
                    this._log.info("nothing changed for benutzer: " + dbBenutzer);
                } else {
                    dbBenutzer.setEmail(csvBenutzer.getEmail());
                    dbBenutzer.setPassword(csvBenutzer.getPassword());
                    dbBenutzer.setFirstName(csvBenutzer.getFirstName());
                    dbBenutzer.setLastName(csvBenutzer.getLastName());
                    dbBenutzer.setActive(csvBenutzer.isActive());
                    dbBenutzer.setLastChange(new Date());
                    this._benutzerDao.update(dbBenutzer);
                    this._log.info("update benutzer: " + dbBenutzer);
                }
            }
            if (entry[11] != null) {
                Rolle csvRolle = new Rolle();
                csvRolle.setLogin(entry[5]);
                csvRolle.setRolleName(entry[11]);
                Rolle dbRolle = this._rolleDao.selectByLoginAndName(csvRolle.getLogin(), csvRolle.getRolleName());
                if (dbRolle == null) {
                    dbRolle = csvRolle;
                    this._rolleDao.insert(dbRolle);
                    this._log.info("insert new rolle: " + dbRolle);
                } else {
                    this._rolleListExisting.remove(dbRolle);
                    this._log.info("nothing changed for rolle: " + dbRolle);
                }
            }
        }
    }

    private Mandant setMandant(String[] entry) {
        Mandant csvMandant = new Mandant();
        csvMandant.setMandantId(entry[0]);
        csvMandant.setBezeichnung(entry[1]);
        csvMandant.setDdsUser(entry[2]);
        csvMandant.setDdsPassword(entry[3]);
        csvMandant.setActive(Boolean.parseBoolean(entry[4]));
        Mandant dbMandant = this._mandantDao.select(csvMandant.getMandantId());
        if (dbMandant == null) {
            dbMandant = csvMandant;
            dbMandant.setLastChange(new Date());
            this._mandantDao.insert(dbMandant);
            this._log.info("insert new mandant: " + dbMandant);
        } else {
            this._mandantListExisting.remove(dbMandant);
            if (StringUtils.equals(dbMandant.getBezeichnung(), csvMandant.getBezeichnung()) && StringUtils.equals(dbMandant.getDdsUser(), csvMandant.getDdsUser()) && StringUtils.equals(dbMandant.getDdsPassword(), csvMandant.getDdsPassword()) && dbMandant.isActive() == csvMandant.isActive()) {
                this._log.info("nothing changed for mandant: " + dbMandant);
            } else {
                dbMandant.setBezeichnung(csvMandant.getBezeichnung());
                dbMandant.setDdsUser(csvMandant.getDdsUser());
                dbMandant.setDdsPassword(csvMandant.getDdsPassword());
                dbMandant.setActive(csvMandant.isActive());
                dbMandant.setLastChange(new Date());
                this._mandantDao.update(dbMandant);
                this._log.info("update mandant: " + dbMandant);
            }
        }
        return dbMandant;
    }

    private void initializeForReading(InputStream is, String fileName) {
        this._mandantListExisting = this._mandantDao.select();
        this._benutzerListExisting = this._benutzerDao.select();
        this._rolleListExisting = this._rolleDao.select();
        this._success = true;
        this._filename = fileName;
        try {
            this._reader = new BufferedReader(new InputStreamReader(is, "UTF-8"), 59);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    private boolean checkLine(String[] entry, String lineStr) {
        if (entry.length != CHECK_PARAMS.length) {
            new Event(EventCodeEnum.BM01, this._filename, lineStr);
            return false;
        }
        if (entry[0] != null && entry[0].length() != 2) {
            new Event(EventCodeEnum.BM02, this._filename, lineStr, entry[0]);
            return false;
        }
        for (int i = 0; i < CHECK_PARAMS.length; ++i) {
            if (CHECK_PARAMS[i].getMandatory() != null && entry[i] == null && entry[CHECK_PARAMS[i].getMandatory()] != null) {
                new Event(EventCodeEnum.BM03, this._filename, lineStr, Integer.toString(i), CHECK_PARAMS[i].getDescription());
                return false;
            }
            if (CHECK_PARAMS[i].getMaxLength() != null && entry[i] != null && entry[i].length() > CHECK_PARAMS[i].getMaxLength()) {
                new Event(EventCodeEnum.BM04, this._filename, lineStr, Integer.toString(i), CHECK_PARAMS[i].getDescription());
                return false;
            }
            if (!CHECK_PARAMS[i].checkBoolean() || entry[i] == null || entry[i].equalsIgnoreCase("true") || entry[i].equalsIgnoreCase("false")) continue;
            new Event(EventCodeEnum.BM05, this._filename, lineStr, Integer.toString(i), CHECK_PARAMS[i].getDescription());
            return false;
        }
        return true;
    }
}

