/*
 * Decompiled with CFR 0.152.
 */
package at.itsv.dvs.common.config;

import at.itsv.dvs.common.dao.IRegelMandantDao;
import at.itsv.dvs.common.dao.ISystemParameterDao;
import at.itsv.dvs.common.entity.RegelMandant;
import at.itsv.dvs.common.entity.SystemParameter;
import at.itsv.dvs.common.spring.SpringAdapter;
import at.itsv.dvs.common.utils.DateHelper;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.apache.log4j.Logger;

public enum RegelEnum {
    ALL_FTP_SERVER("all.ftp.server", null, ".*", true, 1),
    ALL_FTP_PORT("all.ftp.port", "21", "\\d*", false, 1),
    ALL_VERZ_DVS("all.verz.dvs", "/DVS", ".*", false, 1),
    ALL_VERZ_TEMP("all.verz.temp", "%VERZ_DVS%/vstr%MANDANT%/temp", ".*", false, 1),
    ALL_MAX_LAUFZEIT_MINUTEN("all.max.laufzeit.minuten", "60", "\\d*", false, 1),
    IM_VERZ_NEU_SARTPAKET("im.verz.neu.sartpaket", "%VERZ_DVS%/vstr%MANDANT%/Traeger/SART/vonTraeger/neu/SART-Paket", ".*", false, 1),
    IM_VERZ_ARCHIV_SARTPAKET("im.verz.archiv.sartpaket", "%VERZ_DVS%/vstr%MANDANT%/Traeger/SART/vonTraeger/verarbeitet/%START_DATUM:yyyyMMdd_HHmmss%/SART-Paket", ".*", false, 1),
    IM_VERZ_FEHLER_SARTPAKET("im.verz.fehler.sartpaket", "%VERZ_DVS%/vstr%MANDANT%/Traeger/SART/vonTraeger/fehler/%START_DATUM:yyyyMMdd_HHmmss%/SART-Paket", ".*", false, 1),
    IM_VERZ_NEU_SARTSAMMELBESTAND("im.verz.neu.sartsammelbestand", "%VERZ_DVS%/vstr%MANDANT%/Traeger/SART/vonTraeger/neu/SART-Sammelbestand", ".*", false, 1),
    IM_VERZ_ARCHIV_SARTSAMMELBESTAND("im.verz.archiv.sartsammelbestand", "%VERZ_DVS%/vstr%MANDANT%/Traeger/SART/vonTraeger/verarbeitet/%START_DATUM:yyyyMMdd_HHmmss%/SART-Sammelbestand", ".*", false, 1),
    IM_VERZ_FEHLER_SARTSAMMELBESTAND("im.verz.fehler.sartsammelbestand", "%VERZ_DVS%/vstr%MANDANT%/Traeger/SART/vonTraeger/fehler/%START_DATUM:yyyyMMdd_HHmmss%/SART-Sammelbestand", ".*", false, 1),
    IM_VERZ_NEU_SARTEINZELBESTAND("im.verz.neu.sarteinzelbestand", "%VERZ_DVS%/vstr%MANDANT%/Traeger/SART/vonTraeger/neu/SART-Einzelbestand", ".*", false, 1),
    IM_VERZ_ARCHIV_SARTEINZELBESTAND("im.verz.archiv.sarteinzelbestand", "%VERZ_DVS%/vstr%MANDANT%/Traeger/SART/vonTraeger/verarbeitet/%START_DATUM:yyyyMMdd_HHmmss%/SART-Einzelbestand", ".*", false, 1),
    IM_VERZ_FEHLER_SARTEINZELBESTAND("im.verz.fehler.sarteinzellbestand", "%VERZ_DVS%/vstr%MANDANT%/Traeger/SART/vonTraeger/fehler/%START_DATUM:yyyyMMdd_HHmmss%/SART-Einzelbestand", ".*", false, 1),
    IM_VERZ_NEU_XMLARCHIV("im.verz.neu.xmlarchiv", "%VERZ_DVS%/vstr%MANDANT%/Traeger/XML/vonTraeger/neu/XML-Archiv", ".*", false, 1),
    IM_VERZ_ARCHIV_XMLARCHIV("im.verz.archiv.xmlarchiv", "%VERZ_DVS%/vstr%MANDANT%/Traeger/XML/vonTraeger/verarbeitet/%START_DATUM:yyyyMMdd_HHmmss%/XML-Archiv", ".*", false, 1),
    IM_VERZ_FEHLER_XMLARCHIV("im.verz.fehler.xmlarchiv", "%VERZ_DVS%/vstr%MANDANT%/Traeger/XML/vonTraeger/fehler/%START_DATUM:yyyyMMdd_HHmmss%/XML-Archiv", ".*", false, 1),
    IM_VERZ_NEU_XMLEINZELBESTAND("im.verz.neu.xmleinzelbestand", "%VERZ_DVS%/vstr%MANDANT%/Traeger/XML/vonTraeger/neu/XML-Einzelbestand", ".*", false, 1),
    IM_VERZ_ARCHIV_XMLEINZELBESTAND("im.verz.archiv.xmleinzelbestand", "%VERZ_DVS%/vstr%MANDANT%/Traeger/XML/vonTraeger/verarbeitet/%START_DATUM:yyyyMMdd_HHmmss%/XML-Einzelbestand", ".*", false, 1),
    IM_VERZ_FEHLER_XMLEINZELBESTAND("im.verz.fehler.xmleinzelbestand", "%VERZ_DVS%/vstr%MANDANT%/Traeger/XML/vonTraeger/fehler/%START_DATUM:yyyyMMdd_HHmmss%/XML-Einzelbestand", ".*", false, 1),
    IM_SAKZ_SARTEINZELBESTAND("im.sakz.sarteinzelbestand", "N", "[J|N]", false, 3),
    IM_CODEPAGE_SARTEINZELBESTAND("im.codepage.sarteinzelbestand", "CP819", "CP819|CP850|UTF/-8", false, 3),
    IM_PROJ_LIST_FILENAME_SARTEINZELBESTAND("im.proj.list.filename.sarteinzelbestand", "J", "[J|N]", false, 3),
    IM_PROJ_LIST_FILENAME_XMLEINZELBESTAND("im.proj.list.filename.xmleinzelbestand", "J", "[J|N]", false, 3),
    IM_IDENTIFIKATOR_XMLEINZELBESTAND("im.identifikator.xmleinzelbestand", " ", ".*", true, 3),
    ED_TESTMODUS_EINZELBESTAND("ed.testmodus.einzelbestand", "", "[S|T]", true, 3),
    ED_AENR_EINZELBESTAND("ed.aenr.einzelbestand", null, ".*", true, 3),
    ED_EBNR_EINZELBESTAND("ed.ebnr.einzelbestand", null, ".*", true, 3),
    ED_EART_EINZELBESTAND("ed.eart.einzelbestand", null, ".*", true, 3),
    ED_ZVOB_EINZELBESTAND("ed.zvob.einzelbestand", "J", "[J|N]", false, 3),
    ED_INHALT_XMLEINZELBESTAND("ed.inhalt.xmleinzelbestand", null, ".*", true, 3),
    ED_ABOKEY_XMLEINZELBESTAND("ed.abokey.xmleinzelbestand", null, ".*", true, 3),
    ED_ZUSAETZLINFO_XMLEINZELBESTAND("ed.zusaetzlinfo.xmleinzelbestand", null, ".*", true, 3),
    ED_VERZ_NEU("ed.verz.neu", "%VERZ_DVS%/vstr%MANDANT%/DDS/nachDDS", ".*", false, 1),
    ED_VERZ_FTP("ed.verz.ftp", "ddein", ".*", false, 1),
    ED_VERZ_ARCHIV("ed.verz.archiv", "%VERZ_DVS%/vstr%MANDANT%/DDS/nachDDS/uebertragen", ".*", false, 1),
    ED_PAKETNAME_SART("ed.paketname.sart", "ddein%MANDANT%.%START_DATUM:yyyyMMdd.HHmmss%", ".*", false, 3),
    ED_PAKETNAME_XML("ed.paketname.xml", "ddein%MANDANT%.%START_DATUM:yyyyMMdd.HHmmss%.xml.zip", ".*", false, 3),
    ID_VERZ_NEU("id.verz.neu", "%VERZ_DVS%/vstr%MANDANT%/DDS/vonDDS", ".*", false, 1),
    ID_VERZ_FTP("id.verz.ftp", "ddaus", ".*", false, 1),
    ID_VERZ_ARCHIV("id.verz.archiv", "%VERZ_DVS%/vstr%MANDANT%/DDS/vonDDS/verarbeitet", ".*", false, 1),
    ID_VERZ_FEHLER("id.verz.fehler", "%VERZ_DVS%/vstr%MANDANT%/DDS/vonDDS/fehler", ".*", false, 1),
    EM_VERZ_NEU_SARTPAKET("em.verz.neu.sartpaket", "%VERZ_DVS%/vstr%MANDANT%/Traeger/SART/nachTraeger/%START_DATUM:yyyyMMdd_HHmmss%/SART-Paket", ".*", false, 1),
    EM_VERZ_NEU_XMLARCHIV("em.verz.neu.xmlarchiv", "%VERZ_DVS%/vstr%MANDANT%/Traeger/XML/nachTraeger/%START_DATUM:yyyyMMdd_HHmmss%/XML-Archiv", ".*", false, 1),
    EM_VERZ_NEU_SARTSAMMELBESTAND("em.verz.neu.sartsammelbestand", "%VERZ_DVS%/vstr%MANDANT%/Traeger/SART/nachTraeger/%START_DATUM:yyyyMMdd_HHmmss%/SART-Sammelbestand", ".*", false, 1),
    EM_VERZ_NEU_SARTEINZELBESTAND("em.verz.neu.sarteinzelbestand", "%VERZ_DVS%/vstr%MANDANT%/Traeger/SART/nachTraeger/%START_DATUM:yyyyMMdd_HHmmss%/SART-Einzelbestand/", ".*", false, 3),
    EM_VERZ_NEU_XMLEINZELBESTAND("em.verz.neu.xmleinzelbestand", "%VERZ_DVS%/vstr%MANDANT%/Traeger/XML/nachTraeger/%START_DATUM:yyyyMMdd_HHmmss%/XML-Einzelbestand/", ".*", false, 3),
    EM_FORMAT_SART("em.format.sart", "SE", "SE|SS|SP", false, 3),
    EM_FORMAT_XML("em.format.xml", "XE", "XE|XA", false, 3),
    EM_DATEINAME_SARTPAKET("em.dateiname.sartpaket", "ddaus%MANDANT%.%START_DATUM:yyyyMMdd.HHmmss%", ".*", false, 3),
    EM_DATEINAME_SARTSAMMELBESTAND("em.dateiname.sartsammelbestand", "sammel%MANDANT%.%START_DATUM:yyyyMMdd.HHmmss%", ".*", false, 3),
    EM_DATEINAME_SARTEINZELBESTAND("em.dateiname.sarteinzelbestand", "bestand.%AKT_DATUM:yyyyMMdd.HHmmss%", ".*", false, 3),
    EM_DATEINAME_XMLARCHIV("em.dateiname.xmlarchiv", "ddaus%MANDANT%.%START_DATUM:yyyyMMdd.HHmmss%.xml.zip", ".*", false, 3),
    EM_DATEINAME_XMLEINZELBESTAND("em.dateiname.xmleinzelbestand", "bestandxml.%AKT_DATUM:yyyyMMdd.HHmmss%", ".*", false, 3),
    EM_SAKZ_SARTEINZELBESTAND("em.sakz.sarteinzelbestand", "N", "[J|N]", false, 3),
    EM_CODEPAGE_SARTEINZELBESTAND("em.codepage.sarteinzelbestand", "CP819", "CP819|CP850|UTF/-8", false, 3),
    EM_PROJ_LIST_FILENAME_SARTEINZELBESTAND("em.proj.list.filename.sarteinzelbestand", "J", "[J|N]", false, 3),
    EM_PROJ_LIST_FILENAME_XMLEINZELBESTAND("em.proj.list.filename.xmleinzelbestand", "J", "[J|N]", false, 3),
    EM_ZIPFORMAT_XMLEINZELBETAND("em.zipformat.xmleinzelbestand", null, "zip|tar\\.gz", true, 3),
    AR_FRIST_TAGE("ar.frist.tage", "30", "\\d*", false, 0),
    AR_VERZ_ARCHIV("ar.verz.archiv", "%VERZ_DVS%/archiv_bestaende/%START_DATUM:yyyyMMdd%", ".*", false, 0);

    private static final String REPLACE_VERZ_DVS = "%VERZ_DVS%";
    private static final String REPLACE_MANDANT = "%MANDANT%";
    private static final String REPLACE_PROJ = "%PROJ%";
    private static final String REPLACE_LIST = "%LIST%";
    private static final String REPLACE_PARTNER = "%PARTNER%";
    private static final String REPLACE_LFDNR = "%LFDNR:";
    private static final String REPLACE_LFDNR_KEY = "%LFDNR_";
    private static final String REPLACE_START_DATUM = "%START_DATUM:";
    private static final String REPLACE_AKT_DATUM = "%AKT_DATUM:";
    private Logger LOGGER = Logger.getLogger(((Object)((Object)this)).getClass());
    private final String _regelKey;
    private final String _defaultValue;
    private final String _regex;
    private final boolean _nullable;
    private final int _searchParameter;
    private static Date _lastDate;
    private static Map<String, Integer> _lfdnrMap;
    private ISystemParameterDao _systemParameterDao = (ISystemParameterDao)SpringAdapter.getContext().getBean("systemParameterDao");

    public static RegelEnum parse(String value) {
        for (RegelEnum regelEnum : RegelEnum.values()) {
            if (!regelEnum._regelKey.equals(value)) continue;
            return regelEnum;
        }
        return null;
    }

    private RegelEnum(String configName, String defaultValue, String regex, boolean nullable, int searchParameter) {
        this._regelKey = configName;
        this._defaultValue = defaultValue;
        this._regex = regex;
        this._nullable = nullable;
        this._searchParameter = searchParameter;
    }

    public String getRegelKey() {
        return this._regelKey;
    }

    public String getRegex() {
        return this._regex;
    }

    public String getDefaultValue() {
        return this._defaultValue;
    }

    public boolean isNullable() {
        return this._nullable;
    }

    public int getSearchParameter() {
        return this._searchParameter;
    }

    public boolean getValueAsBoolean(String mandant, String proj, String list) {
        String value = this.getValue(mandant, proj, list);
        return "J".equalsIgnoreCase(value);
    }

    public String getValueWithReplacement(String mandant, String proj, String list, String partner, Date date) {
        String value = this.getValue(mandant, proj, list);
        return this.replace(value, mandant, proj, list, partner, date);
    }

    public long getValueAsLong(String mandant, String proj, String list) {
        String value = this.getValue(mandant, proj, list);
        if (value == null) {
            return 0L;
        }
        return Long.parseLong(value);
    }

    public String getValue(String mandant, String proj, String list) {
        IRegelMandantDao regelMandantDao = (IRegelMandantDao)SpringAdapter.getContext().getBean("regelMandantDao");
        String value = this._defaultValue;
        RegelMandant regelMandant = null;
        if (mandant != null && proj != null && list != null) {
            regelMandant = regelMandantDao.selectValueByRegelMandantProjectList(this._regelKey, mandant, proj, list);
        }
        if (regelMandant == null && mandant != null && proj != null) {
            regelMandant = regelMandantDao.selectValueByRegelMandantProjectList(this._regelKey, mandant, proj, null);
        }
        if (regelMandant == null && mandant != null && list != null) {
            regelMandant = regelMandantDao.selectValueByRegelMandantProjectList(this._regelKey, mandant, null, list);
        }
        if (regelMandant == null && proj != null && list != null) {
            regelMandant = regelMandantDao.selectValueByRegelMandantProjectList(this._regelKey, null, proj, list);
        }
        if (regelMandant == null && proj != null) {
            regelMandant = regelMandantDao.selectValueByRegelMandantProjectList(this._regelKey, null, proj, null);
        }
        if (regelMandant == null && list != null) {
            regelMandant = regelMandantDao.selectValueByRegelMandantProjectList(this._regelKey, null, null, list);
        }
        if (regelMandant == null && mandant != null) {
            regelMandant = regelMandantDao.selectValueByRegelMandantProjectList(this._regelKey, mandant, null, null);
        }
        if (regelMandant == null) {
            regelMandant = regelMandantDao.selectValueByRegelMandantProjectList(this._regelKey, null, null, null);
        }
        if (regelMandant != null) {
            value = regelMandant.getValue();
        }
        return value;
    }

    private String replace(String value, String mandant, String proj, String list, String partner, Date processDate) {
        if (value == null) {
            return null;
        }
        this.LOGGER.debug("before replacement: " + value);
        if (value.contains(REPLACE_VERZ_DVS)) {
            value = value.replaceAll(REPLACE_VERZ_DVS, ALL_VERZ_DVS.getValue(mandant, proj, list));
        }
        if (mandant != null && value.contains(REPLACE_MANDANT)) {
            value = value.replaceAll(REPLACE_MANDANT, mandant);
        }
        if (proj != null && value.contains(REPLACE_PROJ)) {
            value = value.replaceAll(REPLACE_PROJ, proj);
        }
        if (list != null && value.contains(REPLACE_LIST)) {
            value = value.replaceAll(REPLACE_LIST, list);
        }
        if (partner != null && value.contains(REPLACE_PARTNER)) {
            value = value.replaceAll(REPLACE_PARTNER, partner);
        }
        if (processDate != null && value.contains(REPLACE_START_DATUM)) {
            value = DateHelper.replaceDateInString(REPLACE_START_DATUM, value, processDate);
        }
        if (value.contains(REPLACE_AKT_DATUM)) {
            value = this.replaceActDate(value);
        }
        if (value.contains(REPLACE_LFDNR)) {
            value = this.replaceLfdnr(value);
        }
        if (value.contains(REPLACE_LFDNR_KEY)) {
            value = this.replaceLfdnrKey(value);
        }
        this.LOGGER.debug("after replacement: " + value);
        return value;
    }

    private synchronized String replaceLfdnr(String value) {
        int endIndex;
        int startIndex;
        Integer lfdnr = _lfdnrMap.get(value);
        if (lfdnr == null) {
            lfdnr = 1;
        } else {
            Integer n = lfdnr;
            Integer n2 = lfdnr = Integer.valueOf(lfdnr + 1);
        }
        _lfdnrMap.put(value, lfdnr);
        String placeHolder = REPLACE_LFDNR;
        while ((startIndex = value.indexOf(placeHolder)) != -1 && (endIndex = value.indexOf("%", startIndex + placeHolder.length())) != -1) {
            String format = value.substring(startIndex + placeHolder.length(), endIndex);
            String lfdnrString = String.format("%0" + format + "d", lfdnr);
            value = value.replaceAll(value.substring(startIndex, endIndex + 1), lfdnrString);
        }
        return value;
    }

    private synchronized String replaceLfdnrKey(String value) {
        int endIndexKey;
        int startIndex;
        HashMap<String, Integer> lfdnrMap = new HashMap<String, Integer>();
        String placeHolder = REPLACE_LFDNR_KEY;
        while ((startIndex = value.indexOf(placeHolder)) != -1 && (endIndexKey = value.indexOf(":", startIndex + placeHolder.length())) != -1) {
            Integer lfdnr;
            String key = value.substring(startIndex + 1, endIndexKey);
            if (!lfdnrMap.containsKey(key)) {
                SystemParameter sysParam = this._systemParameterDao.findByKey(key);
                if (sysParam == null) {
                    sysParam = new SystemParameter();
                    lfdnr = 1;
                    sysParam.setKey(key);
                } else {
                    lfdnr = Integer.parseInt(sysParam.getValue()) + 1;
                }
                lfdnrMap.put(key, lfdnr);
                sysParam.setValue(lfdnr.toString());
                sysParam.setLastChange(new Date());
                this._systemParameterDao.update(sysParam);
            } else {
                lfdnr = (Integer)lfdnrMap.get(key);
            }
            int endIndexFormat = value.indexOf("%", endIndexKey);
            if (endIndexFormat == -1) break;
            String format = value.substring(endIndexKey + 1, endIndexFormat);
            String lfdnrString = String.format("%0" + format + "d", lfdnr);
            value = value.replaceAll(value.substring(startIndex, endIndexFormat + 1), lfdnrString);
        }
        return value;
    }

    private synchronized String replaceActDate(String value) {
        Date actDate = new Date();
        long diff = actDate.getTime() - _lastDate.getTime();
        if (diff < 2000L) {
            actDate = new Date(_lastDate.getTime() + 1000L);
        }
        _lastDate = actDate;
        value = DateHelper.replaceDateInString(REPLACE_AKT_DATUM, value, actDate);
        return value;
    }

    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).append(this._regelKey).toString();
    }

    static {
        _lastDate = new Date();
        _lfdnrMap = new HashMap<String, Integer>();
    }
}

