/*
 * Decompiled with CFR 0.152.
 */
package at.itsv.dvs.common.config;

import at.itsv.dvs.common.config.RegelEnum;
import at.itsv.dvs.common.dao.IMandantDao;
import at.itsv.dvs.common.dao.IRegelDao;
import at.itsv.dvs.common.dao.IRegelMandantDao;
import at.itsv.dvs.common.entity.Mandant;
import at.itsv.dvs.common.entity.Regel;
import at.itsv.dvs.common.entity.RegelMandant;
import at.itsv.dvs.common.events.Event;
import at.itsv.dvs.common.events.EventCodeEnum;
import at.itsv.dvs.common.exception.DVSBaseException;
import at.itsv.dvs.common.exception.NonexistentEntityException;
import at.itsv.dvs.common.utils.CsvUtils;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
@Qualifier(value="regelTool")
public class RegelTool {
    protected final Logger _log = Logger.getLogger(this.getClass());
    private String _fileName;
    private InputStream _is;
    private OutputStream _os;
    BufferedWriter _writer;
    BufferedReader _reader;
    @Autowired
    private IRegelMandantDao _regelmandantDao;
    @Autowired
    private IRegelDao _regelDao;
    @Autowired
    private IMandantDao _mandantDao;

    public void list(OutputStream os) throws DVSBaseException {
        this._os = os;
        List regelMandantList = this._regelmandantDao.select();
        try {
            this.createWriter();
            for (RegelMandant regelMandant : regelMandantList) {
                String[] entry = new String[5];
                Regel regel = (Regel)this._regelDao.select(regelMandant.getRegel().getRegelId());
                entry[0] = regel.getKey();
                if (regelMandant.getMandant() != null) {
                    entry[1] = regelMandant.getMandant().getMandantId();
                }
                entry[2] = regelMandant.getProj();
                entry[3] = regelMandant.getList();
                entry[4] = regelMandant.getValue();
                CsvUtils.writeLine(this._writer, entry);
            }
        }
        catch (IOException e) {
            this._log.error("error writing data", e);
            throw new DVSBaseException(new Event(EventCodeEnum.AL01, e.getMessage()));
        }
        finally {
            this.closeWriter();
        }
    }

    private void closeWriter() {
        try {
            if (this._writer != null) {
                this._writer.close();
            }
        }
        catch (IOException e) {
            this._log.debug("ignore exception", e);
        }
    }

    private void createWriter() throws DVSBaseException {
        try {
            this._writer = new BufferedWriter(new OutputStreamWriter(this._os, "UTF-8"), 59);
            String[] header = new String[]{"Regel", "Mandant", "Projektkennzeichen", "Listkennzeichen", "Wert"};
            CsvUtils.writeLine(this._writer, header);
        }
        catch (UnsupportedEncodingException e) {
            new RuntimeException(e);
        }
        catch (IOException e) {
            this._log.error("error writing data", e);
            throw new DVSBaseException(new Event(EventCodeEnum.AL01, e.getMessage()));
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Transactional(rollbackFor={DVSBaseException.class})
    public void insert(InputStream is, String fileName) throws DVSBaseException {
        boolean success;
        block18: {
            this._is = is;
            this._fileName = fileName;
            List listExisting = this._regelmandantDao.select();
            success = true;
            try {
                this._reader = new BufferedReader(new InputStreamReader(this._is, "UTF-8"), 59);
                int line = 1;
                while (true) {
                    block19: {
                        boolean changed;
                        boolean update;
                        RegelMandant dbEntry;
                        Object[] entry;
                        block25: {
                            block23: {
                                Mandant mandant;
                                block24: {
                                    block22: {
                                        block21: {
                                            block20: {
                                                if ((entry = CsvUtils.readLine(this._reader)) == null) {
                                                    if (success) {
                                                        break;
                                                    }
                                                    break block18;
                                                }
                                                if (line != true) break block20;
                                                this._log.info("skip first line");
                                                break block19;
                                            }
                                            if (entry.length != 0) break block21;
                                            this._log.info("line " + line + " is empty or comment");
                                            break block19;
                                        }
                                        if (this.checkRegel((String[])entry, Integer.toString(line))) break block22;
                                        success = false;
                                        break block19;
                                    }
                                    dbEntry = this._regelmandantDao.selectValueByRegelMandantProjectList(entry[0], entry[1], entry[2], entry[3]);
                                    update = true;
                                    if (dbEntry != null) break block23;
                                    update = false;
                                    mandant = null;
                                    if (!StringUtils.isNotEmpty(entry[1]) || (mandant = this._mandantDao.select(entry[1])) != null) break block24;
                                    new Event(EventCodeEnum.RM11, new String[]{fileName, Integer.toString(line), entry[1]});
                                    success = false;
                                    break block19;
                                }
                                dbEntry = this.createNewEntry(line, (String[])entry, mandant);
                                break block25;
                            }
                            listExisting.remove(dbEntry);
                        }
                        String oldValue = null;
                        if (update) {
                            oldValue = dbEntry.getValue();
                        }
                        boolean bl = changed = !update || !StringUtils.equals(oldValue, entry[4]);
                        if (changed) {
                            dbEntry.setValue(StringUtils.isEmpty(entry[4]) ? null : entry[4]);
                            dbEntry.setLastChange(new Date());
                            this._regelmandantDao.update(dbEntry);
                            if (update) {
                                this._log.info("changed entry at line " + line + ": " + Arrays.toString(entry));
                            } else {
                                this._log.info("new entry at line " + line + ": " + Arrays.toString(entry));
                            }
                        } else {
                            this._log.info("unchanged entry at line " + line + ": " + Arrays.toString(entry));
                        }
                    }
                    ++line;
                }
                for (RegelMandant regelMandant : listExisting) {
                    try {
                        this._log.info("delete entry " + regelMandant);
                        this._regelmandantDao.delete(regelMandant.getRegelMandantId());
                    }
                    catch (NonexistentEntityException e) {
                        throw new RuntimeException(e);
                    }
                }
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
            catch (IOException e) {
                this._log.error("error reading file", e);
                throw new DVSBaseException(new Event(EventCodeEnum.DT01, fileName));
            }
            finally {
                CsvUtils.closeReader(this._reader);
            }
        }
        if (success) {
            new Event(EventCodeEnum.RM12, fileName).writeProtokoll(null, null);
            return;
        }
        throw new DVSBaseException(new Event(EventCodeEnum.RM13, fileName));
    }

    private RegelMandant createNewEntry(int line, String[] entry, Mandant mandant) {
        RegelMandant dbEntry = new RegelMandant();
        Regel regel = this._regelDao.selectByKey(entry[0]);
        if (regel == null) {
            regel = new Regel();
            regel.setKey(entry[0]);
            regel.setRegex(RegelEnum.parse(entry[0]).getRegex());
            this._regelDao.insert(regel);
        }
        dbEntry.setRegel(regel);
        dbEntry.setProj(entry[2]);
        dbEntry.setList(entry[3]);
        dbEntry.setMandant(mandant);
        return dbEntry;
    }

    private boolean checkRegel(String[] entry, String lineStr) {
        if (entry.length != 5) {
            new Event(EventCodeEnum.RM01, this._fileName, lineStr);
            return false;
        }
        RegelEnum regelEnum = RegelEnum.parse(entry[0]);
        if (regelEnum == null) {
            new Event(EventCodeEnum.RM02, this._fileName, lineStr, entry[0]);
            return false;
        }
        if (entry[1] != null) {
            if (entry[1].length() != 2) {
                new Event(EventCodeEnum.RM03, this._fileName, lineStr, entry[1]);
                return false;
            }
            if (regelEnum.getSearchParameter() == 0) {
                new Event(EventCodeEnum.RM04, this._fileName, lineStr, entry[0]);
                return false;
            }
        }
        if (entry[2] != null) {
            if (entry[2].length() != 2) {
                new Event(EventCodeEnum.RM05, this._fileName, lineStr, entry[2]);
                return false;
            }
            if (regelEnum.getSearchParameter() != 3) {
                new Event(EventCodeEnum.RM06, this._fileName, lineStr, entry[0]);
                return false;
            }
        }
        if (entry[3] != null) {
            if (entry[3].length() != 2) {
                new Event(EventCodeEnum.RM07, this._fileName, lineStr, entry[3]);
                return false;
            }
            if (regelEnum.getSearchParameter() != 3) {
                new Event(EventCodeEnum.RM08, this._fileName, lineStr, entry[0]);
                return false;
            }
        }
        if (entry[4] != null) {
            if (!Pattern.matches(regelEnum.getRegex(), entry[4])) {
                new Event(EventCodeEnum.RM09, this._fileName, lineStr, entry[4], entry[0], regelEnum.getRegex());
                return false;
            }
        } else if (!regelEnum.isNullable()) {
            new Event(EventCodeEnum.RM10, this._fileName, lineStr, entry[0]);
            return false;
        }
        return true;
    }

    public void listdefault(OutputStream os) throws DVSBaseException {
        this._os = os;
        try {
            this.createWriter();
            for (RegelEnum regelEnum : RegelEnum.values()) {
                String[] entry = new String[5];
                entry[0] = regelEnum.getRegelKey();
                entry[4] = regelEnum.getDefaultValue();
                CsvUtils.writeLine(this._writer, entry);
            }
        }
        catch (IOException e) {
            this._log.error("error writing file", e);
            throw new DVSBaseException(new Event(EventCodeEnum.DT15, ""));
        }
        finally {
            this.closeWriter();
        }
    }
}

