/*
 * Decompiled with CFR 0.152.
 */
package at.itsv.dvs.common.dao;

import at.itsv.dvs.common.dao.IBaseDao;
import at.itsv.dvs.common.exception.NonexistentEntityException;
import at.itsv.dvs.common.utils.StringUtil;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.EntityNotFoundException;
import javax.persistence.GeneratedValue;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import org.apache.log4j.Logger;

public abstract class BaseDao<T>
implements IBaseDao<T> {
    @PersistenceContext
    private EntityManager _em;
    private Class<T> _currentClass;
    private String _currentClassName;
    protected Logger _log = Logger.getLogger(this.getClass());

    public BaseDao() {
        this._currentClass = (Class)((ParameterizedType)this.getClass().getGenericSuperclass()).getActualTypeArguments()[0];
        this._currentClassName = this._currentClass.getName();
    }

    protected String getterForEntityPrimaryKeyMethod() {
        return "get" + this.getPrimaryKey();
    }

    protected String setterForEntityPrimaryKeyMethod() {
        return "set" + this.getPrimaryKey();
    }

    private Class<T> getCurrentClass() {
        return this._currentClass;
    }

    private String getCurrentClassName() {
        return this._currentClassName;
    }

    protected EntityManager getEntityManager() {
        return this._em;
    }

    public abstract String getPrimaryKey();

    @Override
    public void insert(T entity) {
        try {
            this._em.persist(entity);
        }
        catch (RuntimeException ex) {
            try {
                Method setter;
                Method getter = this._currentClass.getDeclaredMethod(this.getterForEntityPrimaryKeyMethod(), new Class[0]);
                if (getter != null && getter.getAnnotation(GeneratedValue.class) != null && (setter = this._currentClass.getDeclaredMethod(this.setterForEntityPrimaryKeyMethod(), Long.TYPE)) != null) {
                    setter.invoke(entity, 0);
                }
            }
            catch (IllegalAccessException e) {
                this._log.error(e);
            }
            catch (IllegalArgumentException e) {
                this._log.error(e);
            }
            catch (InvocationTargetException e) {
                this._log.error(e);
            }
            catch (NoSuchMethodException e) {
                this._log.error(e);
            }
            throw ex;
        }
    }

    @Override
    public void update(T entity) {
        this._em.merge(entity);
    }

    @Override
    public void delete(Long id) throws NonexistentEntityException {
        T entity;
        try {
            entity = this._em.getReference(this.getCurrentClass(), id);
        }
        catch (EntityNotFoundException enfe) {
            throw new NonexistentEntityException("The instance with id " + id + " no longer exists.", enfe);
        }
        this._em.remove(entity);
    }

    @Override
    public T select(Long id) {
        return this._em.find(this.getCurrentClass(), id);
    }

    @Override
    public List<T> select() {
        return this.select(true, -1, -1, null, null);
    }

    @Override
    public List<T> select(String whereCond, String orderBy) {
        return this.select(true, -1, -1, whereCond, orderBy);
    }

    @Override
    public List<T> select(int maxResults, int firstResult, String whereCond, String orderBy) {
        return this.select(false, maxResults, firstResult, whereCond, orderBy);
    }

    @Override
    public List<T> select(boolean all, int maxResults, int firstResult, String whereCond, String orderBy) {
        String query = "select o from " + this.getCurrentClassName() + " o ";
        if (!StringUtil.isEmpty(whereCond)) {
            query = query + " where " + whereCond;
        }
        if (!StringUtil.isEmpty(orderBy)) {
            query = query + " order by " + orderBy;
        }
        Query q = this._em.createQuery(query);
        if (!all) {
            q.setMaxResults(maxResults);
            q.setFirstResult(firstResult);
        }
        return q.getResultList();
    }

    @Override
    public int count(String whereCond) {
        String query = "select count(o) from " + this.getCurrentClassName() + " o ";
        if (!StringUtil.isEmpty(whereCond)) {
            query = query + " WHERE " + whereCond;
        }
        Query q = this._em.createQuery(query);
        return ((Long)q.getSingleResult()).intValue();
    }
}

