/*
 * Decompiled with CFR 0.152.
 */
package at.itsv.dvs.common.dao;

import at.itsv.dvs.common.dao.BaseDao;
import at.itsv.dvs.common.dao.IBenutzerDao;
import at.itsv.dvs.common.entity.Benutzer;
import at.itsv.dvs.common.entity.Rolle;
import java.util.HashSet;
import java.util.List;
import javax.persistence.NoResultException;
import javax.persistence.Query;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Repository;

@Repository
@Qualifier(value="benutzerDao")
public class BenutzerDao
extends BaseDao<Benutzer>
implements IBenutzerDao {
    @Override
    public String getPrimaryKey() {
        return "BenutzerId";
    }

    @Override
    public void loadRolles(Benutzer entity) {
        Query query = this.getEntityManager().createNamedQuery("Rolle.selectByLogin").setParameter("login", (Object)entity.getLogin());
        List rolleList = query.getResultList();
        entity.setRolles(new HashSet<Rolle>(rolleList));
    }

    @Override
    public void saveRolles(Benutzer entity) {
        Query query = this.getEntityManager().createNamedQuery("Rolle.selectByLogin").setParameter("login", (Object)entity.getLogin());
        List rolleList = query.getResultList();
        for (Rolle rolle : rolleList) {
            boolean found = false;
            for (Rolle rolle1 : entity.getRolles()) {
                if (rolle.getRolleId() != rolle1.getRolleId()) continue;
                found = true;
                break;
            }
            if (found) continue;
            this.getEntityManager().remove(rolle);
        }
        for (Rolle rolle : entity.getRolles()) {
            if (rolle.getRolleId() != 0L) {
                this.getEntityManager().merge(rolle);
                continue;
            }
            this.getEntityManager().persist(rolle);
        }
    }

    @Override
    public Benutzer selectByLoginAndMandantId(String login, String mandantId) {
        Query query = this.getEntityManager().createNamedQuery("Benutzer.selectByLoginAndMandantId").setParameter("login", (Object)login).setParameter("mandantId", (Object)mandantId);
        try {
            return (Benutzer)query.getSingleResult();
        }
        catch (NoResultException e) {
            return null;
        }
    }
}

