/*
 * Decompiled with CFR 0.152.
 */
package at.itsv.dvs.common.dao;

import at.itsv.dvs.common.dao.BaseDao;
import at.itsv.dvs.common.dao.IBestandDao;
import at.itsv.dvs.common.dao.SearchCriteriaBestand;
import at.itsv.dvs.common.entity.Bestand;
import at.itsv.dvs.common.entity.FileBestand;
import at.itsv.dvs.common.entity.user.BestandData;
import at.itsv.dvs.common.utils.HibernateHelper;
import at.itsv.dvs.common.utils.QueryParameter;
import at.itsv.dvs.common.utils.StringUtil;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import javax.persistence.Query;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Repository;

@Repository
@Qualifier(value="bestandDao")
public class BestandDao
extends BaseDao<Bestand>
implements IBestandDao {
    @Override
    public String getPrimaryKey() {
        return "BestandId";
    }

    @Override
    public void loadFileBestands(Bestand entity) {
        Query query = this.getEntityManager().createNamedQuery("FileBestand.selectByBestandId").setParameter("bestandId", (Object)entity.getBestandId());
        List fileBestandList = query.getResultList();
        entity.setFileBestands(new HashSet<FileBestand>(fileBestandList));
    }

    @Override
    public void saveFileBestands(Bestand entity) {
        Query query = this.getEntityManager().createNamedQuery("FileBestand.selectByBestandId").setParameter("bestandId", (Object)entity.getBestandId());
        List fileBestandList = query.getResultList();
        for (FileBestand fileBestand : fileBestandList) {
            boolean found = false;
            for (FileBestand fileBestand1 : entity.getFileBestands()) {
                if (fileBestand.getFileBestandId() != fileBestand1.getFileBestandId()) continue;
                found = true;
                break;
            }
            if (found) continue;
            this.getEntityManager().remove(fileBestand);
        }
        for (FileBestand fileBestand : entity.getFileBestands()) {
            if (fileBestand.getFileBestandId() != 0L) {
                this.getEntityManager().merge(fileBestand);
                continue;
            }
            this.getEntityManager().persist(fileBestand);
        }
    }

    @Override
    public List<BestandData> findByStatusAndMandant(String status, String mandantId) {
        Query query = this.getEntityManager().createNamedQuery("Bestand.findByStatusAndMandant").setParameter("status", (Object)status).setParameter("mandantId", (Object)mandantId);
        ArrayList<BestandData> results = new ArrayList<BestandData>();
        for (Object result : query.getResultList()) {
            results.add(new BestandData((Object[])result));
        }
        return results;
    }

    @Override
    public List<Bestand> findBySearchCriteria(SearchCriteriaBestand sc) {
        LinkedList<QueryParameter> params = new LinkedList<QueryParameter>();
        StringBuffer queryBuffer = new StringBuffer();
        queryBuffer.append("SELECT b FROM Bestand b, FileBestand fb, File f WHERE fb.bestand.bestandId=b.bestandId AND fb.file.fileId=f.fileId AND f.paket IS NOT NULL");
        queryBuffer.append(" AND ").append(HibernateHelper.hqlEquals("b.status", sc.getBestandStatus(), params));
        queryBuffer.append(" AND ").append(HibernateHelper.hqlEquals("b.zvstr", sc.getBestandZvstr(), params));
        queryBuffer.append(" AND ").append(HibernateHelper.hqlEquals("b.uvstr", sc.getBestandUvstr(), params));
        queryBuffer.append(" AND ").append(HibernateHelper.hqlEquals("b.erdt", sc.getBestandErdt(), params));
        queryBuffer.append(" AND ").append(HibernateHelper.hqlEquals("b.proj", sc.getBestandProj(), params));
        queryBuffer.append(" AND ").append(HibernateHelper.hqlEquals("b.aenr", sc.getBestandAenr(), params));
        queryBuffer.append(" AND ").append(HibernateHelper.hqlEquals("b.ebnr", sc.getBestandEbnr(), params));
        queryBuffer.append(" AND ").append(HibernateHelper.hqlEquals("b.eart", sc.getBestandEart(), params));
        queryBuffer.append(" AND ").append(HibernateHelper.hqlEquals("b.list", sc.getBestandList(), params));
        queryBuffer.append(" AND ").append(HibernateHelper.hqlEquals("b.test", sc.getBestandTest(), params));
        queryBuffer.append(" AND ").append(HibernateHelper.hqlEquals("b.zvob", sc.getBestandZvob(), params));
        queryBuffer.append(" AND ").append(HibernateHelper.hqlEquals("f.paket.zvstr", sc.getPaketZvstr(), params));
        queryBuffer.append(" AND ").append(HibernateHelper.hqlEquals("f.paket.uvstr", sc.getPaketUvstr(), params));
        queryBuffer.append(" AND ").append(HibernateHelper.hqlEquals("f.paket.erdt", sc.getPaketErdt(), params));
        queryBuffer.append(" AND ").append(HibernateHelper.hqlEquals("f.paket.sddt", sc.getPaketSddt(), params));
        queryBuffer.append(" AND ").append(HibernateHelper.hqlEquals("f.paket.sdzt", sc.getPaketSdzt(), params));
        Query query = this.getEntityManager().createQuery(queryBuffer.toString());
        HibernateHelper.setQueryParameters(query, params);
        return query.getResultList();
    }

    @Override
    public List<Bestand> findToArchiv(String status, Date lastchange) {
        Query query = this.getEntityManager().createNamedQuery("Bestand.findToArchiv").setParameter("status", (Object)status).setParameter("lastchange", (Object)lastchange);
        return query.getResultList();
    }

    @Override
    public List<Bestand> findByReferenznummer(String referenzNummer) {
        Query query = this.getEntityManager().createNamedQuery("Bestand.findByReferenznummer").setParameter("referenzNummer", (Object)referenzNummer);
        return query.getResultList();
    }

    @Override
    public List<Bestand> selectForGUI(int maxResults, int firstResult, String whereCond, String orderBy) {
        List resultList = null;
        StringBuffer queryBuffer = new StringBuffer(100);
        queryBuffer.append("SELECT DISTINCT b.* FROM bestand b, file_bestand fb, file f WHERE fb.bestand_id=b.bestand_id AND fb.file_id=f.file_id ");
        if (!StringUtil.isEmpty(whereCond)) {
            queryBuffer.append(whereCond);
        }
        if (!StringUtil.isEmpty(orderBy)) {
            queryBuffer.append(" ORDER BY " + orderBy);
        }
        Query query = this.getEntityManager().createNativeQuery(queryBuffer.toString(), Bestand.class);
        if (maxResults >= 0) {
            query.setMaxResults(maxResults);
            query.setFirstResult(firstResult);
        }
        resultList = query.getResultList();
        for (Bestand bestand : resultList) {
            queryBuffer = new StringBuffer(100);
            queryBuffer.append("SELECT f FROM FileBestand fb, File f WHERE fb.file.fileId=f.fileId AND fb.bestand.bestandId=:bestandId");
            Query q = this.getEntityManager().createQuery(queryBuffer.toString());
            q.setParameter("bestandId", (Object)bestand.getBestandId());
            bestand.setFiles(q.getResultList());
        }
        return resultList;
    }

    @Override
    public int countForGUI(String whereCond) {
        StringBuffer queryBuffer = new StringBuffer(100);
        queryBuffer.append("SELECT count(DISTINCT b.*) FROM bestand b, file_bestand fb, file f WHERE fb.bestand_id=b.bestand_id AND fb.file_id=f.file_id ");
        if (!StringUtil.isEmpty(whereCond)) {
            queryBuffer.append(whereCond);
        }
        Query q = this.getEntityManager().createNativeQuery(queryBuffer.toString());
        return ((BigInteger)q.getSingleResult()).intValue();
    }
}

